/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.itrules.Adapter;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.FrameBuilderContext;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.TypesProvider;
import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.model.MogramReference;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.language.semantics.Documentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;

class MogramAdapter
extends Generator
implements Adapter<Mogram>,
TemplateTags {
    private final CompilerConfiguration.Level level;
    private Mogram initNode;
    private FrameBuilderContext context;

    MogramAdapter(String outDsl, CompilerConfiguration.Level level, Language language, Mogram initNode, String workingPackage, String languageWorkingPackage) {
        super(language, outDsl, workingPackage, languageWorkingPackage);
        this.level = level;
        this.initNode = initNode;
    }

    @Override
    public void adapt(Mogram mogram, FrameBuilderContext context) {
        this.context = context;
        TypesProvider.getTypes(mogram, this.language).forEach(context::add);
        context.add("modelType", this.level == CompilerConfiguration.Level.MetaMetaModel ? "Platform" : "Product");
        this.addNodeInfo(mogram, context);
        this.addVariables(mogram, context);
        this.addComponents(mogram, context);
        this.addNonAbstractCreates(mogram, context);
        this.addFacetClasses(mogram, context);
        this.addAllowedAspects(mogram, context);
        if (mogram.isFacet()) {
            this.addAspectConstrains(mogram, context);
            if (!(mogram.container() instanceof Model)) {
                this.addTargetComponents(mogram, context);
                this.addFacet(mogram, mogram.container(), context);
            }
        }
        this.addParent(mogram, context);
    }

    private void addFacetClasses(Mogram node, FrameBuilderContext context) {
        if (node.isReference()) {
            return;
        }
        this.facetMograms(node).forEach(m -> this.addFacetSlot(context, (Mogram)m));
    }

    private Stream<Mogram> facetMograms(Mogram node) {
        return node.components().stream().filter(n -> !n.isReference() && n.isFacet());
    }

    private void addFacetSlot(FrameBuilderContext context, Mogram aspectNode) {
        context.add("node", FrameBuilder.from(context).append(aspectNode).add("aspect").toFrame());
    }

    private void addFacet(Mogram facet, Mogram target, FrameBuilderContext context) {
        String qn = NameFormatter.cleanQn(NameFormatter.getQn(target, this.workingPackage));
        FrameBuilder builder = new FrameBuilder().add("aspect").add("name", target.name()).add("qn", qn).add("generatedLanguage", this.outDsl);
        if (facet.isSub() && facet.parent() != null) {
            builder.add("overriden");
        }
        context.add("aspect", builder.toFrame());
        context.add("core", new FrameBuilder().add("core").add("qn", qn).add("name", target.name()).toFrame());
    }

    private void addTargetComponents(Mogram facet, FrameBuilderContext context) {
        facet.container().components().stream().filter(c -> !c.isFacet()).filter(c -> !this.isOverriden((Mogram)c, facet)).forEach(c -> {
            FrameBuilder builder = FrameBuilder.from(context).append(c).add("target");
            if ((c instanceof MogramReference && !((MogramReference)c).isHas() || c instanceof MogramImpl) && c.targetOfReference().parent() != null) {
                builder.add("inherited").add("parentRef", c.targetOfReference().parent().qualifiedName());
            }
            builder.add("targetContainer", facet.container().name());
            if (facet.container().sizeOf((Mogram)c).isSingle()) {
                builder.add("single");
            }
            context.add("node", builder.toFrame());
        });
    }

    private void addNodeInfo(Mogram node, FrameBuilderContext context) {
        boolean decorable;
        context.add("generatedLanguage", this.outDsl).add("workingPackage", this.workingPackage);
        if (this.initNode != null && !node.equals(this.initNode)) {
            context.add("inner", true);
        }
        if (node.doc() != null) {
            context.add("doc", node.doc());
        }
        if (node.container() != null) {
            context.add("containerName", node.container().name());
        }
        this.addType(context, node);
        this.addName(this.context, node);
        boolean bl = decorable = node.is(Tag.Decorable) || MogramAdapter.isInDecorable(node);
        if (node.isAbstract() || decorable) {
            context.add("abstract", true);
        }
        if (decorable) {
            context.add("decorable", true);
        }
        node.flags().stream().filter(this.isLayerInterface()).forEach(tag -> context.add("flag", tag));
        if (node.parent() != null) {
            context.add("child");
        }
        if (node.components().stream().anyMatch(c -> c.is(Tag.Instance))) {
            context.add("metaType", this.languageWorkingPackage + "." + this.metaType(node));
        }
    }

    private void addNonAbstractCreates(Mogram node, FrameBuilderContext context) {
        if (node instanceof MogramReference) {
            return;
        }
        List<Mogram> components = node.components();
        components.stream().filter(c -> !c.isAnonymous()).forEach(c -> {
            ArrayList children = new ArrayList();
            this.collectChildren((Mogram)c).stream().filter(n -> !n.isAnonymous() && !n.isAbstract() && !n.isFacet() && !components.contains(n)).forEach(n -> children.add(this.createFrame(n.isReference() ? n.targetOfReference() : n)));
            for (FrameBuilder child : children) {
                context.add("create", child.add("node").add("owner").toFrame());
            }
        });
    }

    private FrameBuilder createFrame(Mogram node) {
        FrameBuilder builder = new FrameBuilder("reference", "create");
        TypesProvider.getTypes(node, this.language).forEach(builder::add);
        this.addName(builder, node);
        this.addVariables(node, builder);
        return builder;
    }

    private List<Mogram> collectChildren(Mogram parent) {
        HashSet<Mogram> set = new HashSet<Mogram>();
        for (Mogram child : parent.children()) {
            set.add(child);
            set.addAll(this.collectChildren(child));
        }
        return new ArrayList<Mogram>(set);
    }

    private void addType(FrameBuilderContext frame, Mogram node) {
        Documentation doc = this.language.doc(node.type());
        if (doc == null) {
            return;
        }
        frame.add("conceptLayer", doc.layer());
        frame.add("type", this.nodeType(node, this.sizeConstraint(node)));
    }

    private Size sizeConstraint(Mogram node) {
        Constraint.Component constraint = this.language.constraints(node.container().type()).stream().filter(c -> c instanceof Constraint.Component && ((Constraint.Component)c).type().equals(node.type())).findFirst().orElse(null);
        if (constraint == null) {
            return Size.MULTIPLE();
        }
        return (Size)constraint.rules().stream().filter(rule -> rule instanceof Size).findFirst().orElse(Size.MULTIPLE());
    }

    private String nodeType(Mogram node, Size size) {
        return Resolver.shortType(node.type()) + (!size.isSingle() ? "List" : "");
    }

    private void addAllowedAspects(Mogram node, FrameBuilderContext context) {
        this.allowedFacets(node).forEach(aspect -> {
            FrameBuilder builder = new FrameBuilder("availableAspect");
            builder.add("name", aspect.name());
            if (aspect.isAbstract()) {
                builder.add("abstract");
            }
            if (node.isAbstract()) {
                builder.add("abstract", "null");
            }
            String qn = NameFormatter.cleanQn(NameFormatter.getQn(aspect, this.workingPackage));
            builder.add("qn", qn);
            builder.add("stashQn", qn);
            aspect.variables().stream().filter(v -> v.size().isRequired()).forEach(variable -> builder.add("variable", FrameBuilder.from(context).append(variable).add("required").add("container", MogramAdapter.isInDecorable(node) ? node.qualifiedName() : node.name()).toFrame()));
            context.add("availableAspect", builder.toFrame());
        });
    }

    private Collection<Mogram> allowedFacets(Mogram node) {
        HashSet<Mogram> nodes = new HashSet<Mogram>();
        for (Mogram aspectNode : node.components().stream().filter(Mogram::isFacet).toList()) {
            if (aspectNode.isReference()) continue;
            nodes.add(aspectNode);
            nodes.addAll(this.collectChildren(aspectNode));
        }
        return nodes;
    }

    private void addName(FrameBuilderContext context, Mogram node) {
        if (node.name() != null) {
            context.add("name", node.name());
        }
        String qn = NameFormatter.cleanQn(this.buildQN(node));
        context.add("qn", qn).add("stashQn", qn);
    }

    private String buildQN(Mogram node) {
        return NameFormatter.getQn(node instanceof MogramReference ? ((MogramReference)node).destination() : node, this.workingPackage.toLowerCase());
    }

    private void addVariables(Mogram mogram, FrameBuilderContext context) {
        mogram.variables().forEach(v -> {
            FrameBuilder builder = FrameBuilder.from(this.context).add("owner").append(v).add("container", MogramAdapter.isInDecorable(mogram) ? this.completeName(mogram) : mogram.name());
            context.add("variable", builder.toFrame());
        });
        if (mogram.isFacet()) {
            mogram.container().variables().stream().filter(variable -> !variable.isInherited() && !this.isOverriden(mogram, (Variable)variable)).forEach(variable -> context.add("variable", FrameBuilder.from(context).append(variable).add("target").add("container", MogramAdapter.isInDecorable(mogram) ? this.completeName(mogram) : mogram.name()).toFrame()));
            mogram.facetConstraints().forEach(c -> c.node().variables().forEach(v -> context.add("variable", FrameBuilder.from(context).append(v).add("target").add("container", MogramAdapter.isInDecorable(mogram) ? this.completeName(mogram) : mogram.name()).toFrame())));
        }
        this.addTerminalVariables(mogram, context);
    }

    private String completeName(Mogram node) {
        return node.qualifiedName();
    }

    private boolean isOverriden(Mogram node, Variable variable) {
        return node.variables().stream().anyMatch(var -> var.name().equals(variable.name()));
    }

    private boolean isOverriden(Mogram targetNodeComponent, Mogram aspectNode) {
        return aspectNode.components().stream().anyMatch(component -> component.name() != null && component.name().equals(targetNodeComponent.name()));
    }

    private void addAspectConstrains(Mogram node, FrameBuilderContext context) {
        node.facetConstraints().forEach(c -> context.add("constraint", new FrameBuilder("constraint").add("name", c.node().name()).add("qn", NameFormatter.cleanQn(NameFormatter.getQn(c.node(), this.workingPackage))).toFrame()));
    }

    void setInitNode(Mogram initNode) {
        this.initNode = initNode;
    }
}

