/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder.compiler.codegeneration.magritte.layer;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.magritte.builder.compiler.codegeneration.magritte.Generator;
import io.intino.magritte.builder.compiler.codegeneration.magritte.NameFormatter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.TemplateTags;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.GraphTemplate;
import io.intino.magritte.builder.compiler.codegeneration.magritte.layer.LayerVariableAdapter;
import io.intino.magritte.builder.compiler.codegeneration.magritte.stash.StashCreator;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import io.intino.tara.Resolver;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.model.Model;
import io.intino.tara.builder.model.MogramImpl;
import io.intino.tara.builder.utils.Format;
import io.intino.tara.language.model.Mogram;
import io.intino.tara.language.model.Tag;
import io.intino.tara.language.model.Variable;
import io.intino.tara.language.model.rules.Size;
import io.intino.tara.language.semantics.Documentation;
import java.util.Collection;
import java.util.stream.Collectors;

public class AbstractGraphCreator
extends Generator
implements TemplateTags {
    private final CompilerConfiguration.Level modelLevel;
    private final CompilerConfiguration conf;

    public AbstractGraphCreator(Language language, CompilerConfiguration conf) {
        super(language, conf.model().outDsl(), conf.workingPackage(), conf.model().language().generationPackage());
        this.modelLevel = conf.model().level();
        this.conf = conf;
    }

    public String create(Model model) {
        FrameBuilder builder = new FrameBuilder("graph");
        builder.add("workingPackage", this.workingPackage);
        builder.add("name", this.outDsl);
        this.collectMainNodes(model).stream().filter(node -> node.name() != null).forEach(node -> builder.add("node", this.createRootNodeFrame((Mogram)node, model.sizeOf((Mogram)node))));
        Stash stash = new StashCreator(model.components(), this.language, this.outDsl, this.conf).create();
        builder.add("stash", this.stashFrame(stash));
        builder.add("parentPackage", this.languageWorkingPackage);
        return Format.customize(new GraphTemplate()).render((Object)builder.toFrame());
    }

    private Frame createRootNodeFrame(Mogram node, Size size) {
        FrameBuilder builder = new FrameBuilder("node");
        if (size.isSingle()) {
            builder.add("single");
        }
        if (node.isTerminal()) {
            builder.add("concept");
        }
        if (node.is(Tag.Instance)) {
            builder.add("instance");
        }
        if (node.isAbstract()) {
            builder.add("abstract");
        }
        String qn = NameFormatter.getQn(node, this.workingPackage.toLowerCase());
        builder.add("qn", qn).add("stashQn", qn).add("generatedLanguage", this.outDsl).add("name", node.name());
        this.addType(node, size, builder);
        node.variables().stream().filter(variable -> variable.values().isEmpty()).forEach(variable -> builder.add("variable", this.frameOf((Variable)variable)));
        this.addTerminalVariables(node, builder);
        return builder.toFrame();
    }

    private void addType(Mogram node, Size rule, FrameBuilder builder) {
        Documentation doc = this.language.doc(node.type());
        if (doc == null) {
            return;
        }
        builder.add("conceptLayer", doc.layer());
        builder.add("type", this.nodeType(node, rule));
    }

    private String nodeType(Mogram node, Size rule) {
        return Resolver.shortType(node.type()) + (!rule.isSingle() ? "List" : "");
    }

    private Frame frameOf(Variable variable) {
        return new FrameBuilder("variable", variable.type().getName()).put(Variable.class, new LayerVariableAdapter(this.language, this.outDsl, this.modelLevel, this.workingPackage, this.languageWorkingPackage)).append(variable).toFrame();
    }

    private Collection<Mogram> collectMainNodes(Model model) {
        return model.components().stream().filter(n -> !n.is(Tag.Component) && !n.into(Tag.Component) && !n.is(Tag.Feature) && !n.into(Tag.Feature) && !((MogramImpl)n).isVirtual()).collect(Collectors.toList());
    }
}

