/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.builder;

import io.intino.magritte.builder.compiler.operations.StashGenerationOperation;
import io.intino.magritte.io.StashDeserializer;
import io.intino.magritte.io.model.Stash;
import io.intino.tara.Language;
import io.intino.tara.builder.TaraCompilerRunner;
import io.intino.tara.builder.core.CompilerConfiguration;
import io.intino.tara.builder.utils.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StashBuilder {
    private final String dsl;
    private final String dslVersion;
    private final String module;
    private final List<File> files;
    private final Language language;
    private final Charset charset;
    private final PrintStream stream;
    private File workingDirectory;

    public StashBuilder(List<File> files, String dsl, String dslVersion, String module, PrintStream stream) {
        this.files = files;
        this.dsl = dsl;
        this.dslVersion = dslVersion;
        this.module = module;
        this.stream = stream;
        this.language = null;
        this.charset = StandardCharsets.UTF_8;
        try {
            this.workingDirectory = Files.createTempDirectory("_stash_builder", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StashBuilder(Map<File, Charset> files, Language language, String module, PrintStream stream) {
        this.files = new ArrayList<File>(files.keySet());
        this.charset = files.entrySet().iterator().next().getValue();
        this.language = language;
        this.dsl = language.languageName();
        this.stream = stream;
        this.dslVersion = null;
        this.module = module;
        try {
            this.workingDirectory = Files.createTempDirectory("_stash_builder", new FileAttribute[0]).toFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Stash[] build() {
        TaraCompilerRunner runner = new TaraCompilerRunner(true, List.of(StashGenerationOperation.class));
        runner.run(this.createConfiguration(), this.files.stream().collect(Collectors.toMap(f -> f, f -> true)));
        File[] createdStashes = this.findCreatedStashes();
        if (createdStashes.length == 0) {
            return null;
        }
        Stash[] stash = (Stash[])Arrays.stream(createdStashes).map(StashDeserializer::stashFrom).toArray(Stash[]::new);
        for (File createdStash : createdStashes) {
            createdStash.delete();
        }
        FileSystemUtils.removeDir(this.workingDirectory);
        return stash;
    }

    private File[] findCreatedStashes() {
        return this.workingDirectory.listFiles((dir, name) -> name.endsWith(".stash"));
    }

    private CompilerConfiguration createConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.model().level(CompilerConfiguration.Level.Model);
        configuration.languagesRepository(new File(new File(System.getProperty("user.home")), ".m2/repository"));
        configuration.setOutDirectory(this.workingDirectory);
        configuration.setResourcesDirectory(this.workingDirectory);
        configuration.setModule(this.module);
        configuration.setExcludedPhases(List.of(Integer.valueOf(1)));
        configuration.model().outDsl(this.module);
        configuration.sourceEncoding(this.charset.name());
        configuration.out(this.stream);
        if (this.language == null) {
            configuration.language(this.dsl, this.dslVersion);
        } else {
            configuration.language(this.language);
        }
        return configuration;
    }
}

