/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio2maven;

import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.confloader.Safe;
import io.intino.itrules.Engine;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.template.Template;
import io.intino.legio2maven.PomTemplate;
import io.intino.legio2maven.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class PomCreator {
    private final Configuration configuration;
    private final Configuration.Artifact.Package.Mode packageType;
    private final File rootDirectory;

    public PomCreator(Configuration configuration, File rootDirectory) {
        this.configuration = configuration;
        this.packageType = Safe.safe(() -> configuration.artifact().packageConfiguration()) == null ? null : configuration.artifact().packageConfiguration().mode();
        this.rootDirectory = rootDirectory;
    }

    public void create(File pom) {
        Configuration.Artifact.Package build = Safe.safe(() -> this.configuration.artifact().packageConfiguration());
        FrameBuilder builder = new FrameBuilder();
        this.fillMavenId(builder);
        String[] languageLevel = new String[]{"11"};
        builder.add("sdk", languageLevel[0]);
        this.fillFramework(build, builder);
        this.writePom(pom, builder.toFrame(), new PomTemplate());
    }

    private Version version() throws Exception {
        return new Version(this.configuration.artifact().version());
    }

    private void fillMavenId(FrameBuilder builder) {
        Configuration.Artifact artifact = this.configuration.artifact();
        builder.add("pom").add("groupId", artifact.groupId()).add("artifactId", artifact.name()).add("version", artifact.version());
    }

    private void fillFramework(Configuration.Artifact.Package pack, FrameBuilder builder) {
        this.fillDirectories(builder);
        builder.add("outDirectory", this.relativeToModulePath(new File(this.projectOutDirectory(), "production").getAbsolutePath()));
        builder.add("testOutDirectory", this.relativeToModulePath(new File(this.projectOutDirectory(), "test").getAbsolutePath()));
        builder.add("buildDirectory", this.relativeToModulePath(this.buildDirectory()) + "/");
        if (pack != null) {
            this.configureBuild(builder, this.configuration.artifact(), pack);
        }
        this.addPlugins(builder);
        this.addDependencies(builder);
        this.addRepositories(builder);
    }

    private void addPlugins(FrameBuilder builder) {
        this.configuration.artifact().packageConfiguration().mavenPlugins().forEach(mp -> builder.add("mavenPlugin", mp));
    }

    private String buildDirectory() {
        return this.projectOutDirectory() + File.separator + "build" + File.separator;
    }

    private String projectOutDirectory() {
        return String.valueOf(this.rootDirectory) + File.separator + "out";
    }

    private String relativeToModulePath(String path) {
        Path other = Paths.get(path, new String[0]);
        Path modulePath = this.moduleDirectory().toPath();
        try {
            return modulePath.relativize(other.toAbsolutePath()).toFile().getPath();
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    private File moduleDirectory() {
        return this.rootDirectory;
    }

    private void addDependencies(FrameBuilder builder) {
        builder.add("compile", " ");
        HashSet<String> dependencies = new HashSet<String>();
        List<Configuration.Artifact.Dependency> moduleDependencies = this.collectDependencies();
        for (Configuration.Artifact.Dependency dependency : moduleDependencies.stream().filter(d -> !d.scope().equalsIgnoreCase("test")).toList()) {
            if (!dependencies.add(dependency.identifier())) continue;
            builder.add("dependency", this.createDependencyFrame(dependency));
        }
        for (Configuration.Artifact.Dependency dependency : moduleDependencies.stream().filter(d -> d.scope().equalsIgnoreCase("test")).toList()) {
            if (dependency.toModule() && (!dependency.toModule() || !this.allModulesSeparated()) || !dependencies.add(dependency.identifier())) continue;
            builder.add("dependency", this.createDependencyFrame(dependency));
        }
    }

    private boolean allModulesSeparated() {
        return this.packageType.equals((Object)Configuration.Artifact.Package.Mode.ModulesAndLibrariesLinkedByManifest);
    }

    private List<Configuration.Artifact.Dependency> collectDependencies() {
        Configuration.Artifact.Dependency.Archetype archetype;
        List<Configuration.Artifact.Dependency> deps = new ArrayList(Safe.safeList(() -> this.configuration.artifact().dependencies())).stream().filter(d -> !(d instanceof Configuration.Artifact.Dependency.Web)).collect(Collectors.toList());
        Configuration.Artifact.Dependency.DataHub datahub = this.configuration.artifact().datahub();
        if (datahub != null) {
            deps.addFirst(datahub);
        }
        if ((archetype = this.configuration.artifact().archetype()) != null) {
            deps.addFirst(archetype);
        }
        return deps;
    }

    private void addRepositories(FrameBuilder builder) {
        this.configuration.repositories().forEach(r -> builder.add("repository", this.createRepositoryFrame((Configuration.Repository)r)));
        Configuration.Repository repository = this.distributionRepository();
        if (repository != null) {
            builder.add("repository", this.createDistributionRepositoryFrame(repository, "release"));
        }
    }

    private Configuration.Repository distributionRepository() {
        try {
            Version version = this.version();
            if (version.isSnapshot()) {
                return Safe.safe(() -> this.configuration.artifact().distribution().snapshot());
            }
            return Safe.safe(() -> this.configuration.artifact().distribution().release());
        }
        catch (Exception e) {
            Logger.error(e);
            return null;
        }
    }

    private void fillDirectories(FrameBuilder builder) {
        builder.add("sourceDirectory", this.srcDirectories());
        builder.add("resourceDirectory", this.resourceDirectories());
    }

    private String[] srcDirectories() {
        return (String[])Arrays.stream(new String[]{"src", "gen"}).filter(s -> new File(this.rootDirectory, (String)s).exists()).toArray(String[]::new);
    }

    private String[] resourceDirectories() {
        return (String[])Arrays.stream(new String[]{"res"}).filter(s -> new File(this.rootDirectory, (String)s).exists()).toArray(String[]::new);
    }

    private void configureBuild(FrameBuilder builder, Configuration.Artifact artifact, Configuration.Artifact.Package aPackage) {
        Configuration.Artifact.Package.Mode type;
        if (artifact.url() != null) {
            builder.add("url", artifact.url());
        }
        if (artifact.description() != null) {
            builder.add("description", artifact.description());
        }
        if (aPackage.attachSources()) {
            builder.add("attachSources", " ");
        }
        if (aPackage.signArtifactWithGpg()) {
            builder.add("gpgSign", " ");
        }
        if (aPackage.attachDoc()) {
            builder.add("attachJavaDoc", " ");
        }
        if (aPackage.isRunnable()) {
            if (aPackage.macOsConfiguration() != null) {
                builder.add("osx", this.osx(aPackage));
            }
            if (aPackage.windowsConfiguration() != null) {
                builder.add("windows", this.windows(aPackage));
            }
        }
        if ((type = aPackage.mode()).equals((Object)Configuration.Artifact.Package.Mode.LibrariesLinkedByManifest) || type.equals((Object)Configuration.Artifact.Package.Mode.ModulesAndLibrariesLinkedByManifest)) {
            builder.add("linkLibraries", "true");
            FrameBuilder copyDependencies = new FrameBuilder("copyDependencies");
            builder.add("copyDependencies", copyDependencies.toFrame());
            if (aPackage.classpathPrefix() != null) {
                copyDependencies.add("classpathPrefix", aPackage.classpathPrefix());
            }
        } else {
            builder.add("linkLibraries", "false").add("extractedLibraries", " ");
        }
        if (aPackage.isRunnable()) {
            builder.add("mainClass", aPackage.mainClass());
        }
        this.configuration.artifact().parameters().forEach(parameter -> this.addParameter(builder, (Configuration.Parameter)parameter));
        if (aPackage.defaultJVMOptions() != null && !aPackage.defaultJVMOptions().isEmpty()) {
            this.addMVOptions(builder, aPackage.defaultJVMOptions());
        }
        if (aPackage.finalName() != null && !aPackage.finalName().isEmpty()) {
            builder.add("finalName", aPackage.finalName());
        }
        builder.add("developer", artifact.developers().stream().map(d -> new FrameBuilder("developer").add("name", d.name()).add("email", d.email()).add("organization", d.organization()).add("organizationUrl", d.organizationUrl()).toFrame()).toArray(Frame[]::new));
        if (artifact.license() != null) {
            builder.add("license", new FrameBuilder("license", artifact.license().type().name()).toFrame());
        }
        if (artifact.license() != null) {
            Configuration.Artifact.Scm scm = artifact.scm();
            builder.add("scm", new FrameBuilder("scm").add("url", scm.url()).add("connection", scm.connection()).add("developerConnection", scm.developerConnection()).add("tag", scm.tag()).toFrame());
        }
    }

    private void addMVOptions(FrameBuilder frame, String jvmOptions) {
        frame.add("vmOptions", jvmOptions);
    }

    private void addParameter(FrameBuilder frame, Configuration.Parameter parameter) {
        FrameBuilder pFrame = new FrameBuilder("parameter").add("key", parameter.name());
        if (parameter.value() != null) {
            pFrame.add("value", parameter.value());
        }
        if (parameter.description() != null && !parameter.description().isEmpty()) {
            pFrame.add("description", parameter.description());
        }
        frame.add("parameter", pFrame.toFrame());
    }

    private Frame osx(Configuration.Artifact.Package build) {
        FrameBuilder builder = new FrameBuilder().add("mainClass", build.mainClass());
        String icon = Safe.safe(() -> build.macOsConfiguration().icon());
        if (icon != null && !icon.isEmpty()) {
            builder.add("icon", icon);
        }
        return builder.toFrame();
    }

    private Frame windows(Configuration.Artifact.Package build) {
        FrameBuilder builder = new FrameBuilder().add("mainClass", build.mainClass());
        builder.add("icon", build.windowsConfiguration().icon());
        Configuration.Artifact artifact = this.configuration.artifact();
        builder.add("name", artifact.name()).add("out", this.buildDirectory()).add("version", artifact.version());
        builder.add("prefix", build.classpathPrefix() != null ? build.classpathPrefix() : "dependency");
        return builder.toFrame();
    }

    private Frame createDependencyFrame(Configuration.Artifact.Dependency d) {
        FrameBuilder builder = new FrameBuilder("dependency").add("groupId", d.groupId()).add("scope", d.scope()).add("artifactId", d.artifactId()).add("version", d.version());
        if (!d.excludes().isEmpty()) {
            for (Configuration.Artifact.Dependency.Exclude exclude : d.excludes()) {
                builder.add("exclusion", new FrameBuilder("exclusion").add("groupId", exclude.groupId()).add("artifactId", exclude.artifactId()).toFrame());
            }
        }
        return builder.toFrame();
    }

    private Frame createDependencyFrame(String[] id) {
        return new FrameBuilder("dependency").add("groupId", id[0].toLowerCase()).add("scope", "compile").add("artifactId", id[1].toLowerCase()).add("version", id[2]).toFrame();
    }

    private Frame createRepositoryFrame(Configuration.Repository repo) {
        return new FrameBuilder("repository", repo.getClass().getSimpleName()).add("name", repo.identifier()).add("url", repo.url()).add("type", repo instanceof Configuration.Repository.Snapshot ? "-snapshot" : "").add("snapshot", repo instanceof Configuration.Repository.Snapshot).toFrame();
    }

    private Frame createDistributionRepositoryFrame(Configuration.Repository repo, String type) {
        return new FrameBuilder("repository", "distribution", type).add("url", repo.url()).add("name", repo.identifier()).add("type", "release").toFrame();
    }

    private void writePom(File pom, Frame frame, Template template) {
        try {
            Files.write(pom.toPath(), new Engine(template).render(frame).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error("Error creating pomFile to publish action: " + e.getMessage());
        }
    }
}

