/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio.model;

import io.intino.legio.model.Argument;
import io.intino.legio.model.LegioGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RunConfiguration
extends Layer
implements Terminal {
    protected String mainClass;
    protected String vmOptions;
    protected List<Argument> argumentList = new ArrayList<Argument>();

    public RunConfiguration(Node node) {
        super(node);
    }

    public String mainClass() {
        return this.mainClass;
    }

    public String vmOptions() {
        return this.vmOptions;
    }

    public RunConfiguration mainClass(String value) {
        this.mainClass = value;
        return this;
    }

    public RunConfiguration vmOptions(String value) {
        this.vmOptions = value;
        return this;
    }

    public List<Argument> argumentList() {
        return Collections.unmodifiableList(this.argumentList);
    }

    public Argument argument(int index) {
        return this.argumentList.get(index);
    }

    public List<Argument> argumentList(Predicate<Argument> predicate) {
        return this.argumentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Argument argument(Predicate<Argument> predicate) {
        return this.argumentList().stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Argument>(this.argumentList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("mainClass", new ArrayList<String>(Collections.singletonList(this.mainClass)));
        map.put("vmOptions", new ArrayList<String>(Collections.singletonList(this.vmOptions)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Argument")) {
            this.argumentList.add(node.as(Argument.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Argument")) {
            this.argumentList.remove(node.as(Argument.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("mainClass")) {
            this.mainClass = StringLoader.load(values, this).get(0);
        } else if (name.equalsIgnoreCase("vmOptions")) {
            this.vmOptions = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("mainClass")) {
            this.mainClass = (String)values.get(0);
        } else if (name.equalsIgnoreCase("vmOptions")) {
            this.vmOptions = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public LegioGraph graph() {
        return this.core$().graph().as(LegioGraph.class);
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Argument argument(String name, String value) {
            Argument newElement = RunConfiguration.this.core$().graph().concept(Argument.class).createNode(this.name, RunConfiguration.this.core$()).as(Argument.class);
            newElement.core$().set(newElement, "name", Collections.singletonList(name));
            newElement.core$().set(newElement, "value", Collections.singletonList(value));
            return newElement;
        }
    }

    public class Clear {
        public void argument(Predicate<Argument> filter) {
            new ArrayList<Argument>(RunConfiguration.this.argumentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }
}

