/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio;

import io.intino.legio.Legio;
import io.intino.legio.application.project.ApplicationFactory;
import io.intino.legio.level.project.LevelFactory;
import io.intino.legio.platform.project.PlatformFactory;
import io.intino.legio.system.project.SystemFactory;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Project
extends Layer
implements Terminal {
    protected String groupId;
    protected String version;
    protected License license;
    protected Repositories repositories;
    protected Dependencies dependencies;
    protected WebDependencies webDependencies;
    protected Factory factory;

    public Project(Node node) {
        super(node);
    }

    public String groupId() {
        return this.groupId;
    }

    public String version() {
        return this.version;
    }

    public void groupId(String value) {
        this.groupId = value;
    }

    public void version(String value) {
        this.version = value;
    }

    public License license() {
        return this.license;
    }

    public Repositories repositories() {
        return this.repositories;
    }

    public Dependencies dependencies() {
        return this.dependencies;
    }

    public WebDependencies webDependencies() {
        return this.webDependencies;
    }

    public Factory factory() {
        return this.factory;
    }

    public void license(License value) {
        this.license = value;
    }

    public void repositories(Repositories value) {
        this.repositories = value;
    }

    public void dependencies(Dependencies value) {
        this.dependencies = value;
    }

    public void webDependencies(WebDependencies value) {
        this.webDependencies = value;
    }

    public void factory(Factory value) {
        this.factory = value;
    }

    public List<Node> componentList() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
        if (this.license != null) {
            components.add(this.license.node());
        }
        if (this.repositories != null) {
            components.add(this.repositories.node());
        }
        if (this.dependencies != null) {
            components.add(this.dependencies.node());
        }
        if (this.webDependencies != null) {
            components.add(this.webDependencies.node());
        }
        if (this.factory != null) {
            components.add(this.factory.node());
        }
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("groupId", new ArrayList<String>(Collections.singletonList(this.groupId)));
        map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
        return map;
    }

    public Concept concept() {
        return this.graph().concept(Project.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("Project$License")) {
            this.license = (License)node.as(License.class);
        }
        if (node.is("Project$Repositories")) {
            this.repositories = (Repositories)node.as(Repositories.class);
        }
        if (node.is("Project$Dependencies")) {
            this.dependencies = (Dependencies)node.as(Dependencies.class);
        }
        if (node.is("Project$WebDependencies")) {
            this.webDependencies = (WebDependencies)node.as(WebDependencies.class);
        }
        if (node.is("Project$Factory")) {
            this.factory = (Factory)node.as(Factory.class);
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("Project$License")) {
            this.license = null;
        }
        if (node.is("Project$Repositories")) {
            this.repositories = null;
        }
        if (node.is("Project$Dependencies")) {
            this.dependencies = null;
        }
        if (node.is("Project$WebDependencies")) {
            this.webDependencies = null;
        }
        if (node.is("Project$Factory")) {
            this.factory = null;
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
        if (name.equalsIgnoreCase("groupId")) {
            this.groupId = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("version")) {
            this.version = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
        if (name.equalsIgnoreCase("groupId")) {
            this.groupId = (String)values.get(0);
        } else if (name.equalsIgnoreCase("version")) {
            this.version = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Legio legioWrapper() {
        return (Legio)this.graph().wrapper(Legio.class);
    }

    public static class Factory
    extends Layer
    implements Terminal {
        protected String inPackage;
        protected List<Language> languageList = new ArrayList<Language>();
        protected Interface interface$;

        public Factory(Node node) {
            super(node);
        }

        public String inPackage() {
            return this.inPackage;
        }

        public void inPackage(String value) {
            this.inPackage = value;
        }

        public List<Language> languageList() {
            return Collections.unmodifiableList(this.languageList);
        }

        public Language language(int index) {
            return this.languageList.get(index);
        }

        public List<Language> languageList(Predicate<Language> predicate) {
            return this.languageList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Interface interface$() {
            return this.interface$;
        }

        public void interface$(Interface value) {
            this.interface$ = value;
        }

        public PlatformFactory asPlatform() {
            Layer as = this.as(PlatformFactory.class);
            return as != null ? (PlatformFactory)as : (PlatformFactory)this.addFacet(PlatformFactory.class);
        }

        public boolean isPlatform() {
            return this.is(PlatformFactory.class);
        }

        public LevelFactory asLevel() {
            Layer as = this.as(LevelFactory.class);
            return as != null ? (LevelFactory)as : null;
        }

        public boolean isLevel() {
            return this.is(LevelFactory.class);
        }

        public ApplicationFactory asApplication() {
            Layer as = this.as(ApplicationFactory.class);
            return as != null ? (ApplicationFactory)as : (ApplicationFactory)this.addFacet(ApplicationFactory.class);
        }

        public boolean isApplication() {
            return this.is(ApplicationFactory.class);
        }

        public SystemFactory asSystem() {
            Layer as = this.as(SystemFactory.class);
            return as != null ? (SystemFactory)as : (SystemFactory)this.addFacet(SystemFactory.class);
        }

        public boolean isSystem() {
            return this.is(SystemFactory.class);
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            this.languageList.stream().forEach(c -> components.add(c.node()));
            if (this.interface$ != null) {
                components.add(this.interface$.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("inPackage", new ArrayList<String>(Collections.singletonList(this.inPackage)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Factory.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Project$Factory$Language")) {
                this.languageList.add((Language)node.as(Language.class));
            }
            if (node.is("Project$Factory$Interface")) {
                this.interface$ = (Interface)node.as(Interface.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Project$Factory$Language")) {
                this.languageList.remove(node.as(Language.class));
            }
            if (node.is("Project$Factory$Interface")) {
                this.interface$ = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("inPackage")) {
                this.inPackage = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("inPackage")) {
                this.inPackage = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class Interface
        extends Layer
        implements Terminal {
            protected String version;

            public Interface(Node node) {
                super(node);
            }

            public String version() {
                return this.version;
            }

            public void version(String value) {
                this.version = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Interface.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class Language
        extends Layer
        implements Terminal {
            protected String name$;
            protected String version;
            protected String effectiveVersion;

            public Language(Node node) {
                super(node);
            }

            public String name$() {
                return this.name$;
            }

            public String version() {
                return this.version;
            }

            public String effectiveVersion() {
                return this.effectiveVersion;
            }

            public void name$(String value) {
                this.name$ = value;
            }

            public void version(String value) {
                this.version = value;
            }

            public void effectiveVersion(String value) {
                this.effectiveVersion = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name$)));
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                map.put("effectiveVersion", new ArrayList<String>(Collections.singletonList(this.effectiveVersion)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Language.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name$ = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("effectiveVersion")) {
                    this.effectiveVersion = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name$ = (String)values.get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                } else if (name.equalsIgnoreCase("effectiveVersion")) {
                    this.effectiveVersion = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Language language(String name$, String version) {
                Language newElement = (Language)Factory.this.graph().concept(Language.class).createNode(this.name, Factory.this.node()).as(Language.class);
                newElement.node().set((Layer)newElement, "name", Collections.singletonList(name$));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                return newElement;
            }

            public Interface interface$(String version) {
                Interface newElement = (Interface)Factory.this.graph().concept(Interface.class).createNode(this.name, Factory.this.node()).as(Interface.class);
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                return newElement;
            }
        }
    }

    public static class WebDependencies
    extends Layer
    implements Terminal {
        protected String webDirectory;
        protected List<Resolution> resolutionList = new ArrayList<Resolution>();
        protected List<WebComponent> webComponentList = new ArrayList<WebComponent>();
        protected List<WebActivity> webActivityList = new ArrayList<WebActivity>();

        public WebDependencies(Node node) {
            super(node);
        }

        public String webDirectory() {
            return this.webDirectory;
        }

        public void webDirectory(String value) {
            this.webDirectory = value;
        }

        public List<Resolution> resolutionList() {
            return Collections.unmodifiableList(this.resolutionList);
        }

        public Resolution resolution(int index) {
            return this.resolutionList.get(index);
        }

        public List<Resolution> resolutionList(Predicate<Resolution> predicate) {
            return this.resolutionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<WebComponent> webComponentList() {
            return Collections.unmodifiableList(this.webComponentList);
        }

        public WebComponent webComponent(int index) {
            return this.webComponentList.get(index);
        }

        public List<WebComponent> webComponentList(Predicate<WebComponent> predicate) {
            return this.webComponentList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<WebActivity> webActivityList() {
            return Collections.unmodifiableList(this.webActivityList);
        }

        public WebActivity webActivity(int index) {
            return this.webActivityList.get(index);
        }

        public List<WebActivity> webActivityList(Predicate<WebActivity> predicate) {
            return this.webActivityList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.resolutionList.stream().forEach(c -> components.add(c.node()));
            this.webComponentList.stream().forEach(c -> components.add(c.node()));
            this.webActivityList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("webDirectory", new ArrayList<String>(Collections.singletonList(this.webDirectory)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(WebDependencies.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Project$WebDependencies$Resolution")) {
                this.resolutionList.add((Resolution)node.as(Resolution.class));
            }
            if (node.is("Project$WebDependencies$WebComponent")) {
                this.webComponentList.add((WebComponent)node.as(WebComponent.class));
            }
            if (node.is("Project$WebDependencies$WebActivity")) {
                this.webActivityList.add((WebActivity)node.as(WebActivity.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Project$WebDependencies$Resolution")) {
                this.resolutionList.remove(node.as(Resolution.class));
            }
            if (node.is("Project$WebDependencies$WebComponent")) {
                this.webComponentList.remove(node.as(WebComponent.class));
            }
            if (node.is("Project$WebDependencies$WebActivity")) {
                this.webActivityList.remove(node.as(WebActivity.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("webDirectory")) {
                this.webDirectory = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("webDirectory")) {
                this.webDirectory = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class WebActivity
        extends Layer
        implements Terminal {
            protected Expression<String> identifier;
            protected String groupId;
            protected String artifactId;
            protected String version;

            public WebActivity(Node node) {
                super(node);
            }

            public String identifier() {
                return (String)this.identifier.value();
            }

            public String groupId() {
                return this.groupId;
            }

            public String artifactId() {
                return this.artifactId;
            }

            public String version() {
                return this.version;
            }

            public void identifier(Expression<String> value) {
                this.identifier = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            }

            public void groupId(String value) {
                this.groupId = value;
            }

            public void artifactId(String value) {
                this.artifactId = value;
            }

            public void version(String value) {
                this.version = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("identifier", new ArrayList<Expression<String>>(Collections.singletonList(this.identifier)));
                map.put("groupId", new ArrayList<String>(Collections.singletonList(this.groupId)));
                map.put("artifactId", new ArrayList<String>(Collections.singletonList(this.artifactId)));
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(WebActivity.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("identifier")) {
                    this.identifier = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
                } else if (name.equalsIgnoreCase("groupId")) {
                    this.groupId = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("artifactId")) {
                    this.artifactId = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("identifier")) {
                    this.identifier = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
                } else if (name.equalsIgnoreCase("groupId")) {
                    this.groupId = (String)values.get(0);
                } else if (name.equalsIgnoreCase("artifactId")) {
                    this.artifactId = (String)values.get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class WebComponent
        extends Layer
        implements Terminal {
            protected String url;
            protected String version;

            public WebComponent(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public String version() {
                return this.version;
            }

            public void url(String value) {
                this.url = value;
            }

            public void version(String value) {
                this.version = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(WebComponent.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public static class Resolution
        extends Layer
        implements Terminal {
            protected String name$;
            protected String version;

            public Resolution(Node node) {
                super(node);
            }

            public String name$() {
                return this.name$;
            }

            public String version() {
                return this.version;
            }

            public void name$(String value) {
                this.name$ = value;
            }

            public void version(String value) {
                this.version = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name$)));
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Resolution.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name$ = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("name")) {
                    this.name$ = (String)values.get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Resolution resolution(String name$, String version) {
                Resolution newElement = (Resolution)WebDependencies.this.graph().concept(Resolution.class).createNode(this.name, WebDependencies.this.node()).as(Resolution.class);
                newElement.node().set((Layer)newElement, "name", Collections.singletonList(name$));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                return newElement;
            }

            public WebComponent webComponent(String version) {
                WebComponent newElement = (WebComponent)WebDependencies.this.graph().concept(WebComponent.class).createNode(this.name, WebDependencies.this.node()).as(WebComponent.class);
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                return newElement;
            }

            public WebActivity webActivity(String groupId, String artifactId, String version) {
                WebActivity newElement = (WebActivity)WebDependencies.this.graph().concept(WebActivity.class).createNode(this.name, WebDependencies.this.node()).as(WebActivity.class);
                newElement.node().set((Layer)newElement, "groupId", Collections.singletonList(groupId));
                newElement.node().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                return newElement;
            }
        }
    }

    public static class Dependencies
    extends Layer
    implements Terminal {
        protected List<Dependency> dependencyList = new ArrayList<Dependency>();
        protected List<Compile> compileList = new ArrayList<Compile>();
        protected List<Runtime> runtimeList = new ArrayList<Runtime>();
        protected List<Provided> providedList = new ArrayList<Provided>();
        protected List<Test> testList = new ArrayList<Test>();

        public Dependencies(Node node) {
            super(node);
        }

        public List<Dependency> dependencyList() {
            return Collections.unmodifiableList(this.dependencyList);
        }

        public Dependency dependency(int index) {
            return this.dependencyList.get(index);
        }

        public List<Dependency> dependencyList(Predicate<Dependency> predicate) {
            return this.dependencyList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Compile> compileList() {
            return Collections.unmodifiableList(this.compileList);
        }

        public Compile compile(int index) {
            return this.compileList.get(index);
        }

        public List<Compile> compileList(Predicate<Compile> predicate) {
            return this.compileList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Runtime> runtimeList() {
            return Collections.unmodifiableList(this.runtimeList);
        }

        public Runtime runtime(int index) {
            return this.runtimeList.get(index);
        }

        public List<Runtime> runtimeList(Predicate<Runtime> predicate) {
            return this.runtimeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Provided> providedList() {
            return Collections.unmodifiableList(this.providedList);
        }

        public Provided provided(int index) {
            return this.providedList.get(index);
        }

        public List<Provided> providedList(Predicate<Provided> predicate) {
            return this.providedList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Test> testList() {
            return Collections.unmodifiableList(this.testList);
        }

        public Test test(int index) {
            return this.testList.get(index);
        }

        public List<Test> testList(Predicate<Test> predicate) {
            return this.testList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.dependencyList.stream().forEach(c -> components.add(c.node()));
            this.compileList.stream().forEach(c -> components.add(c.node()));
            this.runtimeList.stream().forEach(c -> components.add(c.node()));
            this.providedList.stream().forEach(c -> components.add(c.node()));
            this.testList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Dependencies.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Project$Dependencies$Dependency")) {
                this.dependencyList.add((Dependency)node.as(Dependency.class));
            }
            if (node.is("Project$Dependencies$Compile")) {
                this.compileList.add((Compile)node.as(Compile.class));
            }
            if (node.is("Project$Dependencies$Runtime")) {
                this.runtimeList.add((Runtime)node.as(Runtime.class));
            }
            if (node.is("Project$Dependencies$Provided")) {
                this.providedList.add((Provided)node.as(Provided.class));
            }
            if (node.is("Project$Dependencies$Test")) {
                this.testList.add((Test)node.as(Test.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Project$Dependencies$Dependency")) {
                this.dependencyList.remove(node.as(Dependency.class));
            }
            if (node.is("Project$Dependencies$Compile")) {
                this.compileList.remove(node.as(Compile.class));
            }
            if (node.is("Project$Dependencies$Runtime")) {
                this.runtimeList.remove(node.as(Runtime.class));
            }
            if (node.is("Project$Dependencies$Provided")) {
                this.providedList.remove(node.as(Provided.class));
            }
            if (node.is("Project$Dependencies$Test")) {
                this.testList.remove(node.as(Test.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class Test
        extends Dependency
        implements Terminal {
            public Test(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Test.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Dependency.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Provided
        extends Dependency
        implements Terminal {
            public Provided(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Provided.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Dependency.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Runtime
        extends Dependency
        implements Terminal {
            public Runtime(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Runtime.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Dependency.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Compile
        extends Dependency
        implements Terminal {
            public Compile(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Compile.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Dependency.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static abstract class Dependency
        extends Layer
        implements Terminal {
            protected Expression<String> identifier;
            protected Expression<String> name$;
            protected String groupId;
            protected String artifactId;
            protected String version;
            protected String effectiveVersion;
            protected boolean transitive;
            protected List<String> artifacts = new ArrayList<String>();
            protected boolean resolved;
            protected boolean toModule;

            public Dependency(Node node) {
                super(node);
            }

            public String identifier() {
                return (String)this.identifier.value();
            }

            public String name$() {
                return (String)this.name$.value();
            }

            public String groupId() {
                return this.groupId;
            }

            public String artifactId() {
                return this.artifactId;
            }

            public String version() {
                return this.version;
            }

            public String effectiveVersion() {
                return this.effectiveVersion;
            }

            public boolean transitive() {
                return this.transitive;
            }

            public List<String> artifacts() {
                return this.artifacts;
            }

            public String artifacts(int index) {
                return this.artifacts.get(index);
            }

            public List<String> artifacts(Predicate<String> predicate) {
                return this.artifacts().stream().filter(predicate).collect(Collectors.toList());
            }

            public boolean resolved() {
                return this.resolved;
            }

            public boolean toModule() {
                return this.toModule;
            }

            public void identifier(Expression<String> value) {
                this.identifier = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            }

            public void name$(Expression<String> value) {
                this.name$ = (Expression)FunctionLoader.load(value, (Layer)this, Expression.class);
            }

            public void groupId(String value) {
                this.groupId = value;
            }

            public void artifactId(String value) {
                this.artifactId = value;
            }

            public void version(String value) {
                this.version = value;
            }

            public void effectiveVersion(String value) {
                this.effectiveVersion = value;
            }

            public void transitive(boolean value) {
                this.transitive = value;
            }

            public void resolved(boolean value) {
                this.resolved = value;
            }

            public void toModule(boolean value) {
                this.toModule = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("identifier", new ArrayList<Expression<String>>(Collections.singletonList(this.identifier)));
                map.put("name", new ArrayList<Expression<String>>(Collections.singletonList(this.name$)));
                map.put("groupId", new ArrayList<String>(Collections.singletonList(this.groupId)));
                map.put("artifactId", new ArrayList<String>(Collections.singletonList(this.artifactId)));
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                map.put("effectiveVersion", new ArrayList<String>(Collections.singletonList(this.effectiveVersion)));
                map.put("transitive", new ArrayList<Boolean>(Collections.singletonList(this.transitive)));
                map.put("artifacts", this.artifacts);
                map.put("resolved", new ArrayList<Boolean>(Collections.singletonList(this.resolved)));
                map.put("toModule", new ArrayList<Boolean>(Collections.singletonList(this.toModule)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Dependency.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("identifier")) {
                    this.identifier = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
                } else if (name.equalsIgnoreCase("name")) {
                    this.name$ = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
                } else if (name.equalsIgnoreCase("groupId")) {
                    this.groupId = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("artifactId")) {
                    this.artifactId = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("effectiveVersion")) {
                    this.effectiveVersion = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("transitive")) {
                    this.transitive = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("artifacts")) {
                    this.artifacts = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("resolved")) {
                    this.resolved = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("toModule")) {
                    this.toModule = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("identifier")) {
                    this.identifier = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
                } else if (name.equalsIgnoreCase("name")) {
                    this.name$ = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
                } else if (name.equalsIgnoreCase("groupId")) {
                    this.groupId = (String)values.get(0);
                } else if (name.equalsIgnoreCase("artifactId")) {
                    this.artifactId = (String)values.get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                } else if (name.equalsIgnoreCase("effectiveVersion")) {
                    this.effectiveVersion = (String)values.get(0);
                } else if (name.equalsIgnoreCase("transitive")) {
                    this.transitive = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("artifacts")) {
                    this.artifacts = new ArrayList(values);
                } else if (name.equalsIgnoreCase("resolved")) {
                    this.resolved = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("toModule")) {
                    this.toModule = (Boolean)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Compile compile(String groupId, String artifactId, String version, List<String> artifacts) {
                Compile newElement = (Compile)Dependencies.this.graph().concept(Compile.class).createNode(this.name, Dependencies.this.node()).as(Compile.class);
                newElement.node().set((Layer)newElement, "groupId", Collections.singletonList(groupId));
                newElement.node().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                newElement.node().set((Layer)newElement, "artifacts", artifacts);
                return newElement;
            }

            public Runtime runtime(String groupId, String artifactId, String version, List<String> artifacts) {
                Runtime newElement = (Runtime)Dependencies.this.graph().concept(Runtime.class).createNode(this.name, Dependencies.this.node()).as(Runtime.class);
                newElement.node().set((Layer)newElement, "groupId", Collections.singletonList(groupId));
                newElement.node().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                newElement.node().set((Layer)newElement, "artifacts", artifacts);
                return newElement;
            }

            public Provided provided(String groupId, String artifactId, String version, List<String> artifacts) {
                Provided newElement = (Provided)Dependencies.this.graph().concept(Provided.class).createNode(this.name, Dependencies.this.node()).as(Provided.class);
                newElement.node().set((Layer)newElement, "groupId", Collections.singletonList(groupId));
                newElement.node().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                newElement.node().set((Layer)newElement, "artifacts", artifacts);
                return newElement;
            }

            public Test test(String groupId, String artifactId, String version, List<String> artifacts) {
                Test newElement = (Test)Dependencies.this.graph().concept(Test.class).createNode(this.name, Dependencies.this.node()).as(Test.class);
                newElement.node().set((Layer)newElement, "groupId", Collections.singletonList(groupId));
                newElement.node().set((Layer)newElement, "artifactId", Collections.singletonList(artifactId));
                newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
                newElement.node().set((Layer)newElement, "artifacts", artifacts);
                return newElement;
            }
        }
    }

    public static class Repositories
    extends Layer
    implements Terminal {
        protected List<Repository> repositoryList = new ArrayList<Repository>();
        protected List<Release> releaseList = new ArrayList<Release>();
        protected Snapshot snapshot;
        protected Language language;

        public Repositories(Node node) {
            super(node);
        }

        public List<Repository> repositoryList() {
            return Collections.unmodifiableList(this.repositoryList);
        }

        public Repository repository(int index) {
            return this.repositoryList.get(index);
        }

        public List<Repository> repositoryList(Predicate<Repository> predicate) {
            return this.repositoryList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Release> releaseList() {
            return Collections.unmodifiableList(this.releaseList);
        }

        public Release release(int index) {
            return this.releaseList.get(index);
        }

        public List<Release> releaseList(Predicate<Release> predicate) {
            return this.releaseList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public Language language() {
            return this.language;
        }

        public void snapshot(Snapshot value) {
            this.snapshot = value;
        }

        public void language(Language value) {
            this.language = value;
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            this.repositoryList.stream().forEach(c -> components.add(c.node()));
            this.releaseList.stream().forEach(c -> components.add(c.node()));
            if (this.snapshot != null) {
                components.add(this.snapshot.node());
            }
            if (this.language != null) {
                components.add(this.language.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Repositories.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Project$Repositories$Repository")) {
                this.repositoryList.add((Repository)node.as(Repository.class));
            }
            if (node.is("Project$Repositories$Release")) {
                this.releaseList.add((Release)node.as(Release.class));
            }
            if (node.is("Project$Repositories$Snapshot")) {
                this.snapshot = (Snapshot)node.as(Snapshot.class);
            }
            if (node.is("Project$Repositories$Language")) {
                this.language = (Language)node.as(Language.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Project$Repositories$Repository")) {
                this.repositoryList.remove(node.as(Repository.class));
            }
            if (node.is("Project$Repositories$Release")) {
                this.releaseList.remove(node.as(Release.class));
            }
            if (node.is("Project$Repositories$Snapshot")) {
                this.snapshot = null;
            }
            if (node.is("Project$Repositories$Language")) {
                this.language = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class Language
        extends Repository
        implements Terminal {
            public Language(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Language.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Repository.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Snapshot
        extends Repository
        implements Terminal {
            public Snapshot(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Snapshot.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Repository.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Release
        extends Repository
        implements Terminal {
            public Release(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Release.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Repository.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static abstract class Repository
        extends Layer
        implements Terminal {
            protected String url;
            protected String mavenId;

            public Repository(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public String mavenId() {
                return this.mavenId;
            }

            public void url(String value) {
                this.url = value;
            }

            public void mavenId(String value) {
                this.mavenId = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                map.put("mavenId", new ArrayList<String>(Collections.singletonList(this.mavenId)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Repository.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("mavenId")) {
                    this.mavenId = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                } else if (name.equalsIgnoreCase("mavenId")) {
                    this.mavenId = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Release release(String url, String mavenId) {
                Release newElement = (Release)Repositories.this.graph().concept(Release.class).createNode(this.name, Repositories.this.node()).as(Release.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.node().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
                return newElement;
            }

            public Snapshot snapshot(String url, String mavenId) {
                Snapshot newElement = (Snapshot)Repositories.this.graph().concept(Snapshot.class).createNode(this.name, Repositories.this.node()).as(Snapshot.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.node().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
                return newElement;
            }

            public Language language(String url, String mavenId) {
                Language newElement = (Language)Repositories.this.graph().concept(Language.class).createNode(this.name, Repositories.this.node()).as(Language.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.node().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
                return newElement;
            }
        }
    }

    public static class License
    extends Layer
    implements Terminal {
        protected Type type;

        public License(Node node) {
            super(node);
        }

        public Type type() {
            return this.type;
        }

        public void type(Type value) {
            this.type = value;
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(License.class);
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }

        public static enum Type {
            GPL,
            BSD;

        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public License license(License.Type type) {
            License newElement = (License)Project.this.graph().concept(License.class).createNode(this.name, Project.this.node()).as(License.class);
            newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Repositories repositories() {
            Repositories newElement = (Repositories)Project.this.graph().concept(Repositories.class).createNode(this.name, Project.this.node()).as(Repositories.class);
            return newElement;
        }

        public Dependencies dependencies() {
            Dependencies newElement = (Dependencies)Project.this.graph().concept(Dependencies.class).createNode(this.name, Project.this.node()).as(Dependencies.class);
            return newElement;
        }

        public WebDependencies webDependencies() {
            WebDependencies newElement = (WebDependencies)Project.this.graph().concept(WebDependencies.class).createNode(this.name, Project.this.node()).as(WebDependencies.class);
            return newElement;
        }

        public Factory factory() {
            Factory newElement = (Factory)Project.this.graph().concept(Factory.class).createNode(this.name, Project.this.node()).as(Factory.class);
            return newElement;
        }
    }
}

