/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio;

import io.intino.legio.Legio;
import io.intino.legio.Parameter;
import io.intino.legio.Project;
import io.intino.legio.runnable.lifecycle.RunnablePackage;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LifeCycle
extends Layer
implements Terminal {
    protected Package package$;
    protected Distribution distribution;
    protected QualityAnalytics qualityAnalytics;
    protected Deploy deploy;

    public LifeCycle(Node node) {
        super(node);
    }

    public Package package$() {
        return this.package$;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public QualityAnalytics qualityAnalytics() {
        return this.qualityAnalytics;
    }

    public Deploy deploy() {
        return this.deploy;
    }

    public void package$(Package value) {
        this.package$ = value;
    }

    public void distribution(Distribution value) {
        this.distribution = value;
    }

    public void qualityAnalytics(QualityAnalytics value) {
        this.qualityAnalytics = value;
    }

    public void deploy(Deploy value) {
        this.deploy = value;
    }

    public List<Node> componentList() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
        if (this.package$ != null) {
            components.add(this.package$.node());
        }
        if (this.distribution != null) {
            components.add(this.distribution.node());
        }
        if (this.qualityAnalytics != null) {
            components.add(this.qualityAnalytics.node());
        }
        if (this.deploy != null) {
            components.add(this.deploy.node());
        }
        return new ArrayList<Node>(components);
    }

    public Map<String, List<?>> variables() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    public Concept concept() {
        return this.graph().concept(LifeCycle.class);
    }

    protected void addNode(Node node) {
        super.addNode(node);
        if (node.is("LifeCycle$Package")) {
            this.package$ = (Package)node.as(Package.class);
        }
        if (node.is("LifeCycle$Distribution")) {
            this.distribution = (Distribution)node.as(Distribution.class);
        }
        if (node.is("LifeCycle$QualityAnalytics")) {
            this.qualityAnalytics = (QualityAnalytics)node.as(QualityAnalytics.class);
        }
        if (node.is("LifeCycle$Deploy")) {
            this.deploy = (Deploy)node.as(Deploy.class);
        }
    }

    protected void removeNode(Node node) {
        super.removeNode(node);
        if (node.is("LifeCycle$Package")) {
            this.package$ = null;
        }
        if (node.is("LifeCycle$Distribution")) {
            this.distribution = null;
        }
        if (node.is("LifeCycle$QualityAnalytics")) {
            this.qualityAnalytics = null;
        }
        if (node.is("LifeCycle$Deploy")) {
            this.deploy = null;
        }
    }

    protected void _load(String name, List<?> values) {
        super._load(name, values);
    }

    protected void _set(String name, List<?> values) {
        super._set(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Legio legioWrapper() {
        return (Legio)this.graph().wrapper(Legio.class);
    }

    public static class Deploy
    extends Layer
    implements Terminal {
        protected String cesarURL;
        protected List<Destination> destinationList = new ArrayList<Destination>();
        protected List<Pre> preList = new ArrayList<Pre>();
        protected List<Pro> proList = new ArrayList<Pro>();

        public Deploy(Node node) {
            super(node);
        }

        public String cesarURL() {
            return this.cesarURL;
        }

        public void cesarURL(String value) {
            this.cesarURL = value;
        }

        public List<Destination> destinationList() {
            return Collections.unmodifiableList(this.destinationList);
        }

        public Destination destination(int index) {
            return this.destinationList.get(index);
        }

        public List<Destination> destinationList(Predicate<Destination> predicate) {
            return this.destinationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Pre> preList() {
            return Collections.unmodifiableList(this.preList);
        }

        public Pre pre(int index) {
            return this.preList.get(index);
        }

        public List<Pre> preList(Predicate<Pre> predicate) {
            return this.preList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Pro> proList() {
            return Collections.unmodifiableList(this.proList);
        }

        public Pro pro(int index) {
            return this.proList.get(index);
        }

        public List<Pro> proList(Predicate<Pro> predicate) {
            return this.proList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.destinationList.stream().forEach(c -> components.add(c.node()));
            this.preList.stream().forEach(c -> components.add(c.node()));
            this.proList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("cesarURL", new ArrayList<String>(Collections.singletonList(this.cesarURL)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Deploy.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("LifeCycle$Deploy$Destination")) {
                this.destinationList.add((Destination)node.as(Destination.class));
            }
            if (node.is("LifeCycle$Deploy$Pre")) {
                this.preList.add((Pre)node.as(Pre.class));
            }
            if (node.is("LifeCycle$Deploy$Pro")) {
                this.proList.add((Pro)node.as(Pro.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("LifeCycle$Deploy$Destination")) {
                this.destinationList.remove(node.as(Destination.class));
            }
            if (node.is("LifeCycle$Deploy$Pre")) {
                this.preList.remove(node.as(Pre.class));
            }
            if (node.is("LifeCycle$Deploy$Pro")) {
                this.proList.remove(node.as(Pro.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("cesarURL")) {
                this.cesarURL = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("cesarURL")) {
                this.cesarURL = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class Pro
        extends Destination
        implements Terminal {
            public Pro(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Pro.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Destination.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static class Pre
        extends Destination
        implements Terminal {
            public Pre(Node node) {
                super(node);
            }

            @Override
            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap(super.variables());
                return map;
            }

            @Override
            public Concept concept() {
                return this.graph().concept(Pre.class);
            }

            @Override
            protected void _load(String name, List<?> values) {
                super._load(name, values);
            }

            @Override
            protected void _set(String name, List<?> values) {
                super._set(name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create
            extends Destination.Create {
                public Create(String name) {
                    super(name);
                }
            }
        }

        public static abstract class Destination
        extends Layer
        implements Terminal {
            protected String specificServer;
            protected String publicURL;
            protected List<Requirements> requirementsList = new ArrayList<Requirements>();
            protected Configuration configuration;

            public Destination(Node node) {
                super(node);
            }

            public String specificServer() {
                return this.specificServer;
            }

            public String publicURL() {
                return this.publicURL;
            }

            public void specificServer(String value) {
                this.specificServer = value;
            }

            public void publicURL(String value) {
                this.publicURL = value;
            }

            public List<Requirements> requirementsList() {
                return Collections.unmodifiableList(this.requirementsList);
            }

            public Requirements requirements(int index) {
                return this.requirementsList.get(index);
            }

            public List<Requirements> requirementsList(Predicate<Requirements> predicate) {
                return this.requirementsList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Configuration configuration() {
                return this.configuration;
            }

            public void configuration(Configuration value) {
                this.configuration = value;
            }

            public List<Node> componentList() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                this.requirementsList.stream().forEach(c -> components.add(c.node()));
                if (this.configuration != null) {
                    components.add(this.configuration.node());
                }
                return new ArrayList<Node>(components);
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("specificServer", new ArrayList<String>(Collections.singletonList(this.specificServer)));
                map.put("publicURL", new ArrayList<String>(Collections.singletonList(this.publicURL)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Destination.class);
            }

            protected void addNode(Node node) {
                super.addNode(node);
                if (node.is("LifeCycle$Deploy$Destination$Requirements")) {
                    this.requirementsList.add((Requirements)node.as(Requirements.class));
                }
                if (node.is("LifeCycle$Deploy$Destination$Configuration")) {
                    this.configuration = (Configuration)node.as(Configuration.class);
                }
            }

            protected void removeNode(Node node) {
                super.removeNode(node);
                if (node.is("LifeCycle$Deploy$Destination$Requirements")) {
                    this.requirementsList.remove(node.as(Requirements.class));
                }
                if (node.is("LifeCycle$Deploy$Destination$Configuration")) {
                    this.configuration = null;
                }
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("specificServer")) {
                    this.specificServer = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("publicURL")) {
                    this.publicURL = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("specificServer")) {
                    this.specificServer = (String)values.get(0);
                } else if (name.equalsIgnoreCase("publicURL")) {
                    this.publicURL = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public static class Configuration
            extends Layer
            implements Terminal {
                protected List<Parameter> parameterList = new ArrayList<Parameter>();
                protected List<Service> serviceList = new ArrayList<Service>();
                protected Store store;

                public Configuration(Node node) {
                    super(node);
                }

                public List<Parameter> parameterList() {
                    return Collections.unmodifiableList(this.parameterList);
                }

                public Parameter parameter(int index) {
                    return this.parameterList.get(index);
                }

                public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                    return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
                }

                public List<Service> serviceList() {
                    return Collections.unmodifiableList(this.serviceList);
                }

                public Service service(int index) {
                    return this.serviceList.get(index);
                }

                public List<Service> serviceList(Predicate<Service> predicate) {
                    return this.serviceList().stream().filter(predicate).collect(Collectors.toList());
                }

                public Store store() {
                    return this.store;
                }

                public void store(Store value) {
                    this.store = value;
                }

                public List<Node> componentList() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
                    this.parameterList.stream().forEach(c -> components.add(c.node()));
                    this.serviceList.stream().forEach(c -> components.add(c.node()));
                    if (this.store != null) {
                        components.add(this.store.node());
                    }
                    return new ArrayList<Node>(components);
                }

                public Map<String, List<?>> variables() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                public Concept concept() {
                    return this.graph().concept(Configuration.class);
                }

                protected void addNode(Node node) {
                    super.addNode(node);
                    if (node.is("Parameter")) {
                        this.parameterList.add((Parameter)node.as(Parameter.class));
                    }
                    if (node.is("LifeCycle$Deploy$Destination$Configuration$Service")) {
                        this.serviceList.add((Service)node.as(Service.class));
                    }
                    if (node.is("LifeCycle$Deploy$Destination$Configuration$Store")) {
                        this.store = (Store)node.as(Store.class);
                    }
                }

                protected void removeNode(Node node) {
                    super.removeNode(node);
                    if (node.is("Parameter")) {
                        this.parameterList.remove(node.as(Parameter.class));
                    }
                    if (node.is("LifeCycle$Deploy$Destination$Configuration$Service")) {
                        this.serviceList.remove(node.as(Service.class));
                    }
                    if (node.is("LifeCycle$Deploy$Destination$Configuration$Store")) {
                        this.store = null;
                    }
                }

                protected void _load(String name, List<?> values) {
                    super._load(name, values);
                }

                protected void _set(String name, List<?> values) {
                    super._set(name, values);
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Legio legioWrapper() {
                    return (Legio)this.graph().wrapper(Legio.class);
                }

                public static class Store
                extends Layer
                implements Terminal {
                    protected String path;

                    public Store(Node node) {
                        super(node);
                    }

                    public String path() {
                        return this.path;
                    }

                    public void path(String value) {
                        this.path = value;
                    }

                    public Map<String, List<?>> variables() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
                        return map;
                    }

                    public Concept concept() {
                        return this.graph().concept(Store.class);
                    }

                    protected void _load(String name, List<?> values) {
                        super._load(name, values);
                        if (name.equalsIgnoreCase("path")) {
                            this.path = (String)StringLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void _set(String name, List<?> values) {
                        super._set(name, values);
                        if (name.equalsIgnoreCase("path")) {
                            this.path = (String)values.get(0);
                        }
                    }

                    public Create create() {
                        return new Create(null);
                    }

                    public Create create(String name) {
                        return new Create(name);
                    }

                    public Legio legioWrapper() {
                        return (Legio)this.graph().wrapper(Legio.class);
                    }

                    public class Create {
                        protected final String name;

                        public Create(String name) {
                            this.name = name;
                        }
                    }
                }

                public static class Service
                extends Layer
                implements Terminal {
                    protected List<Parameter> parameterList = new ArrayList<Parameter>();

                    public Service(Node node) {
                        super(node);
                    }

                    public List<Parameter> parameterList() {
                        return Collections.unmodifiableList(this.parameterList);
                    }

                    public Parameter parameter(int index) {
                        return this.parameterList.get(index);
                    }

                    public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                        return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
                    }

                    public List<Node> componentList() {
                        LinkedHashSet components = new LinkedHashSet(super.componentList());
                        this.parameterList.stream().forEach(c -> components.add(c.node()));
                        return new ArrayList<Node>(components);
                    }

                    public Map<String, List<?>> variables() {
                        LinkedHashMap map = new LinkedHashMap();
                        return map;
                    }

                    public Concept concept() {
                        return this.graph().concept(Service.class);
                    }

                    protected void addNode(Node node) {
                        super.addNode(node);
                        if (node.is("Parameter")) {
                            this.parameterList.add((Parameter)node.as(Parameter.class));
                        }
                    }

                    protected void removeNode(Node node) {
                        super.removeNode(node);
                        if (node.is("Parameter")) {
                            this.parameterList.remove(node.as(Parameter.class));
                        }
                    }

                    protected void _load(String name, List<?> values) {
                        super._load(name, values);
                    }

                    protected void _set(String name, List<?> values) {
                        super._set(name, values);
                    }

                    public Create create() {
                        return new Create(null);
                    }

                    public Create create(String name) {
                        return new Create(name);
                    }

                    public Legio legioWrapper() {
                        return (Legio)this.graph().wrapper(Legio.class);
                    }

                    public class Create {
                        protected final String name;

                        public Create(String name) {
                            this.name = name;
                        }

                        public Parameter parameter() {
                            Parameter newElement = (Parameter)Service.this.graph().concept(Parameter.class).createNode(this.name, Service.this.node()).as(Parameter.class);
                            return newElement;
                        }
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Parameter parameter() {
                        Parameter newElement = (Parameter)Configuration.this.graph().concept(Parameter.class).createNode(this.name, Configuration.this.node()).as(Parameter.class);
                        return newElement;
                    }

                    public Service service() {
                        Service newElement = (Service)Configuration.this.graph().concept(Service.class).createNode(this.name, Configuration.this.node()).as(Service.class);
                        return newElement;
                    }

                    public Store store(String path) {
                        Store newElement = (Store)Configuration.this.graph().concept(Store.class).createNode(this.name, Configuration.this.node()).as(Store.class);
                        newElement.node().set((Layer)newElement, "path", Collections.singletonList(path));
                        return newElement;
                    }
                }
            }

            public static class Requirements
            extends Layer
            implements Terminal {
                protected List<Memory> memoryList = new ArrayList<Memory>();
                protected List<CPU> cPUList = new ArrayList<CPU>();

                public Requirements(Node node) {
                    super(node);
                }

                public List<Memory> memoryList() {
                    return Collections.unmodifiableList(this.memoryList);
                }

                public Memory memory(int index) {
                    return this.memoryList.get(index);
                }

                public List<Memory> memoryList(Predicate<Memory> predicate) {
                    return this.memoryList().stream().filter(predicate).collect(Collectors.toList());
                }

                public List<CPU> cPUList() {
                    return Collections.unmodifiableList(this.cPUList);
                }

                public CPU cPU(int index) {
                    return this.cPUList.get(index);
                }

                public List<CPU> cPUList(Predicate<CPU> predicate) {
                    return this.cPUList().stream().filter(predicate).collect(Collectors.toList());
                }

                public List<Node> componentList() {
                    LinkedHashSet components = new LinkedHashSet(super.componentList());
                    this.memoryList.stream().forEach(c -> components.add(c.node()));
                    this.cPUList.stream().forEach(c -> components.add(c.node()));
                    return new ArrayList<Node>(components);
                }

                public Map<String, List<?>> variables() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                public Concept concept() {
                    return this.graph().concept(Requirements.class);
                }

                protected void addNode(Node node) {
                    super.addNode(node);
                    if (node.is("LifeCycle$Deploy$Destination$Requirements$Memory")) {
                        this.memoryList.add((Memory)node.as(Memory.class));
                    }
                    if (node.is("LifeCycle$Deploy$Destination$Requirements$CPU")) {
                        this.cPUList.add((CPU)node.as(CPU.class));
                    }
                }

                protected void removeNode(Node node) {
                    super.removeNode(node);
                    if (node.is("LifeCycle$Deploy$Destination$Requirements$Memory")) {
                        this.memoryList.remove(node.as(Memory.class));
                    }
                    if (node.is("LifeCycle$Deploy$Destination$Requirements$CPU")) {
                        this.cPUList.remove(node.as(CPU.class));
                    }
                }

                protected void _load(String name, List<?> values) {
                    super._load(name, values);
                }

                protected void _set(String name, List<?> values) {
                    super._set(name, values);
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Legio legioWrapper() {
                    return (Legio)this.graph().wrapper(Legio.class);
                }

                public static class CPU
                extends Layer
                implements Terminal {
                    public CPU(Node node) {
                        super(node);
                    }

                    public Map<String, List<?>> variables() {
                        LinkedHashMap map = new LinkedHashMap();
                        return map;
                    }

                    public Concept concept() {
                        return this.graph().concept(CPU.class);
                    }

                    protected void _load(String name, List<?> values) {
                        super._load(name, values);
                    }

                    protected void _set(String name, List<?> values) {
                        super._set(name, values);
                    }

                    public Create create() {
                        return new Create(null);
                    }

                    public Create create(String name) {
                        return new Create(name);
                    }

                    public Legio legioWrapper() {
                        return (Legio)this.graph().wrapper(Legio.class);
                    }

                    public class Create {
                        protected final String name;

                        public Create(String name) {
                            this.name = name;
                        }
                    }
                }

                public static class Memory
                extends Layer
                implements Terminal {
                    public Memory(Node node) {
                        super(node);
                    }

                    public Map<String, List<?>> variables() {
                        LinkedHashMap map = new LinkedHashMap();
                        return map;
                    }

                    public Concept concept() {
                        return this.graph().concept(Memory.class);
                    }

                    protected void _load(String name, List<?> values) {
                        super._load(name, values);
                    }

                    protected void _set(String name, List<?> values) {
                        super._set(name, values);
                    }

                    public Create create() {
                        return new Create(null);
                    }

                    public Create create(String name) {
                        return new Create(name);
                    }

                    public Legio legioWrapper() {
                        return (Legio)this.graph().wrapper(Legio.class);
                    }

                    public class Create {
                        protected final String name;

                        public Create(String name) {
                            this.name = name;
                        }
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Memory memory() {
                        Memory newElement = (Memory)Requirements.this.graph().concept(Memory.class).createNode(this.name, Requirements.this.node()).as(Memory.class);
                        return newElement;
                    }

                    public CPU cPU() {
                        CPU newElement = (CPU)Requirements.this.graph().concept(CPU.class).createNode(this.name, Requirements.this.node()).as(CPU.class);
                        return newElement;
                    }
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Requirements requirements() {
                    Requirements newElement = (Requirements)Destination.this.graph().concept(Requirements.class).createNode(this.name, Destination.this.node()).as(Requirements.class);
                    return newElement;
                }

                public Configuration configuration() {
                    Configuration newElement = (Configuration)Destination.this.graph().concept(Configuration.class).createNode(this.name, Destination.this.node()).as(Configuration.class);
                    return newElement;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Pre pre() {
                Pre newElement = (Pre)Deploy.this.graph().concept(Pre.class).createNode(this.name, Deploy.this.node()).as(Pre.class);
                return newElement;
            }

            public Pro pro() {
                Pro newElement = (Pro)Deploy.this.graph().concept(Pro.class).createNode(this.name, Deploy.this.node()).as(Pro.class);
                return newElement;
            }
        }
    }

    public static class QualityAnalytics
    extends Layer
    implements Terminal {
        protected String serverUrl;
        protected Authentication authentication;

        public QualityAnalytics(Node node) {
            super(node);
        }

        public String serverUrl() {
            return this.serverUrl;
        }

        public void serverUrl(String value) {
            this.serverUrl = value;
        }

        public Authentication authentication() {
            return this.authentication;
        }

        public void authentication(Authentication value) {
            this.authentication = value;
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            if (this.authentication != null) {
                components.add(this.authentication.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("serverUrl", new ArrayList<String>(Collections.singletonList(this.serverUrl)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(QualityAnalytics.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("LifeCycle$QualityAnalytics$Authentication")) {
                this.authentication = (Authentication)node.as(Authentication.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("LifeCycle$QualityAnalytics$Authentication")) {
                this.authentication = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("serverUrl")) {
                this.serverUrl = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("serverUrl")) {
                this.serverUrl = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class Authentication
        extends Layer
        implements Terminal {
            protected String token;

            public Authentication(Node node) {
                super(node);
            }

            public String token() {
                return this.token;
            }

            public void token(String value) {
                this.token = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("token", new ArrayList<String>(Collections.singletonList(this.token)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Authentication.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("token")) {
                    this.token = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("token")) {
                    this.token = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Authentication authentication(String token) {
                Authentication newElement = (Authentication)QualityAnalytics.this.graph().concept(Authentication.class).createNode(this.name, QualityAnalytics.this.node()).as(Authentication.class);
                newElement.node().set((Layer)newElement, "token", Collections.singletonList(token));
                return newElement;
            }
        }
    }

    public static class Distribution
    extends Layer
    implements Terminal {
        protected Project.Repositories.Release release;
        protected Project.Repositories.Snapshot snapshot;
        protected Project.Repositories.Language language;
        protected Bitbucket bitbucket;

        public Distribution(Node node) {
            super(node);
        }

        public Project.Repositories.Release release() {
            return this.release;
        }

        public Project.Repositories.Snapshot snapshot() {
            return this.snapshot;
        }

        public Project.Repositories.Language language() {
            return this.language;
        }

        public Bitbucket bitbucket() {
            return this.bitbucket;
        }

        public void release(Project.Repositories.Release value) {
            this.release = value;
        }

        public void snapshot(Project.Repositories.Snapshot value) {
            this.snapshot = value;
        }

        public void language(Project.Repositories.Language value) {
            this.language = value;
        }

        public void bitbucket(Bitbucket value) {
            this.bitbucket = value;
        }

        public List<Node> componentList() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList());
            if (this.release != null) {
                components.add(this.release.node());
            }
            if (this.snapshot != null) {
                components.add(this.snapshot.node());
            }
            if (this.language != null) {
                components.add(this.language.node());
            }
            if (this.bitbucket != null) {
                components.add(this.bitbucket.node());
            }
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Distribution.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("Project$Repositories$Release")) {
                this.release = (Project.Repositories.Release)node.as(Project.Repositories.Release.class);
            }
            if (node.is("Project$Repositories$Snapshot")) {
                this.snapshot = (Project.Repositories.Snapshot)node.as(Project.Repositories.Snapshot.class);
            }
            if (node.is("Project$Repositories$Language")) {
                this.language = (Project.Repositories.Language)node.as(Project.Repositories.Language.class);
            }
            if (node.is("LifeCycle$Distribution$Bitbucket")) {
                this.bitbucket = (Bitbucket)node.as(Bitbucket.class);
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("Project$Repositories$Release")) {
                this.release = null;
            }
            if (node.is("Project$Repositories$Snapshot")) {
                this.snapshot = null;
            }
            if (node.is("Project$Repositories$Language")) {
                this.language = null;
            }
            if (node.is("LifeCycle$Distribution$Bitbucket")) {
                this.bitbucket = null;
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class Bitbucket
        extends Layer
        implements Terminal {
            protected String user;
            protected String token;

            public Bitbucket(Node node) {
                super(node);
            }

            public String user() {
                return this.user;
            }

            public String token() {
                return this.token;
            }

            public void user(String value) {
                this.user = value;
            }

            public void token(String value) {
                this.token = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
                map.put("token", new ArrayList<String>(Collections.singletonList(this.token)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(Bitbucket.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("token")) {
                    this.token = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("user")) {
                    this.user = (String)values.get(0);
                } else if (name.equalsIgnoreCase("token")) {
                    this.token = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Project.Repositories.Release release(String url, String mavenId) {
                Project.Repositories.Release newElement = (Project.Repositories.Release)Distribution.this.graph().concept(Project.Repositories.Release.class).createNode(this.name, Distribution.this.node()).as(Project.Repositories.Release.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.node().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
                return newElement;
            }

            public Project.Repositories.Snapshot snapshot(String url, String mavenId) {
                Project.Repositories.Snapshot newElement = (Project.Repositories.Snapshot)Distribution.this.graph().concept(Project.Repositories.Snapshot.class).createNode(this.name, Distribution.this.node()).as(Project.Repositories.Snapshot.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.node().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
                return newElement;
            }

            public Project.Repositories.Language language(String url, String mavenId) {
                Project.Repositories.Language newElement = (Project.Repositories.Language)Distribution.this.graph().concept(Project.Repositories.Language.class).createNode(this.name, Distribution.this.node()).as(Project.Repositories.Language.class);
                newElement.node().set((Layer)newElement, "url", Collections.singletonList(url));
                newElement.node().set((Layer)newElement, "mavenId", Collections.singletonList(mavenId));
                return newElement;
            }

            public Bitbucket bitbucket(String user, String token) {
                Bitbucket newElement = (Bitbucket)Distribution.this.graph().concept(Bitbucket.class).createNode(this.name, Distribution.this.node()).as(Bitbucket.class);
                newElement.node().set((Layer)newElement, "user", Collections.singletonList(user));
                newElement.node().set((Layer)newElement, "token", Collections.singletonList(token));
                return newElement;
            }
        }
    }

    public static class Package
    extends Layer
    implements Terminal {
        protected Type type;
        protected boolean attachSources;
        protected boolean attachDoc;
        protected boolean includeTests;
        protected String classpathPrefix;
        protected String finalName;
        protected List<MavenPlugin> mavenPluginList = new ArrayList<MavenPlugin>();

        public Package(Node node) {
            super(node);
        }

        public Type type() {
            return this.type;
        }

        public boolean attachSources() {
            return this.attachSources;
        }

        public boolean attachDoc() {
            return this.attachDoc;
        }

        public boolean includeTests() {
            return this.includeTests;
        }

        public String classpathPrefix() {
            return this.classpathPrefix;
        }

        public String finalName() {
            return this.finalName;
        }

        public void type(Type value) {
            this.type = value;
        }

        public void attachSources(boolean value) {
            this.attachSources = value;
        }

        public void attachDoc(boolean value) {
            this.attachDoc = value;
        }

        public void includeTests(boolean value) {
            this.includeTests = value;
        }

        public void classpathPrefix(String value) {
            this.classpathPrefix = value;
        }

        public void finalName(String value) {
            this.finalName = value;
        }

        public List<MavenPlugin> mavenPluginList() {
            return Collections.unmodifiableList(this.mavenPluginList);
        }

        public MavenPlugin mavenPlugin(int index) {
            return this.mavenPluginList.get(index);
        }

        public List<MavenPlugin> mavenPluginList(Predicate<MavenPlugin> predicate) {
            return this.mavenPluginList().stream().filter(predicate).collect(Collectors.toList());
        }

        public RunnablePackage asRunnable() {
            return (RunnablePackage)this.as(RunnablePackage.class);
        }

        public RunnablePackage asRunnable(String mainClass) {
            RunnablePackage newElement = (RunnablePackage)this.addFacet(RunnablePackage.class);
            newElement.node().set((Layer)newElement, "mainClass", Collections.singletonList(mainClass));
            return newElement;
        }

        public boolean isRunnable() {
            return this.is(RunnablePackage.class);
        }

        public void removeRunnable() {
            this.removeFacet(RunnablePackage.class);
        }

        public List<Node> componentList() {
            LinkedHashSet components = new LinkedHashSet(super.componentList());
            this.mavenPluginList.stream().forEach(c -> components.add(c.node()));
            return new ArrayList<Node>(components);
        }

        public Map<String, List<?>> variables() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
            map.put("attachSources", new ArrayList<Boolean>(Collections.singletonList(this.attachSources)));
            map.put("attachDoc", new ArrayList<Boolean>(Collections.singletonList(this.attachDoc)));
            map.put("includeTests", new ArrayList<Boolean>(Collections.singletonList(this.includeTests)));
            map.put("classpathPrefix", new ArrayList<String>(Collections.singletonList(this.classpathPrefix)));
            map.put("finalName", new ArrayList<String>(Collections.singletonList(this.finalName)));
            return map;
        }

        public Concept concept() {
            return this.graph().concept(Package.class);
        }

        protected void addNode(Node node) {
            super.addNode(node);
            if (node.is("LifeCycle$Package$MavenPlugin")) {
                this.mavenPluginList.add((MavenPlugin)node.as(MavenPlugin.class));
            }
        }

        protected void removeNode(Node node) {
            super.removeNode(node);
            if (node.is("LifeCycle$Package$MavenPlugin")) {
                this.mavenPluginList.remove(node.as(MavenPlugin.class));
            }
        }

        protected void _load(String name, List<?> values) {
            super._load(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("attachSources")) {
                this.attachSources = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("attachDoc")) {
                this.attachDoc = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("includeTests")) {
                this.includeTests = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("classpathPrefix")) {
                this.classpathPrefix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("finalName")) {
                this.finalName = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void _set(String name, List<?> values) {
            super._set(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (Type)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("attachSources")) {
                this.attachSources = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("attachDoc")) {
                this.attachDoc = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("includeTests")) {
                this.includeTests = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("classpathPrefix")) {
                this.classpathPrefix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("finalName")) {
                this.finalName = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Legio legioWrapper() {
            return (Legio)this.graph().wrapper(Legio.class);
        }

        public static class MavenPlugin
        extends Layer
        implements Terminal {
            protected String code;

            public MavenPlugin(Node node) {
                super(node);
            }

            public String code() {
                return this.code;
            }

            public void code(String value) {
                this.code = value;
            }

            public Map<String, List<?>> variables() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("code", new ArrayList<String>(Collections.singletonList(this.code)));
                return map;
            }

            public Concept concept() {
                return this.graph().concept(MavenPlugin.class);
            }

            protected void _load(String name, List<?> values) {
                super._load(name, values);
                if (name.equalsIgnoreCase("code")) {
                    this.code = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void _set(String name, List<?> values) {
                super._set(name, values);
                if (name.equalsIgnoreCase("code")) {
                    this.code = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Legio legioWrapper() {
                return (Legio)this.graph().wrapper(Legio.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public MavenPlugin mavenPlugin(String code) {
                MavenPlugin newElement = (MavenPlugin)Package.this.graph().concept(MavenPlugin.class).createNode(this.name, Package.this.node()).as(MavenPlugin.class);
                newElement.node().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum Type {
            ModulesAndLibrariesExtracted,
            LibrariesLinkedByManifest,
            ModulesAndLibrariesLinkedByManifest;

        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Package package$(Package.Type type) {
            Package newElement = (Package)LifeCycle.this.graph().concept(Package.class).createNode(this.name, LifeCycle.this.node()).as(Package.class);
            newElement.node().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        public Distribution distribution() {
            Distribution newElement = (Distribution)LifeCycle.this.graph().concept(Distribution.class).createNode(this.name, LifeCycle.this.node()).as(Distribution.class);
            return newElement;
        }

        public QualityAnalytics qualityAnalytics(String serverUrl) {
            QualityAnalytics newElement = (QualityAnalytics)LifeCycle.this.graph().concept(QualityAnalytics.class).createNode(this.name, LifeCycle.this.node()).as(QualityAnalytics.class);
            newElement.node().set((Layer)newElement, "serverUrl", Collections.singletonList(serverUrl));
            return newElement;
        }

        public Deploy deploy(String cesarURL) {
            Deploy newElement = (Deploy)LifeCycle.this.graph().concept(Deploy.class).createNode(this.name, LifeCycle.this.node()).as(Deploy.class);
            newElement.node().set((Layer)newElement, "cesarURL", Collections.singletonList(cesarURL));
            return newElement;
        }
    }
}

