/*
 * Decompiled with CFR 0.152.
 */
package io.intino.legio;

import io.intino.legio.LifeCycle;
import io.intino.legio.Project;
import io.intino.legio.application.project.ApplicationFactory;
import io.intino.legio.level.project.LevelFactory;
import io.intino.legio.platform.project.PlatformFactory;
import io.intino.legio.runnable.lifecycle.RunnablePackage;
import io.intino.legio.system.project.SystemFactory;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class GraphWrapper
extends io.intino.tara.magritte.GraphWrapper {
    protected Graph graph;
    private Project project;
    private LifeCycle lifeCycle;
    private List<RunnablePackage> runnablePackageList;
    private List<LevelFactory> levelFactoryList;
    private List<PlatformFactory> platformFactoryList;
    private List<ApplicationFactory> applicationFactoryList;
    private List<SystemFactory> systemFactoryList;

    public GraphWrapper(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Legio");
    }

    public void update() {
        this.project = this.graph.rootList(Project.class).stream().findFirst().orElse(null);
        this.lifeCycle = this.graph.rootList(LifeCycle.class).stream().findFirst().orElse(null);
        this.runnablePackageList = this.graph.rootList(RunnablePackage.class);
        this.levelFactoryList = this.graph.rootList(LevelFactory.class);
        this.platformFactoryList = this.graph.rootList(PlatformFactory.class);
        this.applicationFactoryList = this.graph.rootList(ApplicationFactory.class);
        this.systemFactoryList = this.graph.rootList(SystemFactory.class);
    }

    protected void addNode(Node node) {
        if (node.is("Project")) {
            this.project = (Project)node.as(Project.class);
        }
        if (node.is("LifeCycle")) {
            this.lifeCycle = (LifeCycle)node.as(LifeCycle.class);
        }
        if (node.is("Runnable#LifeCycle$Package")) {
            this.runnablePackageList.add((RunnablePackage)node.as(RunnablePackage.class));
        }
        if (node.is("Level#Project$Factory")) {
            this.levelFactoryList.add((LevelFactory)node.as(LevelFactory.class));
        }
        if (node.is("Platform#Project$Factory")) {
            this.platformFactoryList.add((PlatformFactory)node.as(PlatformFactory.class));
        }
        if (node.is("Application#Project$Factory")) {
            this.applicationFactoryList.add((ApplicationFactory)node.as(ApplicationFactory.class));
        }
        if (node.is("System#Project$Factory")) {
            this.systemFactoryList.add((SystemFactory)node.as(SystemFactory.class));
        }
    }

    protected void removeNode(Node node) {
        if (node.is("Project")) {
            this.project = null;
        }
        if (node.is("LifeCycle")) {
            this.lifeCycle = null;
        }
        if (node.is("Runnable#LifeCycle$Package")) {
            this.runnablePackageList.remove(node.as(RunnablePackage.class));
        }
        if (node.is("Level#Project$Factory")) {
            this.levelFactoryList.remove(node.as(LevelFactory.class));
        }
        if (node.is("Platform#Project$Factory")) {
            this.platformFactoryList.remove(node.as(PlatformFactory.class));
        }
        if (node.is("Application#Project$Factory")) {
            this.applicationFactoryList.remove(node.as(ApplicationFactory.class));
        }
        if (node.is("System#Project$Factory")) {
            this.systemFactoryList.remove(node.as(SystemFactory.class));
        }
    }

    public String message(String language, String key, Object ... parameters) {
        return this.graph.i18n().message(language, key, parameters);
    }

    public URL resourceAsMessage(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public Map<String, String> keysIn(String language) {
        return this.graph.i18n().wordsIn(language);
    }

    public Concept concept(String concept) {
        return this.graph.concept(concept);
    }

    public Concept concept(Class<? extends Layer> layerClass) {
        return this.graph.concept(layerClass);
    }

    public List<Concept> conceptList() {
        return this.graph.conceptList();
    }

    public List<Concept> conceptList(Predicate<Concept> predicate) {
        return this.graph.conceptList(predicate);
    }

    public Node createRoot(Concept concept, String namespace) {
        return this.graph.createRoot(concept, namespace);
    }

    public <T extends Layer> T createRoot(Class<T> layerClass, String namespace) {
        return (T)this.graph.createRoot(layerClass, namespace);
    }

    public Node createRoot(String concept, String namespace) {
        return this.graph.createRoot(concept, namespace);
    }

    public <T extends Layer> T createRoot(Class<T> layerClass, String namespace, String id) {
        return (T)this.graph.createRoot(layerClass, namespace, id);
    }

    public Node createRoot(String concept, String namespace, String id) {
        return this.graph.createRoot(concept, namespace, id);
    }

    public Node createRoot(Concept concept, String namespace, String id) {
        return this.graph.createRoot(concept, namespace, id);
    }

    public Project project() {
        return this.project;
    }

    public LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public List<RunnablePackage> runnablePackageList() {
        return this.runnablePackageList;
    }

    public List<LevelFactory> levelFactoryList() {
        return this.levelFactoryList;
    }

    public List<PlatformFactory> platformFactoryList() {
        return this.platformFactoryList;
    }

    public List<ApplicationFactory> applicationFactoryList() {
        return this.applicationFactoryList;
    }

    public List<SystemFactory> systemFactoryList() {
        return this.systemFactoryList;
    }

    public List<RunnablePackage> runnablePackageList(Predicate<RunnablePackage> predicate) {
        return this.runnablePackageList.stream().filter(predicate).collect(Collectors.toList());
    }

    public RunnablePackage runnablePackage(int index) {
        return this.runnablePackageList.get(index);
    }

    public List<LevelFactory> levelFactoryList(Predicate<LevelFactory> predicate) {
        return this.levelFactoryList.stream().filter(predicate).collect(Collectors.toList());
    }

    public LevelFactory levelFactory(int index) {
        return this.levelFactoryList.get(index);
    }

    public List<PlatformFactory> platformFactoryList(Predicate<PlatformFactory> predicate) {
        return this.platformFactoryList.stream().filter(predicate).collect(Collectors.toList());
    }

    public PlatformFactory platformFactory(int index) {
        return this.platformFactoryList.get(index);
    }

    public List<ApplicationFactory> applicationFactoryList(Predicate<ApplicationFactory> predicate) {
        return this.applicationFactoryList.stream().filter(predicate).collect(Collectors.toList());
    }

    public ApplicationFactory applicationFactory(int index) {
        return this.applicationFactoryList.get(index);
    }

    public List<SystemFactory> systemFactoryList(Predicate<SystemFactory> predicate) {
        return this.systemFactoryList.stream().filter(predicate).collect(Collectors.toList());
    }

    public SystemFactory systemFactory(int index) {
        return this.systemFactoryList.get(index);
    }

    public Graph graph() {
        return this.graph;
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String namespace) {
        return new Create(namespace, null);
    }

    public Create create(String namespace, String name) {
        return new Create(namespace, name);
    }

    public class Create {
        private final String namespace;
        private final String name;

        public Create(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public Project project(String groupId, String version) {
            Project newElement = (Project)((Project)GraphWrapper.this.graph.createRoot(Project.class, this.namespace, this.name)).as(Project.class);
            newElement.node().set((Layer)newElement, "groupId", Collections.singletonList(groupId));
            newElement.node().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public LifeCycle lifeCycle() {
            LifeCycle newElement = (LifeCycle)((LifeCycle)GraphWrapper.this.graph.createRoot(LifeCycle.class, this.namespace, this.name)).as(LifeCycle.class);
            return newElement;
        }

        public RunnablePackage runnablePackage(String mainClass) {
            RunnablePackage newElement = (RunnablePackage)((RunnablePackage)GraphWrapper.this.graph.createRoot(RunnablePackage.class, this.namespace, this.name)).as(RunnablePackage.class);
            newElement.node().set((Layer)newElement, "mainClass", Collections.singletonList(mainClass));
            return newElement;
        }

        public PlatformFactory platformFactory() {
            PlatformFactory newElement = (PlatformFactory)((PlatformFactory)GraphWrapper.this.graph.createRoot(PlatformFactory.class, this.namespace, this.name)).as(PlatformFactory.class);
            return newElement;
        }

        public ApplicationFactory applicationFactory() {
            ApplicationFactory newElement = (ApplicationFactory)((ApplicationFactory)GraphWrapper.this.graph.createRoot(ApplicationFactory.class, this.namespace, this.name)).as(ApplicationFactory.class);
            return newElement;
        }

        public SystemFactory systemFactory() {
            SystemFactory newElement = (SystemFactory)((SystemFactory)GraphWrapper.this.graph.createRoot(SystemFactory.class, this.namespace, this.name)).as(SystemFactory.class);
            return newElement;
        }
    }
}

