/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.ls.codeinsight.completion.CompletionContext;
import io.intino.ls.codeinsight.completion.CompletionProvider;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.semantics.Annotations;
import io.intino.tara.model.Annotation;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public class AnnotationCompletionProvider
implements CompletionProvider {
    @Override
    public void addCompletions(CompletionContext context, List<CompletionItem> result) {
        ParserRuleContext rule = context.ruleOnPosition();
        if (rule instanceof TaraGrammar.AnnotationsContext) {
            rule = rule.getParent();
        }
        if (rule instanceof TaraGrammar.SignatureContext) {
            this.addMogramAnnotations(result);
        } else if (rule instanceof TaraGrammar.MogramReferenceContext) {
            this.addHasAnnotations(result);
        } else if (rule != null) {
            this.addPropertyAnnotations(result);
        }
    }

    private void addPropertyAnnotations(List<CompletionItem> result) {
        Annotations.forProperty().stream().map(this::createCompletionItem).forEach(result::add);
    }

    private void addHasAnnotations(List<CompletionItem> result) {
        Annotations.forMogramReference().stream().map(this::createCompletionItem).forEach(result::add);
    }

    private void addMogramAnnotations(List<CompletionItem> result) {
        Annotations.forRootMogram().stream().filter(a -> a == Annotation.Component || a == Annotation.Generalization || a == Annotation.Private).map(this::createCompletionItem).forEach(result::add);
    }

    private CompletionItem createCompletionItem(Annotation annotation) {
        CompletionItem item = new CompletionItem(annotation.name().toLowerCase());
        item.setInsertText(annotation.name().toLowerCase());
        item.setKind(CompletionItemKind.Event);
        return item;
    }
}

