/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.codeinsight.completion;

import io.intino.ls.codeinsight.completion.CompletionContext;
import io.intino.ls.codeinsight.completion.TreeUtils;
import io.intino.tara.Language;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.semantics.Constraint;
import io.intino.tara.model.ElementContainer;
import io.intino.tara.model.Facet;
import io.intino.tara.model.Level;
import io.intino.tara.model.Mogram;
import io.intino.tara.model.Primitive;
import io.intino.tara.model.PropertyDescription;
import io.intino.tara.model.rules.Size;
import io.intino.tara.model.rules.property.ReferenceRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public class CompletionUtils {
    private final CompletionContext context;
    private final Language language;

    public CompletionUtils(CompletionContext context) {
        this.context = context;
        this.language = context.language();
    }

    List<CompletionItem> collectAllowedFacets(Mogram mogram) {
        if (this.language == null) {
            return List.of();
        }
        String type = (String)mogram.types().get(0);
        if (type == null) {
            return List.of();
        }
        List constraints = this.context.language().constraints(type);
        if (constraints == null) {
            return List.of();
        }
        return this.buildCompletionForFacets(constraints, mogram);
    }

    List<CompletionItem> collectAllowedComponents(ElementContainer container) {
        Mogram m;
        String type;
        if (container instanceof Mogram) {
            Mogram m2 = (Mogram)container;
            v0 = (String)m2.types().get(0);
        } else {
            v0 = type = "";
        }
        if (type == null) {
            return List.of();
        }
        List mogramConstraints = this.language.constraints(type);
        if (mogramConstraints == null) {
            return List.of();
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(mogramConstraints);
        if (container instanceof Mogram) {
            Mogram m3 = (Mogram)container;
            constraints.addAll(this.constraintsOf(this.facetConstraints(mogramConstraints, m3.appliedFacets())));
        }
        ArrayList<Constraint.Component> components = new ArrayList<Constraint.Component>(CompletionUtils.componentConstraints(constraints).stream().filter(c -> this.isSizeAccepted((Constraint.Component)c, container)).toList());
        if (container instanceof Mogram && (m = (Mogram)container).level().equals((Object)Level.M2)) {
            components.addAll(constraints.stream().filter(c -> c instanceof Constraint.Facet && this.hasFacet(container, (Constraint.Facet)c)).flatMap(c -> ((Constraint.Facet)c).constraints().stream().filter(cs -> cs instanceof Constraint.Component).map(cst -> (Constraint.Component)cst)).filter(c -> this.isSizeAccepted((Constraint.Component)c, container)).toList());
        }
        if (components.isEmpty()) {
            return List.of();
        }
        return this.createCompletionForComponents(components);
    }

    private static List<Constraint.Component> componentConstraints(List<Constraint> constraints) {
        return constraints.stream().filter(c -> c instanceof Constraint.Component).map(c -> (Constraint.Component)c).collect(Collectors.toList());
    }

    private List<Constraint> constraintsOf(List<Constraint> constraints) {
        return constraints.stream().flatMap(constraint -> ((Constraint.Facet)constraint).constraints().stream()).collect(Collectors.toList());
    }

    List<CompletionItem> collectBodyProperties(Mogram mogram) {
        if (this.language == null || mogram == null) {
            return null;
        }
        return this.buildCompletionForParameters(this.parameterConstraintsOf(mogram, true), mogram.parameters());
    }

    List<CompletionItem> collectSignatureParameters(Mogram mogram) {
        if (this.language == null || mogram == null) {
            return null;
        }
        String facet = this.isInFacet(this.context.ruleOnPosition(), mogram);
        List<Constraint.Property> propConstraints = facet != null ? this.collectParameterConstraints(mogram, facet) : this.parameterConstraintsOf(mogram, false);
        return this.buildCompletionForParameters(propConstraints, CompletionUtils.removeFakes(mogram));
    }

    private static List<PropertyDescription> removeFakes(Mogram mogram) {
        return mogram.parameters().stream().filter(p -> !p.values().isEmpty() && !p.values().get(0).toString().equals("Tara_Fake_Token")).toList();
    }

    private String isInFacet(ParserRuleContext ruleContext, Mogram mogram) {
        TaraGrammar.FacetContext facetContext = TreeUtils.contextByType(this.context.ruleOnPosition(), TaraGrammar.FacetContext.class);
        if (facetContext == null) {
            return null;
        }
        String facetType = facetContext.metaidentifier().getText();
        return mogram.appliedFacets().stream().filter(f -> f.type().equals(facetType)).map(f -> f.fullType()).findFirst().orElse(null);
    }

    private List<Constraint.Property> parameterConstraintsOf(Mogram mogram, boolean withFacet) {
        List constraints = this.language.constraints((String)mogram.types().get(0));
        if (constraints == null) {
            return Collections.emptyList();
        }
        ArrayList<Constraint.Property> parameters = new ArrayList<Constraint.Property>();
        for (Constraint constraint : constraints) {
            if (constraint instanceof Constraint.Property) {
                parameters.add((Constraint.Property)constraint);
                continue;
            }
            if (!(constraint instanceof Constraint.Facet) || !withFacet || !this.hasFacet((ElementContainer)mogram, (Constraint.Facet)constraint)) continue;
            parameters.addAll(((Constraint.Facet)constraint).constraints().stream().filter(c -> c instanceof Constraint.Property).map(c -> (Constraint.Property)c).toList());
        }
        return parameters;
    }

    private List<Constraint.Property> collectParameterConstraints(Mogram mogram, String facet) {
        List<Constraint> coreConstraints;
        List<Constraint> scopeConstraints = coreConstraints = this.language.constraints((String)mogram.types().getFirst());
        if (facet != null) {
            scopeConstraints = this.collectFacetParameterConstraints(coreConstraints, facet);
        }
        return scopeConstraints.stream().filter(constraint -> constraint instanceof Constraint.Property).map(constraint -> (Constraint.Property)constraint).toList();
    }

    private List<Constraint> collectFacetParameterConstraints(List<Constraint> constraints, String type) {
        return constraints.stream().filter(c -> c instanceof Constraint.Facet && ((Constraint.Facet)c).type().equals(type)).map(c -> ((Constraint.Facet)c).constraints()).findFirst().orElse(List.of());
    }

    private boolean isSizeAccepted(Constraint.Component component, ElementContainer container) {
        long count = container.components().stream().filter(c -> component.type().equals(c.types().get(0)) || CompletionUtils.shortType(component.type()).equals(c.types().get(0))).count();
        return component.rules().stream().filter(r -> r instanceof Size).allMatch(r -> (long)((Size)r).max() > count);
    }

    private List<Constraint> facetConstraints(List<Constraint> mogramConstraints, List<Facet> facets) {
        List<String> facetTypes = facets.stream().map(Facet::fullType).toList();
        ArrayList<Constraint> list = new ArrayList<Constraint>();
        if (mogramConstraints == null) {
            return list;
        }
        for (Constraint constraint : mogramConstraints) {
            Constraint.Facet f;
            if (!(constraint instanceof Constraint.Facet) || !facetTypes.contains((f = (Constraint.Facet)constraint).type())) continue;
            list.add(constraint);
        }
        return list;
    }

    private List<CompletionItem> createCompletionForComponents(List<Constraint.Component> constraints) {
        HashSet added = new HashSet();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (Constraint.Component constraint : constraints) {
            if (constraint instanceof Constraint.OneOf) {
                items.addAll(this.createCompletionItem((Constraint.OneOf)constraint));
                continue;
            }
            items.add(this.createCompletionItem(constraint));
        }
        return items.stream().filter(c -> added.add(c.getInsertText())).collect(Collectors.toList());
    }

    private List<CompletionItem> buildCompletionForFacets(List<Constraint> constraints, Mogram mogram) {
        HashSet added = new HashSet();
        return constraints.stream().filter(c -> c instanceof Constraint.Facet && !this.hasFacet((ElementContainer)mogram, (Constraint.Facet)c)).map(c -> this.createCompletionItem((Constraint.Facet)c)).filter(l -> added.add(l.getInsertText())).collect(Collectors.toList());
    }

    private List<CompletionItem> buildCompletionForParameters(List<Constraint.Property> constraints, List<PropertyDescription> currentProps) {
        HashSet added = new HashSet();
        return constraints.stream().filter(c -> c != null).map(this::createCompletionItem).filter(l -> added.add(l.getInsertText())).collect(Collectors.toList());
    }

    private boolean hasFacet(ElementContainer container, Constraint.Facet f) {
        Mogram m;
        return container instanceof Mogram && (m = (Mogram)container).appliedFacets().stream().anyMatch(facet -> Objects.equals(facet.type(), f.type()) || Objects.equals(facet.fullType(), f.type()));
    }

    private List<CompletionItem> createCompletionItem(Constraint.OneOf constraint) {
        return constraint.components().stream().map(this::createCompletionItem).collect(Collectors.toList());
    }

    private String lastTypeOf(String fullType) {
        String[] splittedType = fullType.split(":");
        String type = splittedType[splittedType.length - 1];
        return type.contains(".") ? type.substring(type.lastIndexOf(46) + 1) : type;
    }

    private CompletionItem createCompletionItem(Constraint.Component constraint) {
        CompletionItem item = new CompletionItem(this.lastTypeOf(constraint.type()));
        item.setKind(CompletionItemKind.Class);
        item.setInsertText(this.lastTypeOf(constraint.type()) + " ");
        return item;
    }

    private CompletionItem createCompletionItem(Constraint.Facet facet) {
        String simpleType = this.simpleType(facet.type());
        CompletionItem item = new CompletionItem("facet " + simpleType);
        item.setKind(CompletionItemKind.Interface);
        item.setInsertText(simpleType);
        return item;
    }

    private String simpleType(String type) {
        return type.contains(".") ? type.substring(type.lastIndexOf(46) + 1) : type;
    }

    private boolean contains(List<PropertyDescription> parameters, String name) {
        return parameters.stream().anyMatch(p -> name.equals(p.name()));
    }

    private CompletionItem createCompletionItem(Constraint.Property c) {
        CompletionItem item = new CompletionItem(CompletionUtils.type(c) + " " + c.name() + CompletionUtils.facetContext(c));
        item.setInsertText(c.name() + " = ");
        item.setKind(CompletionItemKind.Property);
        return item;
    }

    private static String type(Constraint.Property c) {
        return c.type().equals((Object)Primitive.REFERENCE) ? CompletionUtils.refrenceType(c) : c.type().getName();
    }

    private static String refrenceType(Constraint.Property c) {
        ReferenceRule referenceRule = c.rules().stream().filter(r -> r instanceof ReferenceRule).map(ReferenceRule.class::cast).findFirst().orElse(null);
        if (referenceRule != null) {
            return (String)referenceRule.allowedReferences().getFirst();
        }
        return c.type().getName();
    }

    private static String facetContext(Constraint.Property c) {
        String facet = c.facet();
        return facet.isEmpty() ? "" : " (" + facet + ")";
    }

    private static String shortType(String type) {
        String[] s = type.split("\\.");
        return s[s.length - 1];
    }
}

