/*
 * Decompiled with CFR 0.152.
 */
package io.intino.ls.parsing;

import io.intino.ls.DocumentHelper;
import io.intino.ls.ModelUnit;
import io.intino.ls.parsing.Parser;
import io.intino.ls.parsing.ParserErrorStrategy;
import io.intino.tara.Source;
import io.intino.tara.language.grammar.SyntaxException;
import io.intino.tara.language.grammar.TaraGrammar;
import io.intino.tara.language.semantics.errorcollector.SemanticException;
import io.intino.tara.processors.dependencyresolution.DependencyException;
import io.intino.tara.processors.model.Model;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;

public class ParsingService {
    private final Map<URI, ModelUnit> models;

    public ParsingService(Map<URI, ModelUnit> models) {
        this.models = models;
    }

    public synchronized void updateModel(Source source) {
        if (!DocumentHelper.isTaraModel(source.uri().getPath())) {
            return;
        }
        Model model = null;
        CommonTokenStream tokenStream = null;
        TaraGrammar.RootContext tree = null;
        ParserErrorStrategy strategy = new ParserErrorStrategy();
        ArrayList<SyntaxException> syntaxErrors = new ArrayList<SyntaxException>();
        Parser parser = new Parser(source, strategy);
        try {
            tokenStream = parser.tokens();
            tree = parser.parse(tokenStream);
            model = new Parser(source).convert(tree);
        }
        catch (SyntaxException e) {
            syntaxErrors.add(e);
        }
        catch (Exception e) {
            syntaxErrors.add(new SyntaxException(e.getMessage(), source.uri(), 0, 0, ""));
        }
        syntaxErrors.addAll(strategy.errors());
        this.models.put(source.uri(), new ModelUnit(model, (TokenStream)tokenStream, tree, syntaxErrors, new ArrayList<DependencyException>(), new ArrayList<SemanticException>()));
    }
}

