/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos;

import io.intino.konos.Info;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

class RESTAccessor {
    private String protocol;
    private String host;
    private int port;
    private String cookie = null;
    private SSLContext sslContext = null;

    RESTAccessor(String protocol, String host, int port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        if (this.protocol.equals("https")) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                }};
                this.sslContext = SSLContext.getInstance("SSL");
                this.sslContext.init(null, trustAllCerts, new SecureRandom());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void post(String operation, List<NameValuePair> parameters, MultipartEntityBuilder files, OutputStream resultStream) throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().setSslcontext(this.sslContext).build();
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(this.protocol).setHost(this.host).setPort(this.port).setPath("/" + operation).setParameters(parameters);
        HttpPost request = new HttpPost(uriBuilder.build());
        request.setEntity(files.build());
        request.setHeader("Cookie", this.cookie);
        HttpResponse response = client.execute((HttpUriRequest)request);
        if (response.getHeaders("Set-Cookie").length > 0) {
            this.cookie = response.getHeaders("Set-Cookie")[0].getValue();
        }
        if (response.getStatusLine().getStatusCode() >= 500) {
            throw new Exception(this.extractErrorMessage(IOUtils.toString((InputStream)response.getEntity().getContent())));
        }
        response.getEntity().writeTo(resultStream);
    }

    private String extractErrorMessage(String json) {
        try {
            Info info = new Info(json);
            return info.getSubject() + "\nDetails: " + info.getBody();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

