/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos;

import io.intino.konos.RESTAccessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.message.BasicNameValuePair;

public class Mail {
    private RESTAccessor accessor;

    public Mail(URL url, int port) {
        this.accessor = new RESTAccessor("http", url.getHost(), port);
    }

    public String send(String to, String subject, String body, File ... attach) throws Exception {
        return this.send(to, subject, body, "", "", attach);
    }

    public String send(String to, String subject, String body, String cc, File ... attach) throws Exception {
        return this.send(to, subject, body, cc, "", attach);
    }

    public String send(String to, String subject, String body, String cc, String bcc, File ... attach) throws Exception {
        MultipartEntityBuilder files = MultipartEntityBuilder.create();
        for (File file : attach) {
            files.addPart(file.getName(), (ContentBody)new FileBody(file));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.accessor.post("send", this.parameters(to, subject, body, cc, bcc), files, outputStream);
        return outputStream.toString();
    }

    private List<NameValuePair> parameters(String to, String subject, String body, String cc, String bcc) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        parameters.add((NameValuePair)new BasicNameValuePair("to", to));
        if (subject != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("subject", subject));
        }
        if (body != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("body", body));
        }
        if (cc != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("cc", cc));
        }
        if (bcc != null) {
            parameters.add((NameValuePair)new BasicNameValuePair("bcc", bcc));
        }
        return parameters;
    }
}

