/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.slack;

import com.ullink.slack.simpleslackapi.SlackAttachment;
import com.ullink.slack.simpleslackapi.SlackChannel;
import com.ullink.slack.simpleslackapi.SlackFile;
import com.ullink.slack.simpleslackapi.SlackSession;
import com.ullink.slack.simpleslackapi.SlackUser;
import com.ullink.slack.simpleslackapi.events.SlackMessagePosted;
import com.ullink.slack.simpleslackapi.impl.SlackSessionFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class Bot {
    private static Logger logger = Logger.getGlobal();
    protected Map<String, Context> usersContext = new LinkedHashMap<String, Context>();
    private final String token;
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private final Map<String, CommandInfo> commandsInfo = new LinkedHashMap<String, CommandInfo>();
    private SlackSession session;

    public Bot(String token) {
        this.token = token;
    }

    protected String help() {
        StringBuilder help = new StringBuilder("commands:\n");
        for (String key : this.commandsInfo.keySet()) {
            help.append(key).append(this.parameters(this.commandsInfo.get(key).parameters)).append(": ").append(this.commandsInfo.get(key).description).append("\n");
        }
        return help.toString();
    }

    public Map<String, CommandInfo> commandsInfo() {
        return this.commandsInfo;
    }

    public Map<String, CommandInfo> commandsInfoByContext(String context) {
        return this.commandsInfo.keySet().stream().filter(command -> this.commandsInfo.get(command).context.equalsIgnoreCase(context)).collect(Collectors.toMap(command -> command, this.commandsInfo::get, (a, b) -> b, LinkedHashMap::new));
    }

    public Map<String, Context> contexts() {
        return this.usersContext;
    }

    private String parameters(List<String> parameters) {
        return parameters.isEmpty() ? "" : " `" + String.join((CharSequence)"` `", parameters) + "`";
    }

    public void execute() throws IOException {
        this.session = SlackSessionFactory.createWebSocketSlackSession((String)this.token);
        this.session.addMessagePostedListener(this::talk);
        this.session.connect();
        this.initContexts();
    }

    private void initContexts() {
        for (SlackUser slackUser : this.session.getUsers()) {
            this.usersContext.put(slackUser.getUserName(), new Context("", new String[0]));
        }
    }

    private void talk(SlackMessagePosted message, SlackSession session) {
        try {
            if (message.getSender().isBot()) {
                return;
            }
            String messageContent = StringEscapeUtils.unescapeHtml4((String)message.getMessageContent());
            String[] content = message.getSlackFile() != null ? this.contentFromSlackFile(message.getSlackFile()) : (String[])Arrays.stream(messageContent.split(" ")).filter(s -> !s.trim().isEmpty()).toArray(String[]::new);
            String userName = message.getSender().getUserName();
            CommandInfo commandInfo = this.commandsInfo.get((this.contexts().get(userName).command.isEmpty() || this.isBundledCommand(content[0].toLowerCase()) ? "" : this.contexts().get(userName).command + "$") + content[0].toLowerCase());
            String context = commandInfo != null ? commandInfo.context : "";
            String commandKey = (context.isEmpty() ? "" : context + "$") + content[0].toLowerCase();
            Command command = commandInfo != null && this.commands.containsKey(commandKey) && this.isInContext(commandKey, userName) ? this.commands.get(commandKey) : this.commandNotFound();
            Object response = command.execute(this.createMessageProperties(message), content.length > 1 ? Arrays.copyOfRange(content, 1, content.length) : new String[]{});
            if (response == null || response instanceof String && response.toString().isEmpty()) {
                return;
            }
            if (response instanceof String) {
                session.sendMessage(message.getChannel(), response.toString());
            } else if (response instanceof SlackAttachment) {
                session.sendMessage(message.getChannel(), "", (SlackAttachment)response);
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            session.sendMessage(message.getChannel(), "Command Error. Try `help` to see the options");
        }
    }

    private String[] contentFromSlackFile(SlackFile slackFile) {
        return new String[]{slackFile.getComment().trim(), slackFile.getUrlPrivateDownload()};
    }

    private Command commandNotFound() {
        return (messageProperties, args) -> "Command not found";
    }

    private MessageProperties createMessageProperties(final SlackMessagePosted message) {
        return new MessageProperties(){

            @Override
            public String channel() {
                return message.getChannel().getName();
            }

            @Override
            public String username() {
                return message.getSender().getUserName();
            }

            @Override
            public String userRealName() {
                return message.getSender().getRealName();
            }

            @Override
            public String userTimeZone() {
                return message.getSender().getTimeZone();
            }

            @Override
            public Context context() {
                return Bot.this.usersContext.get(message.getSender().getUserName());
            }
        };
    }

    protected SlackSession session() {
        return this.session;
    }

    protected void add(String name, List<String> parameters, List<String> components, String description, Command command) {
        this.commands.put(name, command);
        this.commandsInfo.put(name, new CommandInfo(parameters, "", components, description));
    }

    protected void add(String name, String context, List<String> parameters, List<String> components, String description, Command command) {
        this.commands.put((context.isEmpty() ? "" : context + "$") + name, command);
        this.commandsInfo.put((context.isEmpty() ? "" : context + "$") + name, new CommandInfo(parameters, context, components, description));
    }

    public void send(String channelDestination, String message) {
        SlackChannel channel = this.slackChannel(channelDestination);
        if (channel == null) {
            return;
        }
        this.session.sendMessage(channel, message);
    }

    public void sendToUser(String user, String message) {
        SlackUser slackUser = this.session.findUserById(user);
        if (slackUser == null) {
            slackUser = this.session.findUserByUserName(user);
        }
        if (slackUser == null) {
            return;
        }
        this.session.sendMessageToUser(slackUser, message, null);
    }

    public void sendToUser(String userID, String message, File attachment) {
        SlackUser user = this.session.findUserById(userID);
        if (user == null) {
            return;
        }
        this.session.sendMessageToUser(user, message, attachment != null ? new SlackAttachment(attachment.getName(), "", "", "") : null);
    }

    public void sendFile(String channelDestination, String name, byte[] content) {
        SlackChannel channel = this.slackChannel(channelDestination);
        if (channel == null) {
            return;
        }
        this.session.sendFile(channel, content, name);
    }

    private SlackChannel slackChannel(String channel) {
        return this.session.getChannels().stream().filter(c -> c.getId().equals(channel) || c.getName().equals(channel)).findFirst().orElse(null);
    }

    private boolean isInContext(String commandKey, String userName) {
        Context context = this.usersContext.get(userName);
        return this.isBundledCommand(commandKey) || context != null && (context.command.isEmpty() || context.command.equalsIgnoreCase(commandKey.substring(0, commandKey.lastIndexOf("$"))));
    }

    private boolean isBundledCommand(String commandKey) {
        return commandKey.equalsIgnoreCase("help") || commandKey.equalsIgnoreCase("where") || commandKey.equalsIgnoreCase("exit");
    }

    public static class Context {
        private String command;
        private String[] objects;

        public Context(String command, String ... objects) {
            this.command = command;
            this.objects = objects;
        }

        public String command() {
            return this.command;
        }

        public void command(String command) {
            this.command = command;
        }

        public String[] getObjects() {
            return this.objects;
        }

        public void objects(String ... objects) {
            this.objects = objects;
        }
    }

    public class CommandInfo {
        private final List<String> parameters;
        private String context;
        private List<String> components;
        private final String description;

        CommandInfo(List<String> parameters, String context, List<String> components, String description) {
            this.parameters = parameters;
            this.context = context;
            this.components = components;
            this.description = description;
        }

        public List<String> parameters() {
            return this.parameters;
        }

        public List<String> components() {
            return this.components;
        }

        public String description() {
            return this.description;
        }
    }

    public static interface MessageProperties {
        public String channel();

        public String username();

        public String userRealName();

        public String userTimeZone();

        public Context context();
    }

    public static interface AttachedCommand
    extends Command {
        public SlackAttachment execute(MessageProperties var1, String ... var2);
    }

    public static interface Command {
        public Object execute(MessageProperties var1, String ... var2);
    }

    public static interface TextCommand
    extends Command {
        @Override
        public String execute(MessageProperties var1, String ... var2);
    }
}

