/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.datalake;

import io.intino.konos.datalake.Reflow;
import io.intino.konos.jms.Consumer;
import io.intino.konos.jms.MessageFactory;
import io.intino.konos.jms.TopicConsumer;
import io.intino.konos.jms.TopicProducer;
import io.intino.ness.inl.Message;
import java.time.Instant;
import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ness {
    private static Logger logger = LoggerFactory.getLogger(Ness.class);
    private static final String REFLOW_PATH = "service.ness.reflow";
    private static final String REFLOW_READY = "service.ness.reflow.ready";
    public static final String REGISTER_ONLY = "registerOnly";
    private final String url;
    private final String user;
    private final String password;
    private String clientID;
    private Session session;
    private Connection connection;
    private Instant lastMessage;
    private int receivedMessages = 0;
    private TopicConsumer topicConsumer;
    private MessageConsumer ackConsumer;

    public Ness(String url, String user, String password, String clientID) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.clientID = clientID;
    }

    public Session start() {
        try {
            this.connection = new ActiveMQConnectionFactory(this.url).createConnection(this.user, this.password);
            if (this.clientID != null && !this.clientID.isEmpty()) {
                this.connection.setClientID(this.clientID);
            }
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            return this.session;
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Tank tank(String tank) {
        return new Tank(tank);
    }

    public ReflowSession reflow(int blockSize, Tank ... tanks) {
        return this.reflow(blockSize, (String[])Arrays.stream(tanks).map(t -> ((Tank)t).name).toArray(String[]::new));
    }

    public ReflowSession reflow(int blockSize, String ... tanks) {
        try {
            TopicProducer producer = new TopicProducer(this.session, REFLOW_PATH);
            producer.produce(MessageFactory.createMessageFor((Object)new Reflow().blockSize(blockSize).tanks(Arrays.asList(tanks))));
            this.waitUntilReflowSession();
            return new ReflowSession(){

                @Override
                public void next() throws JMSException {
                    new TopicProducer(Ness.this.session, Ness.REFLOW_PATH).produce(MessageFactory.createMessageFor((Object)"next"));
                }

                @Override
                public void finish() throws JMSException {
                    new TopicProducer(Ness.this.session, Ness.REFLOW_PATH).produce(MessageFactory.createMessageFor((Object)"finish"));
                }
            };
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void waitUntilReflowSession() {
        try {
            boolean ack = false;
            while (!ack) {
                this.stop();
                Thread.sleep(30000L);
                this.start();
                ack = this.ack();
            }
        }
        catch (InterruptedException ignored) {
            try {
                this.ackConsumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private boolean ack() {
        try {
            Thread thread = Thread.currentThread();
            Queue responseQueue = this.session.createQueue(REFLOW_READY);
            this.ackConsumer = this.session.createConsumer((Destination)responseQueue);
            this.ackConsumer.setMessageListener(message -> {
                logger.info("Application ready to reflow");
                thread.interrupt();
            });
            MessageProducer producer = this.session.createProducer((Destination)this.session.createTopic(REFLOW_PATH));
            javax.jms.Message messageFor = MessageFactory.createMessageFor((Object)"ready?");
            messageFor.setJMSReplyTo((Destination)responseQueue);
            producer.send(messageFor);
            producer.close();
            Thread.sleep(5000L);
            this.ackConsumer.close();
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            return true;
        }
        return false;
    }

    public void stop() {
        try {
            this.ackConsumer = null;
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Session session() {
        return this.session == null || ((ActiveMQSession)this.session).isClosed() ? this.start() : this.session;
    }

    public Connection connection() {
        return this.connection;
    }

    public void closeSession() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private TopicProducer newProducer(String tank) {
        if (this.session() == null) {
            logger.error("Session is null");
            return null;
        }
        try {
            return new TopicProducer(this.session(), tank);
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Instant lastMessage() {
        return this.lastMessage;
    }

    public void lastMessage(Instant lastMessage) {
        this.lastMessage = lastMessage;
        if (lastMessage != null) {
            ++this.receivedMessages;
        }
    }

    public int receivedMessages() {
        return this.receivedMessages;
    }

    public void reset() {
        this.receivedMessages = 0;
    }

    public static interface ReflowSession {
        public void next() throws JMSException;

        public void finish() throws JMSException;
    }

    public static interface TankFlow
    extends Consumer {
    }

    public class Tank {
        private String name;
        private TopicConsumer flow;

        Tank(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String flowChannel() {
            return "flow." + this.name;
        }

        public String dropChannel() {
            return "drop." + this.name;
        }

        public String feedChannel() {
            return "feed." + this.name;
        }

        public void feed(Message message) {
            TopicProducer producer = Ness.this.newProducer(this.feedChannel());
            if (producer != null) {
                producer.produce(MessageFactory.createMessageFor((Object)message.toString()));
            }
        }

        public void drop(Message message) {
            try {
                TextMessage jmsMessage = (TextMessage)MessageFactory.createMessageFor((Object)message.toString());
                if (jmsMessage == null) {
                    return;
                }
                jmsMessage.setBooleanProperty(Ness.REGISTER_ONLY, true);
                TopicProducer producer = Ness.this.newProducer(this.dropChannel());
                if (producer != null) {
                    producer.produce((javax.jms.Message)jmsMessage);
                    producer.close();
                }
            }
            catch (JMSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public TopicConsumer flow(TankFlow flow) {
            if (Ness.this.session() == null) {
                logger.error("Session is null");
            }
            this.flow = new TopicConsumer(Ness.this.session(), this.flowChannel());
            this.flow.listen((Consumer)flow);
            return this.flow;
        }

        public TopicConsumer flow(TankFlow flow, String flowID) {
            if (Ness.this.session() == null) {
                logger.error("Session is null");
            }
            Ness.this.topicConsumer = new TopicConsumer(Ness.this.session(), this.flowChannel());
            Ness.this.topicConsumer.listen((Consumer)flow, flowID);
            return Ness.this.topicConsumer;
        }

        public void unregister() {
            if (Ness.this.topicConsumer != null) {
                Ness.this.topicConsumer.stop();
            }
            Ness.this.topicConsumer = null;
        }
    }
}

