/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.datalake;

import io.intino.konos.jms.Consumer;
import io.intino.konos.jms.MessageFactory;
import io.intino.konos.jms.TopicConsumer;
import io.intino.konos.jms.TopicProducer;
import io.intino.ness.inl.Message;
import java.time.Instant;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ness {
    protected static Logger logger = LoggerFactory.getLogger(Ness.class);
    public static final String REGISTER_ONLY = "registerOnly";
    private final String url;
    private final String user;
    private final String password;
    private String clientID;
    private Session session;
    private Connection connection;
    private Instant lastMessage;
    private int receivedMessages = 0;

    public Ness(String url, String user, String password, String clientID) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.clientID = clientID;
    }

    public Session start() {
        try {
            this.connection = new ActiveMQConnectionFactory(this.url).createConnection(this.user, this.password);
            if (this.clientID != null && !this.clientID.isEmpty()) {
                this.connection.setClientID(this.clientID);
            }
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            return this.session;
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Tank tank(String tank) {
        return new Tank(tank);
    }

    public void stop() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Session session() {
        return this.session == null || ((ActiveMQSession)this.session).isClosed() ? this.start() : this.session;
    }

    public Connection connection() {
        return this.connection;
    }

    public void closeSession() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private TopicProducer newProducer(String tank) {
        if (this.session() == null) {
            logger.error("Session is null");
            return null;
        }
        try {
            return new TopicProducer(this.session(), tank);
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Instant lastMessage() {
        return this.lastMessage;
    }

    public void lastMessage(Instant lastMessage) {
        this.lastMessage = lastMessage;
        if (lastMessage != null) {
            ++this.receivedMessages;
        }
    }

    public int receivedMessages() {
        return this.receivedMessages;
    }

    public void reset() {
        this.receivedMessages = 0;
    }

    public static interface TankFlow
    extends Consumer {
    }

    public class Tank {
        private String name;

        Tank(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String flowChannel() {
            return "flow." + this.name;
        }

        public String dropChannel() {
            return "drop." + this.name;
        }

        public String feedChannel() {
            return "feed." + this.name;
        }

        public void feed(Message message) {
            TopicProducer producer = Ness.this.newProducer(this.feedChannel());
            if (producer != null) {
                producer.produce(MessageFactory.createMessageFor((Object)message.toString()));
            }
        }

        public void drop(Message message) {
            try {
                TextMessage jmsMessage = (TextMessage)MessageFactory.createMessageFor((Object)message.toString());
                if (jmsMessage == null) {
                    return;
                }
                jmsMessage.setBooleanProperty(Ness.REGISTER_ONLY, true);
                TopicProducer producer = Ness.this.newProducer(this.dropChannel());
                if (producer != null) {
                    producer.produce((javax.jms.Message)jmsMessage);
                }
            }
            catch (JMSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public TopicConsumer flow(TankFlow flow) {
            if (Ness.this.session() == null) {
                logger.error("Session is null");
            }
            TopicConsumer topicConsumer = new TopicConsumer(Ness.this.session(), this.flowChannel());
            topicConsumer.listen((Consumer)flow);
            return topicConsumer;
        }

        public TopicConsumer flow(TankFlow flow, String flowID) {
            if (Ness.this.session() == null) {
                logger.error("Session is null");
            }
            TopicConsumer topicConsumer = new TopicConsumer(Ness.this.session(), this.flowChannel());
            topicConsumer.listen((Consumer)flow, flowID);
            return topicConsumer;
        }
    }
}

