/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.datalake;

import io.intino.konos.datalake.MessageDispatcher;
import io.intino.konos.datalake.Reflow;
import io.intino.konos.jms.Consumer;
import io.intino.konos.jms.MessageFactory;
import io.intino.konos.jms.TopicConsumer;
import io.intino.konos.jms.TopicProducer;
import io.intino.ness.inl.Message;
import java.time.Instant;
import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ness {
    private static Logger logger = LoggerFactory.getLogger(Ness.class);
    private static final String REFLOW_PATH = "service.ness.reflow";
    private static final String FLOW_PATH = "flow.ness.reflow";
    public static final String REGISTER_ONLY = "registerOnly";
    private final String url;
    private final String user;
    private final String password;
    private String clientID;
    private Session session;
    private Connection connection;
    private Instant lastMessage;
    private int receivedMessages = 0;

    public Ness(String url, String user, String password, String clientID) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.clientID = clientID;
    }

    public Session start() {
        try {
            this.createConnection();
            this.session = this.connection.createSession(false, 1);
            return this.session;
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Session startTransacted() {
        try {
            this.createConnection();
            this.session = this.connection.createSession(true, 0);
            return this.session;
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void createConnection() throws JMSException {
        this.connection = new ActiveMQConnectionFactory(this.url).createConnection(this.user, this.password);
        if (this.clientID != null && !this.clientID.isEmpty()) {
            this.connection.setClientID(this.clientID);
        }
        this.connection.start();
    }

    public Tank tank(String tank) {
        return new Tank(tank);
    }

    public ReflowSession reflow(int blockSize, MessageDispatcher dispatcher, Tank ... tanks) {
        return this.reflow(blockSize, dispatcher, Instant.MIN, (String[])Arrays.stream(tanks).map(t -> ((Tank)t).name).toArray(String[]::new));
    }

    public ReflowSession reflow(int blockSize, MessageDispatcher dispatcher, Instant from, Tank ... tanks) {
        return this.reflow(blockSize, dispatcher, from, (String[])Arrays.stream(tanks).map(t -> ((Tank)t).name).toArray(String[]::new));
    }

    public ReflowSession reflow(int blockSize, final MessageDispatcher dispatcher, Instant from, String ... tanks) {
        try {
            TopicProducer producer = this.newProducer();
            producer.produce(MessageFactory.createMessageFor((Object)new Reflow().blockSize(blockSize).from(from).tanks(Arrays.asList(tanks))));
            this.waitUntilReflowSession();
            final TopicConsumer topicConsumer = new TopicConsumer(this.session, FLOW_PATH);
            topicConsumer.listen(m -> this.consume(dispatcher, m), "consumer-flow.ness.reflow");
            return new ReflowSession(){

                @Override
                public void next() {
                    try {
                        TopicProducer topicProducer = Ness.this.newProducer();
                        topicProducer.produce(MessageFactory.createMessageFor((Object)"next"));
                        topicProducer.close();
                    }
                    catch (JMSException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }

                @Override
                public void finish() {
                    try {
                        TopicProducer topicProducer = Ness.this.newProducer();
                        topicProducer.produce(MessageFactory.createMessageFor((Object)"finish"));
                        topicProducer.close();
                    }
                    catch (JMSException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    topicConsumer.stop();
                }

                @Override
                public void play() {
                    topicConsumer.listen(m -> Ness.this.consume(dispatcher, m));
                }

                @Override
                public void pause() {
                    topicConsumer.stop();
                }
            };
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private TopicProducer newProducer() throws JMSException {
        return new TopicProducer(this.session, REFLOW_PATH);
    }

    private void consume(MessageDispatcher dispatcher, javax.jms.Message m) {
        dispatcher.dispatch(Message.load((String)Consumer.textFrom((javax.jms.Message)m)));
    }

    private void waitUntilReflowSession() {
        try {
            this.stop();
            Thread.sleep(40000L);
            this.start();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Session session() {
        return this.session == null || ((ActiveMQSession)this.session).isClosed() ? this.start() : this.session;
    }

    public Connection connection() {
        return this.connection;
    }

    public void closeSession() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private TopicProducer newProducer(String tank) {
        if (this.session() == null) {
            logger.error("Session is null");
            return null;
        }
        try {
            return new TopicProducer(this.session(), tank);
        }
        catch (JMSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Instant lastMessage() {
        return this.lastMessage;
    }

    public void lastMessage(Instant lastMessage) {
        this.lastMessage = lastMessage;
        if (lastMessage != null) {
            ++this.receivedMessages;
        }
    }

    public int receivedMessages() {
        return this.receivedMessages;
    }

    public void reset() {
        this.receivedMessages = 0;
    }

    public static interface ReflowSession {
        public void next();

        public void finish();

        public void play();

        public void pause();
    }

    public static interface TankFlow
    extends Consumer {
        public void consume(Message var1);
    }

    public class Tank {
        private String name;
        private TopicConsumer flow;

        Tank(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String flowChannel() {
            return "flow." + this.name;
        }

        public String dropChannel() {
            return "drop." + this.name;
        }

        public String feedChannel() {
            return "feed." + this.name;
        }

        public void feed(Message message) {
            TopicProducer producer = Ness.this.newProducer(this.feedChannel());
            if (producer != null) {
                producer.produce(MessageFactory.createMessageFor((Object)message.toString()));
            }
        }

        public void drop(Message message) {
            try {
                TextMessage jmsMessage = (TextMessage)MessageFactory.createMessageFor((Object)message.toString());
                if (jmsMessage == null) {
                    return;
                }
                jmsMessage.setBooleanProperty(Ness.REGISTER_ONLY, true);
                TopicProducer producer = Ness.this.newProducer(this.dropChannel());
                if (producer != null) {
                    producer.produce((javax.jms.Message)jmsMessage);
                    producer.close();
                }
            }
            catch (JMSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public TopicConsumer flow(TankFlow flow) {
            if (Ness.this.session() == null) {
                logger.error("Session is null");
            }
            this.flow = new TopicConsumer(Ness.this.session(), this.flowChannel());
            this.flow.listen((Consumer)flow);
            return this.flow;
        }

        public TopicConsumer flow(TankFlow flow, String flowID) {
            if (Ness.this.session() == null) {
                logger.error("Session is null");
            }
            this.flow = new TopicConsumer(Ness.this.session(), this.flowChannel());
            if (flowID != null) {
                this.flow.listen((Consumer)flow, flowID);
            } else {
                this.flow.listen((Consumer)flow);
            }
            return this.flow;
        }

        public void unregister() {
            if (this.flow != null) {
                this.flow.stop();
            }
            this.flow = null;
        }
    }
}

