/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.schema;

import io.intino.konos.alexandria.schema.Accessory;
import io.intino.konos.alexandria.schema.Formatters;
import io.intino.konos.alexandria.schema.Resource;
import io.intino.konos.alexandria.schema.ResourceStore;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class Serializer {
    private final Object object;
    private final String path;
    private final Accessory.Mapping mapping;
    private ResourceStore resourceStore;
    private static String[] primitives = new String[]{"java.lang", Resource.class.getName(), "java.time"};

    public static Serializer serialize(Object object) {
        return Serializer.serialize(object, ResourceStore.collector());
    }

    public static Serializer serialize(Object object, ResourceStore resourceStore) {
        return new Serializer(object, "", new Accessory.Mapping(), resourceStore);
    }

    private Serializer(Object object, String path, Accessory.Mapping mapping, ResourceStore resourceStore) {
        this.object = object;
        this.path = path;
        this.mapping = mapping;
        this.resourceStore = resourceStore;
    }

    public String toInl() {
        return this.object instanceof List ? this.toInl((List)this.object) : this.header() + this.body();
    }

    private String toInl(List list) {
        StringBuilder result = new StringBuilder();
        for (Object o : list) {
            result.append("\n").append(Serializer.serialize(o).toInl());
        }
        return result.substring(1);
    }

    private String header() {
        return "[" + this.type() + "]\n";
    }

    private String type() {
        return this.path + (this.path.isEmpty() ? "" : ".") + this.map(this.className());
    }

    private String map(String text) {
        return this.mapping.get(text);
    }

    private String body() {
        return this.serializeAttributes() + this.serializeComponents();
    }

    private String serializeAttributes() {
        StringBuilder result = new StringBuilder();
        for (Field field : Accessory.fieldsOf(this.object).asList()) {
            Object value;
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || !Serializer.isAttribute(field) || Serializer.isEmpty(value = Accessory.valueOf(field, this.object))) continue;
            result.append(this.serializeAttribute(field)).append("\n");
            this.collectResources(value);
        }
        return result.toString();
    }

    private String serializeComponents() {
        StringBuilder result = new StringBuilder();
        for (Field field : Accessory.fieldsOf(this.object).asList()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Serializer.isEmpty(Accessory.valueOf(field, this.object)) || Serializer.isAttribute(field)) continue;
            result.append(this.serializeComponent(field));
        }
        return result.toString();
    }

    private void collectResources(Object value) {
        if (value instanceof Resource) {
            this.resourceStore.add((Resource)value);
        }
        if (value instanceof Resource[]) {
            Arrays.stream((Resource[])value).forEach(r -> this.resourceStore.add((Resource)r));
        }
        if (value instanceof List && this.isResourceList((List)value)) {
            ((List)value).forEach(o -> this.resourceStore.add((Resource)o));
        }
    }

    private boolean isResourceList(List list) {
        return !list.isEmpty() && list.get(0) instanceof Resource;
    }

    private String serializeAttribute(Field field) {
        return this.map(field.getName()) + this.separatorFor(this.serializeAttributeValue(Accessory.valueOf(field, this.object)));
    }

    private String serializeAttributeValue(Object value) {
        if (value == null) {
            return "";
        }
        return value instanceof List ? this.serializeAttributeValue(this.toArray((List)value)) : this.formatterOf(value).format(value);
    }

    private String separatorFor(String value) {
        return value.startsWith("\n") ? ":" + value : ": " + value;
    }

    private Formatters.Formatter formatterOf(Object value) {
        return Formatters.get(value.getClass());
    }

    private <T> T[] toArray(List<T> list) {
        Object[] result = (Object[])Array.newInstance(list.get(0).getClass(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    private String serializeComponent(Field field) {
        Object object = Accessory.valueOf(field, this.object);
        if (object == null) {
            return "";
        }
        return this.isList(field) ? this.serializeTable((List)object) : this.serializeItem(object);
    }

    private String serializeTable(List list) {
        StringBuilder result = new StringBuilder();
        for (Object item : list) {
            result.append(this.serializeItem(item));
        }
        return result.toString();
    }

    private String serializeItem(Object value) {
        Class<?> aClass = value.getClass();
        return "\n" + (Serializer.isPrimitive(aClass) || Serializer.isArrayOfPrimitives(aClass) ? value.toString() : new Serializer(value, this.type(), this.mapping, this.resourceStore).toInl());
    }

    static boolean isAttribute(Field field) {
        Class<?> aClass = field.getType();
        return Serializer.isPrimitive(aClass) || Serializer.isArrayOfPrimitives(aClass) || Serializer.isListOfPrimitives(field);
    }

    static boolean isAttachment(Field field) {
        Class<?> aClass = field.getType();
        return aClass.equals(Resource.class);
    }

    private static boolean isArrayOfPrimitives(Class<?> aClass) {
        return aClass.isArray() && Serializer.isPrimitive(aClass.getComponentType());
    }

    private static boolean isListOfPrimitives(Field field) {
        return field.getType().isAssignableFrom(List.class) && Serializer.isPrimitive(field.getGenericType().toString());
    }

    private static boolean isPrimitive(Class<?> aClass) {
        return Serializer.isPrimitive(aClass.getName()) || aClass.isPrimitive();
    }

    private static boolean isPrimitive(String className) {
        if (className.contains("<")) {
            className = className.substring(className.indexOf(60) + 1);
        }
        for (String primitive : primitives) {
            if (!className.startsWith(primitive)) continue;
            return true;
        }
        return false;
    }

    static boolean isEmpty(Object value) {
        return value == null || value.getClass().isArray() && ((Object[])value).length == 0 || value instanceof List && ((List)value).isEmpty();
    }

    private boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private String className() {
        return this.object.getClass().getSimpleName();
    }

    public Serializer map(String from, String to) {
        this.mapping.put(from, to);
        return this;
    }
}

