/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.schema;

import cottons.utils.MimeTypes;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Map;

public class Resource {
    private static Map<String, String> mimeTypes;
    private String id;
    private String type;
    private String contentType;
    private InputStream data;

    public Resource(String id) {
        this.id = id;
        this.type = id.substring(id.lastIndexOf(46) + 1);
        this.data = null;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String contentType() {
        return this.contentType;
    }

    public InputStream data() {
        return this.data;
    }

    public String mimeType() {
        return MimeTypes.getFromFilename((String)this.id);
    }

    public Resource contentType(String type) {
        this.contentType = type;
        return this;
    }

    public Resource data(byte[] data) {
        this.data = new ByteArrayInputStream(data);
        return this;
    }

    public Resource data(InputStream stream) {
        this.data = stream;
        return this;
    }

    public String toString() {
        return this.id;
    }

    public static String resolveContentType(File file) throws IOException {
        String type = Files.probeContentType(file.toPath());
        if (type != null) {
            return type;
        }
        type = URLConnection.guessContentTypeFromName(file.getName());
        return type != null ? type : URLConnection.guessContentTypeFromStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Resource parse(String text) {
        return new Resource(text.substring(1));
    }
}

