/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.schema;

import io.intino.konos.alexandria.schema.Accessory;
import io.intino.konos.alexandria.schema.Resource;
import io.intino.konos.alexandria.schema.Serializer;
import io.intino.ness.inl.Message;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class ObjectToMessage {
    public static Message toMessage(Object object) {
        Message message = new Message(object instanceof List ? ObjectToMessage.collectionType((List)object) : object.getClass().getSimpleName());
        for (Field field : Accessory.fieldsOf(object).asList()) {
            Object value;
            if (!ObjectToMessage.isConvertible(field) || Objects.isNull(value = ObjectToMessage.valueOf(field, object)) || Serializer.isEmpty(value)) continue;
            if (Serializer.isAttachment(field)) {
                ObjectToMessage.convertAttachment(message, field, value);
                continue;
            }
            if (Serializer.isAttribute(field)) {
                ObjectToMessage.convertAttribute(message, field, value);
                continue;
            }
            if (ObjectToMessage.isList(field) || ObjectToMessage.isArray(field)) {
                ObjectToMessage.valuesOf(field, object).forEach(v -> message.add(ObjectToMessage.toMessage(v)));
                continue;
            }
            message.add(ObjectToMessage.toMessage(value));
        }
        return message;
    }

    private static void convertAttachment(Message message, Field field, Object value) {
        try {
            Resource resource = (Resource)value;
            message.set(field.getName(), resource.id(), resource.type(), resource.data());
            resource.data().reset();
        }
        catch (IOException e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage());
        }
    }

    private static void convertAttribute(Message message, Field field, Object value) {
        if (ObjectToMessage.isList(field)) {
            ((List)value).forEach(o -> ObjectToMessage.writeAttribute(message, field, o));
        } else if (ObjectToMessage.isArray(field)) {
            Arrays.asList((Object[])value).forEach(ob -> ObjectToMessage.writeAttribute(message, field, ob));
        } else {
            ObjectToMessage.writeAttribute(message, field, value);
        }
    }

    private static boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private static boolean isArray(Field field) {
        return field.getType().isArray();
    }

    private static void writeAttribute(Message message, Field field, Object value) {
        String name = field.getName();
        if (value instanceof Double) {
            message.write(name, (Double)value);
        } else if (value instanceof Boolean) {
            message.write(name, (Boolean)value);
        } else if (value instanceof Integer) {
            message.write(name, (Integer)value);
        } else {
            message.write(name, value == null ? null : value.toString());
        }
    }

    private static boolean isConvertible(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers());
    }

    private static Object valueOf(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static List<Object> valuesOf(Field field, Object object) {
        Object o = ObjectToMessage.valueOf(field, object);
        return o instanceof List ? (List<Object>)o : Arrays.asList((Object[])o);
    }

    private static String collectionType(List object) {
        String typeName = ((ParameterizedType)object.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
        return typeName.contains(".") ? typeName.substring(typeName.lastIndexOf(".") + 1) : typeName;
    }
}

