/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.schema;

import io.intino.konos.alexandria.schema.Accessory;
import io.intino.konos.alexandria.schema.Deserializer;
import io.intino.konos.alexandria.schema.Resource;
import io.intino.ness.inl.Message;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageToObject {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private static Map<Class, String> classNames = new HashMap<Class, String>();
    private static Map<String, Field> fields = new HashMap<String, Field>();

    public static <T> T fromMessage(Message message, Class<T> aClass) {
        return (T)MessageToObject.fillObject(message, aClass, Deserializer.create(aClass));
    }

    private static <T> Object fillObject(Message message, Class<T> aClass, Object object) {
        MessageToObject.attributes(message, aClass, object);
        MessageToObject.components(message, aClass, object);
        return object;
    }

    private static <T> void attributes(Message message, Class<T> aClass, Object object) {
        for (String attr : message.attributes()) {
            Field field = MessageToObject.fieldByName(aClass, attr);
            if (field == null) continue;
            MessageToObject.setField(field, object, MessageToObject.valueOf(message, attr, field));
        }
    }

    private static Object valueOf(Message message, String attr, Field field) {
        if (field.getType().isAssignableFrom(Resource.class)) {
            Message.Attachment attachment = message.attachment(message.get(attr));
            return new Resource(attachment.id()).data(attachment.data());
        }
        return Deserializer.parserOf(field).parse(message.get(attr));
    }

    private static <T> void components(Message message, Class<T> aClass, Object object) {
        for (Message component : message.components()) {
            Field field = MessageToObject.fieldByName(aClass, component.type());
            if (field == null) continue;
            MessageToObject.setField(field, object, MessageToObject.fillObject(component, MessageToObject.classOf(field), Deserializer.create(MessageToObject.classOf(field))));
        }
    }

    private static void setField(Field field, Object owner, Object value) {
        try {
            field.setAccessible(true);
            if (field.getType().isAssignableFrom(List.class)) {
                field.set(owner, value instanceof List ? MessageToObject.append((List)field.get(owner), (List)value) : MessageToObject.append((List)field.get(owner), value));
            } else if (field.getType().isArray()) {
                field.set(owner, MessageToObject.append((Object[])field.get(owner), (Object[])value));
            } else {
                field.set(owner, value);
            }
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static Object append(Object[] current, Object[] value) {
        if (current == null) {
            current = new Object[]{};
        }
        System.arraycopy(current, 0, value, 0, current.length);
        return value;
    }

    private static List append(List current, Object value) {
        if (current == null) {
            current = new ArrayList<Object>();
        }
        current.add(value);
        return current;
    }

    private static List append(List current, List value) {
        if (current == null) {
            current = new ArrayList();
        }
        current.addAll(value);
        return current;
    }

    private static <T> Field fieldByName(Class<T> aClass, String attr) {
        String attrId = MessageToObject.className(aClass) + "." + attr.toLowerCase();
        if (!fields.containsKey(attrId)) {
            MessageToObject.findField(aClass, attr, attrId);
        }
        return fields.get(attrId);
    }

    private static <T> void findField(Class<T> aClass, String attr, String attrId) {
        for (Field field : Accessory.fieldsOf(aClass)) {
            if (!attr.equalsIgnoreCase(field.getName()) && !attr.equalsIgnoreCase(MessageToObject.className(field))) continue;
            fields.put(attrId, field);
            break;
        }
    }

    private static String className(Field field) {
        Class aClass = MessageToObject.classOf(field);
        return MessageToObject.className(aClass);
    }

    private static String className(Class aClass) {
        if (!classNames.containsKey(aClass)) {
            classNames.put(aClass, aClass.getSimpleName());
        }
        return classNames.get(aClass);
    }

    private static Class classOf(Field field) {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        ParameterizedType ptype = (ParameterizedType)field.getGenericType();
        return (Class)ptype.getActualTypeArguments()[0];
    }
}

