/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.schema;

import io.intino.konos.alexandria.schema.Resource;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class Formatters {
    private static final String NullValue = "\u0000";
    private static final Map<Class, Formatter> formatters = new HashMap<Class, Formatter>();

    public static Formatter get(Class<?> aClass) {
        return formatters.get(aClass);
    }

    public static void put(Class<?> aClass, Formatter formatter) {
        formatters.put(aClass, formatter);
    }

    private static String formatText(Object o) {
        if (o == null) {
            return NullValue;
        }
        String text = o.toString();
        return text.contains("\n") ? "\n\t" + text.replaceAll("\n", "\n\t") : text;
    }

    private static String formatResource(Object o) {
        if (o == null) {
            return NullValue;
        }
        return "@" + o.toString();
    }

    static {
        formatters.put(String.class, Formatters::formatText);
        formatters.put(Boolean.class, Object::toString);
        formatters.put(Byte.class, Object::toString);
        formatters.put(Integer.class, Object::toString);
        formatters.put(Float.class, Object::toString);
        formatters.put(Double.class, Object::toString);
        formatters.put(Instant.class, Object::toString);
        formatters.put(Resource.class, Formatters::formatResource);
        formatters.put(String[].class, ArrayFormatter.of(String.class)::format);
        formatters.put(Boolean[].class, ArrayFormatter.of(Boolean.class)::format);
        formatters.put(Byte[].class, ArrayFormatter.of(Byte.class)::format);
        formatters.put(Integer[].class, ArrayFormatter.of(Integer.class)::format);
        formatters.put(Float[].class, ArrayFormatter.of(Float.class)::format);
        formatters.put(Double[].class, ArrayFormatter.of(Double.class)::format);
        formatters.put(Instant[].class, ArrayFormatter.of(Instant.class)::format);
        formatters.put(Resource[].class, ArrayFormatter.of(Resource.class)::format);
    }

    private static class ArrayFormatter {
        private Formatter formatter;

        ArrayFormatter(Formatter formatter) {
            this.formatter = formatter;
        }

        static ArrayFormatter of(Class type) {
            return new ArrayFormatter((Formatter)formatters.get(type));
        }

        String format(Object o) {
            String result = "";
            for (Object item : (Object[])o) {
                result = result + "\n\t" + (item == null ? Formatters.NullValue : this.formatter.format(item));
            }
            return result;
        }
    }

    public static interface Formatter {
        public String format(Object var1);
    }
}

