/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.schema;

import io.intino.konos.alexandria.schema.Accessory;
import io.intino.konos.alexandria.schema.Parsers;
import io.intino.konos.alexandria.schema.Resource;
import io.intino.konos.alexandria.schema.ResourceLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Deserializer {
    private final BufferedReader reader;
    private final ResourceLoader[] loaders;
    private final Accessory.Mapping mapping = new Accessory.Mapping();
    private String line;

    public static Deserializer deserialize(String text, ResourceLoader ... loaders) {
        return Deserializer.deserialize(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)), loaders);
    }

    public static Deserializer deserialize(InputStream is, ResourceLoader ... loaders) {
        return new Deserializer(is, loaders);
    }

    private Deserializer(InputStream is, ResourceLoader[] loaders) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.loaders = loaders;
        this.nextLine();
    }

    public <T> T next(Class<T> type) {
        if (!this.startBlockOf(type)) {
            return null;
        }
        return (T)this.fill(Deserializer.create(type));
    }

    private boolean startBlockOf(Class type) {
        return this.line != null && this.map(this.unwrapBlock(this.line)).equalsIgnoreCase(type.getSimpleName());
    }

    private String unwrapBlock(String text) {
        return text.startsWith("[") ? text.substring(1, text.length() - 1) : text;
    }

    private String unwrap(String value) {
        return value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    private <T> T fill(T object) {
        Object scope = object;
        String attribute = "";
        String value = "";
        this.nextLine();
        while (!this.isTerminated(object)) {
            if (this.isMultiline()) {
                value = (value != null ? value + "\n" : "") + this.line.substring(1);
                this.setAttribute(scope, attribute, value);
            } else if (this.isHeader()) {
                scope = this.addComponent(object, this.line.substring(1, this.line.length() - 1));
            } else if (this.isAttribute()) {
                attribute = this.attributeOf(this.line);
                value = this.valueOf(this.line);
                this.setAttribute(scope, attribute, value);
            }
            this.nextLine();
        }
        return object;
    }

    private String attributeOf(String line) {
        return line.substring(0, line.indexOf(":"));
    }

    private String valueOf(String line) {
        return line.indexOf(":") + 1 < line.length() ? this.unwrap(line.substring(line.indexOf(":") + 1)) : null;
    }

    private boolean isMultiline() {
        return this.line.startsWith("\t");
    }

    private String map(String id) {
        return this.mapping.get(id);
    }

    private boolean isHeader() {
        return this.line.startsWith("[");
    }

    private boolean isAttribute() {
        return this.line.contains(":");
    }

    private boolean isTerminated(Object object) {
        return this.line == null || this.startBlockOf(object.getClass());
    }

    private void setAttribute(Object object, String attribute, String value) {
        if (object == null || value == null || value.isEmpty()) {
            return;
        }
        Field field = Accessory.fieldsOf(object).get(this.map(attribute));
        this.setField(field, object, Deserializer.parserOf(field).parse(this.deIndent(value)));
    }

    private Object addComponent(Object scope, String path) {
        String[] paths = path.split("\\.");
        for (int i = 1; i < paths.length - 1; ++i) {
            if ((scope = this.findScope(scope, paths[i])) != null) continue;
            return null;
        }
        return this.createComponent(paths[paths.length - 1], scope);
    }

    private Object valueOf(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private String deIndent(String value) {
        return value.startsWith("\n") ? value.substring(1) : value;
    }

    private Object findScope(Object object, String attribute) {
        for (Field field : Accessory.fieldsOf(object).asList()) {
            if (!this.match(field, attribute)) continue;
            Object result = this.valueOf(field, object);
            return result instanceof List ? this.lastItemOf((List)result) : result;
        }
        return null;
    }

    private boolean match(Field field, String attribute) {
        return attribute.equalsIgnoreCase(field.getName()) || attribute.equalsIgnoreCase(this.classOf(field).getSimpleName());
    }

    private Object lastItemOf(List list) {
        return list.get(list.size() - 1);
    }

    private Class classOf(Field field) {
        if (!(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        ParameterizedType ptype = (ParameterizedType)field.getGenericType();
        return (Class)ptype.getActualTypeArguments()[0];
    }

    private Object createComponent(String type, Object object) {
        return this.createComponent(this.findField(type, object), object);
    }

    private Object createComponent(Field field, Object object) {
        if (field == null) {
            return null;
        }
        return Deserializer.isList(field) ? this.createListItem(field, object) : this.setField(field, object, Deserializer.create(this.classOf(field)));
    }

    private Object createListItem(Field field, Object object) {
        ArrayList<Object> list = (ArrayList<Object>)this.valueOf(field, object);
        if (list == null) {
            list = new ArrayList<Object>();
            this.setField(field, object, list);
        }
        Object item = Deserializer.create(this.classOf(field));
        list.add(item);
        return item;
    }

    private static boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private Object setField(Field field, Object object, Object value) {
        if (field == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            if (value.getClass().isArray()) {
                value = this.append((Object[])field.get(object), (Object[])value);
            }
            if (value instanceof List) {
                value = this.append((List)field.get(object), (List)value);
            }
            if (value instanceof Resource) {
                this.load((Resource)value);
            }
            field.set(object, value);
            return value;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private Object append(Object[] current, Object[] value) {
        if (current == null) {
            current = new Object[]{};
        }
        System.arraycopy(current, 0, value, 0, current.length);
        Object o = value[current.length];
        if (o instanceof Resource) {
            this.load((Resource)o);
        }
        return value;
    }

    private List append(List current, List value) {
        Object o;
        if (current == null) {
            current = new ArrayList();
        }
        if ((o = value.get(value.size() - 1)) instanceof Resource) {
            this.load((Resource)o);
        }
        current.add(o);
        return current;
    }

    private void load(Resource resource) {
        for (ResourceLoader loader : this.loaders) {
            byte[] data = loader.load(resource.id());
            if (data == null) continue;
            resource.data(data);
            return;
        }
    }

    private Field findField(String type, Object object) {
        for (Field field : Accessory.fieldsOf(object).asList()) {
            if (!this.match(field, type) || !Deserializer.isList(field) && this.valueOf(field, object) != null) continue;
            return field;
        }
        return null;
    }

    static Object create(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void nextLine() {
        try {
            do {
                this.line = Deserializer.normalize(this.reader.readLine());
            } while (this.line != null && this.line.isEmpty());
        }
        catch (IOException e) {
            this.line = null;
        }
    }

    static Parsers.Parser parserOf(Field field) {
        return Deserializer.isList(field) ? Deserializer.listParserOf(field.getGenericType().toString()) : Parsers.get(field.getType());
    }

    static Parsers.Parser listParserOf(final String name) {
        return new Parsers.Parser(){
            Parsers.Parser parser = Parsers.get(this.arrayClass());

            private Class<?> arrayClass() {
                try {
                    String className = "[L" + name.substring(name.indexOf(60) + 1).replace(">", "") + ";";
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }

            @Override
            public Object parse(String text) {
                Object[] array = (Object[])this.parser.parse(text);
                return Arrays.asList(array);
            }
        };
    }

    public Deserializer map(String from, String to) {
        this.mapping.put(from, to);
        return this;
    }

    private static String normalize(String line) {
        if (line == null) {
            return null;
        }
        if (line.startsWith("\t") || line.isEmpty() || line.startsWith("[")) {
            return line;
        }
        return line.trim().replaceAll("(\\w*)\\s*[:=]\\s*(.*)", "$1:$2");
    }
}

