/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import io.intino.konos.alexandria.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import org.apache.tika.io.IOUtils;

public class Json {
    public static String toString(Object object) {
        return Json.gsonWriter().toJson(object);
    }

    public static <T> T fromString(String text, Class<T> t) {
        return (T)Json.gsonReader().fromJson(text, t);
    }

    private static Gson gsonReader() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (json, type1, context) -> Instant.ofEpochMilli(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (json, type1, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(InputStream.class, (json, type1, context) -> new ByteArrayInputStream(Base64.decode(json.getAsString()))).create();
    }

    private static Gson gsonWriter() {
        return new GsonBuilder().registerTypeAdapter(Instant.class, (instant, type, context) -> new JsonPrimitive((Number)instant.toEpochMilli())).registerTypeAdapter(Date.class, (date, type, context) -> new JsonPrimitive((Number)date.getTime())).registerTypeAdapter(InputStream.class, (inputStream, type1, jsonDeserializationContext) -> new JsonPrimitive(Base64.encode(Json.toByteArray(inputStream)))).create();
    }

    private static byte[] toByteArray(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            return new byte[0];
        }
    }
}

