/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.spark.resources;

import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.displays.MessageCarrier;
import io.intino.konos.alexandria.activity.services.AuthService;
import io.intino.konos.alexandria.activity.services.auth.Space;
import io.intino.konos.alexandria.activity.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.konos.alexandria.activity.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.konos.alexandria.activity.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.konos.alexandria.activity.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import io.intino.konos.alexandria.activity.services.push.ActivityClient;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.konos.alexandria.activity.services.push.Browser;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;
import io.intino.konos.alexandria.activity.utils.RequestHelper;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import io.intino.konos.alexandria.rest.pushservice.Client;
import io.intino.konos.alexandria.rest.pushservice.PushService;
import io.intino.konos.alexandria.rest.pushservice.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public abstract class Resource
implements io.intino.konos.alexandria.rest.Resource {
    private final AlexandriaDisplayNotifierProvider notifierProvider;
    protected final ActivitySparkManager manager;
    static final Map<String, String> authenticationIdMap = new HashMap<String, String>();
    static final Map<String, AuthService.Authentication> authenticationMap = new HashMap<String, AuthService.Authentication>();

    public Resource(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        this.manager = manager;
        this.notifierProvider = notifierProvider;
    }

    public void execute() throws AlexandriaException {
        this.fillBrowser(this.manager);
    }

    protected boolean isLogged() {
        if (!this.isFederated()) {
            return true;
        }
        String authId = (String)this.manager.fromQuery("authId", String.class);
        AuthService.Authentication authentication = this.authenticationOf(authId).orElse(null);
        return authentication != null && this.manager.authService().valid(authentication.accessToken());
    }

    protected synchronized void authenticate() {
        this.manager.redirect(this.authenticate(this.manager.baseUrl()));
    }

    protected synchronized String authenticate(String baseUrl) {
        String authId = UUID.randomUUID().toString();
        Space space = this.space();
        space.setAuthId(authId);
        space.setBaseUrl(baseUrl);
        this.saveAuthenticationId(authId);
        AuthService.Authentication authentication = this.createAuthentication(authId);
        return this.authenticate(authentication);
    }

    protected void logout() {
        Optional<AuthService.Authentication> authentication = this.authentication(this.manager.currentSession().id());
        if (!authentication.isPresent()) {
            return;
        }
        try {
            authentication.get().invalidate();
            this.removeAuthentication(this.manager.currentSession().id());
        }
        catch (CouldNotInvalidateAccessToken error) {
            error.printStackTrace();
        }
    }

    protected AlexandriaDisplayNotifier notifier(ActivitySession session, ActivityClient client, AlexandriaDisplay display) {
        return this.notifierProvider.agent(display, this.carrier(session, client));
    }

    Optional<AuthService.Authentication> authentication() {
        return this.authenticationOf((String)this.manager.fromQuery("authId", String.class));
    }

    Optional<AuthService.Authentication> authentication(String sessionId) {
        String authenticationId = authenticationIdMap.get(sessionId);
        return Optional.ofNullable(authenticationMap.get(authenticationId));
    }

    Optional<AuthService.Authentication> authenticationOf(String authenticationId) {
        return Optional.ofNullable(authenticationMap.get(this.locateAuthenticationId(authenticationId)));
    }

    void removeAuthentication(String sessionId) {
        String authenticationId = authenticationIdMap.get(sessionId);
        authenticationIdMap.remove(sessionId);
        authenticationMap.remove(authenticationId);
    }

    String authenticationId() {
        String sessionId = this.manager.currentSession().id();
        return authenticationIdMap.containsKey(sessionId) ? authenticationIdMap.get(sessionId) : null;
    }

    String home() {
        return this.manager.baseUrl();
    }

    private Space space() {
        AuthService authService = this.manager.authService();
        return authService != null ? authService.space() : null;
    }

    private boolean isFederated() {
        return this.manager.authService() != null;
    }

    private void registerAuthentication(String authenticationId, AuthService.Authentication authentication) {
        authenticationMap.put(authenticationId, authentication);
    }

    private String locateAuthenticationId(String authenticationId) {
        if (authenticationId != null && !authenticationId.isEmpty()) {
            this.saveAuthenticationId(authenticationId);
            return authenticationId;
        }
        return authenticationIdMap.get(this.manager.currentSession().id());
    }

    private void saveAuthenticationId(String authenticationId) {
        authenticationIdMap.put(this.manager.currentSession().id(), authenticationId);
    }

    private AuthService.Authentication createAuthentication(String authenticationId) {
        try {
            this.registerAuthentication(authenticationId, this.manager.authService().authenticate());
            return this.authenticationOf(authenticationId).get();
        }
        catch (SpaceAuthCallbackUrlIsNull spaceAuthCallbackUrlIsNull) {
            spaceAuthCallbackUrlIsNull.printStackTrace();
            return null;
        }
    }

    private String authenticate(AuthService.Authentication authentication) {
        try {
            return RequestHelper.post(authentication.authenticationUrl(authentication.requestToken())).toString();
        }
        catch (CouldNotObtainAuthorizationUrl | CouldNotObtainRequestToken | IOException e) {
            LoggerFactory.getLogger((String)"ROOT").error(e.getMessage(), e);
            return null;
        }
    }

    private String errorPageUrl() {
        return this.manager.baseUrl() + "/error";
    }

    private MessageCarrier carrier(ActivitySession session, ActivityClient client) {
        return new MessageCarrier((PushService)this.manager.pushService(), (Session)session, (Client)client);
    }

    private void fillBrowser(ActivitySparkManager manager) {
        Browser browser = manager.currentSession().browser();
        browser.baseUrl(manager.baseUrl());
        browser.homeUrl(manager.baseUrl());
        browser.userHomeUrl(manager.baseUrl() + manager.userHomePath());
        browser.language(manager.languageFromUrl());
        browser.metadataLanguage(manager.languageFromHeader());
        browser.metadataIpAddress(manager.ipAddressFromHeader());
    }
}

