/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.spark.resources;

import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;
import io.intino.konos.alexandria.activity.spark.AssetLoader;
import io.intino.konos.alexandria.activity.spark.resources.Resource;
import io.intino.konos.alexandria.activity.spark.resources.exceptions.AssetNotFoundException;
import io.intino.konos.alexandria.activity.utils.StreamUtil;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import spark.utils.IOUtils;

public class AssetResource
extends Resource {
    private final AssetLoader loader;

    public AssetResource(AssetLoader loader, ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws AlexandriaException {
        InputStream inputStream;
        block6: {
            super.execute();
            String name = this.assetName();
            String contentType = this.assetContentTypeOf();
            inputStream = null;
            if (this.isAssetPathRelative(name)) {
                name = this.loader.asset(name).toString();
            }
            try {
                inputStream = new URL(name).openStream();
                if (contentType != null && !contentType.isEmpty()) {
                    byte[] content = IOUtils.toByteArray((InputStream)inputStream);
                    this.manager.write(new String(content, "UTF-8"), contentType);
                    break block6;
                }
                this.manager.write(inputStream, (String)this.manager.fromQuery("label", String.class), (Boolean)this.manager.fromQuery("embedded", Boolean.class));
            }
            catch (IOException e) {
                try {
                    this.manager.write(new AssetNotFoundException());
                }
                catch (Throwable throwable) {
                    StreamUtil.close(inputStream);
                    throw throwable;
                }
                StreamUtil.close(inputStream);
            }
        }
        StreamUtil.close(inputStream);
    }

    private boolean isAssetPathRelative(String name) {
        try {
            new URL(name);
            return false;
        }
        catch (MalformedURLException e) {
            return true;
        }
    }

    private String assetName() {
        return new String(Base64.getDecoder().decode((String)this.manager.fromPath("name", String.class)));
    }

    private String assetContentTypeOf() {
        String contentType = (String)this.manager.fromQuery("contentType", String.class);
        if (contentType == null) {
            return null;
        }
        return new String(Base64.getDecoder().decode(contentType));
    }
}

