/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.spark.actions;

import cottons.utils.StreamHelper;
import io.intino.konos.alexandria.activity.Asset;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import io.intino.konos.alexandria.activity.services.push.Browser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class AlexandriaPageAction {
    private final String activityName;
    public ActivitySession session;
    public String clientId;
    public String googleApiKey;
    private static final String TemplateName = "/www/%s/%s.html";

    public AlexandriaPageAction(String activityName) {
        this.activityName = activityName;
    }

    protected abstract String title();

    protected abstract URL favicon();

    protected String template(String name) {
        try {
            byte[] templateBytes = StreamHelper.readBytes((InputStream)AlexandriaPageAction.class.getResourceAsStream(String.format(TemplateName, this.activityName, name)));
            String result = new String(templateBytes);
            result = this.addTemplateVariables(result);
            return result;
        }
        catch (IOException e) {
            return "";
        }
    }

    protected String addTemplateVariables(String template) {
        String sessionId = this.session.id();
        String language = this.session.discoverLanguage();
        Browser browser = this.session.browser();
        template = template.replace("$title", this.title());
        template = template.replace("$language", language);
        template = template.replace("$currentSession", sessionId);
        template = template.replace("$client", this.clientId);
        template = template.replace("$baseUrl", browser.baseUrl());
        template = template.replace("$url", browser.baseUrl() + "/" + this.activityName);
        template = template.replace("$pushUrl", browser.pushUrl(sessionId, this.clientId, language));
        template = template.replace("$googleApiKey", this.googleApiKey);
        if (this.favicon() != null) {
            template = template.replace("$favicon", Asset.toResource(this.baseAssetUrl(), this.favicon()).toUrl().toString());
        }
        return template;
    }

    private URL baseAssetUrl() {
        try {
            return new URL(this.session.browser().baseAssetUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

