/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.resources;

import io.intino.konos.alexandria.activity.AlexandriaActivityBox;
import io.intino.konos.alexandria.activity.actions.HomePageAction;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.displays.Soul;
import io.intino.konos.alexandria.activity.services.push.ActivityClient;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;
import io.intino.konos.alexandria.activity.spark.resources.Resource;
import io.intino.konos.alexandria.exceptions.AlexandriaException;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class HomePageResource
extends Resource {
    private final AlexandriaActivityBox box;

    public HomePageResource(AlexandriaActivityBox box, ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
        this.box = box;
    }

    @Override
    public void execute() throws AlexandriaException {
        super.execute();
        this.render();
    }

    private void render() {
        String clientId = UUID.randomUUID().toString();
        HomePageAction action = new HomePageAction();
        action.session = this.manager.currentSession();
        action.session.whenLogin(new Function<String, String>(){

            @Override
            public String apply(String baseUrl) {
                return HomePageResource.this.authenticate(baseUrl);
            }
        });
        action.session.whenLogout(b -> this.logout());
        action.box = this.box;
        action.clientId = clientId;
        action.googleApiKey = "";
        this.manager.pushService().onOpen(client -> {
            if (!client.id().equals(action.clientId)) {
                return false;
            }
            if (client.soul() != null) {
                return false;
            }
            Soul soul = action.prepareSoul((ActivityClient)((Object)client));
            soul.addRegisterDisplayListener(display -> {
                display.inject(this.notifier(action.session, (ActivityClient)((Object)client), (AlexandriaDisplay)display));
                display.inject(action.session);
                display.inject(soul);
                display.inject(() -> soul);
            });
            client.soul(soul);
            this.box.registerSoul(clientId, soul);
            return true;
        });
        this.manager.pushService().onClose(clientId).execute((Consumer)new Consumer<ActivityClient>(){

            @Override
            public void accept(ActivityClient client) {
                HomePageResource.this.box.soul(client.id()).ifPresent(s -> s.destroy());
                HomePageResource.this.box.unRegisterSoul(client.id());
                HomePageResource.this.manager.unRegister(client);
            }
        });
        this.manager.write(action.execute());
    }
}

