/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model.toolbar;

import io.intino.konos.alexandria.activity.Resource;
import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.toolbar.Operation;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;

public class ExportSelection
extends Operation {
    private Instant from = Instant.now(Clock.systemUTC());
    private Instant to = Instant.now(Clock.systemUTC()).plus(1L, ChronoUnit.DAYS);
    private Execution execution;

    public ExportSelection() {
        this.alexandriaIcon("archive");
    }

    public Instant from() {
        return this.from;
    }

    public ExportSelection from(Instant from) {
        this.from = from;
        return this;
    }

    public Instant to() {
        return this.to;
    }

    public ExportSelection to(Instant to) {
        this.to = to;
        return this;
    }

    public Resource execute(Element element, Instant from, Instant to, List<Item> selection, ActivitySession session) {
        List<Object> selectionObjects = selection.stream().map(Item::object).collect(Collectors.toList());
        return this.execution != null ? this.execution.export(element, from, to, selectionObjects, session) : null;
    }

    public ExportSelection execute(Execution execution) {
        this.execution = execution;
        return this;
    }

    public static interface Execution {
        public Resource export(Element var1, Instant var2, Instant var3, List<Object> var4, ActivitySession var5);
    }
}

