/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model.dialog;

import io.intino.konos.alexandria.activity.model.dialog.Structure;
import io.intino.konos.alexandria.activity.model.dialog.Value;
import io.intino.konos.alexandria.activity.model.dialog.Values;
import io.intino.konos.alexandria.activity.utils.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class Form {
    private final transient TypeResolver typeResolver;
    private Map<String, List<Input>> inputsMap = new HashMap<String, List<Input>>();
    private static final String AlphaAndDigits = "[^a-zA-Z0-9]+";

    public Form(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public Map<String, List<Input>> inputs() {
        return this.inputsMap;
    }

    public List<Input> inputs(String path) {
        String[] names = path.split("\\.");
        String name = names[names.length - 1];
        if (NumberUtil.isNumber(name)) {
            return Collections.singletonList(this.input(path));
        }
        Input parent = this.find(String.join((CharSequence)".", Arrays.copyOfRange(names, 0, names.length - 1)));
        if (parent == null) {
            return this.inputsMap.get(Form.normalizeName(path));
        }
        return parent instanceof Section ? ((Section)parent).inputs(names[names.length - 1]) : Collections.emptyList();
    }

    public Input input(String path) {
        return this.find(path);
    }

    public Input input(String name, int pos) {
        if (!this.inputsMap.containsKey(name = Form.normalizeName(name))) {
            return null;
        }
        if (this.inputsMap.get(name).size() <= pos) {
            return null;
        }
        return this.inputsMap.get(name).get(pos);
    }

    private boolean exists(String name) {
        return this.exists(name, 0);
    }

    private boolean exists(String name, int pos) {
        return this.inputsMap.containsKey(name = Form.normalizeName(name)) && this.inputsMap.get(name).size() > pos && this.inputsMap.get(name).get(pos) != null;
    }

    private Input find(String path) {
        int position;
        String[] names = path.split("\\.");
        Input input = this.input(names[0], position = Form.position(path));
        return input != null ? input.find(Arrays.copyOfRange(names, Form.isMultiple(names) ? 2 : 1, names.length)) : null;
    }

    public Input register(String path, Object value) {
        String[] names = path.split("\\.");
        if (names.length == 0) {
            return null;
        }
        int position = Form.position(path);
        if (!this.exists(names[0], position)) {
            this.register(names[0], position, Input.create(path, this.typeResolver));
        }
        Input input = this.input(names[0], position);
        if (!Form.isMultiple(path)) {
            input.clear();
        }
        return input.register(Arrays.copyOfRange(names, Form.isMultiple(names) ? 2 : 1, names.length), value);
    }

    public void unRegister(String path) {
        String[] pathArray = path.split("\\.");
        if (pathArray.length <= 1) {
            this.remove(path, Form.position(path));
            return;
        }
        String parentPath = String.join((CharSequence)".", Arrays.copyOfRange(pathArray, 0, pathArray.length - 1));
        this.find(parentPath).remove(pathArray[pathArray.length - 1], Form.position(path));
    }

    private void remove(String name, int pos) {
        name = Form.normalizeName(name);
        this.inputsMap.get(name).remove(pos);
        if (this.inputsMap.get(name).size() > 0) {
            return;
        }
        this.inputsMap.remove(name);
    }

    private void register(String name, int pos, Input input) {
        if (!this.inputsMap.containsKey(name = Form.normalizeName(name))) {
            this.inputsMap.put(name, new ArrayList());
        }
        Form.fillInputList(this.inputsMap.get(name), pos);
        this.inputsMap.get(name).set(pos, input);
    }

    public static Form fromMap(Map<String, Object> paths, TypeResolver resolver) {
        Form form = new Form(resolver);
        paths.entrySet().forEach(entry -> form.register((String)entry.getKey(), entry.getValue()));
        return form;
    }

    private static String normalizeName(String name) {
        return name.replaceAll(AlphaAndDigits, "");
    }

    private static int position(String path) {
        if (!Form.isMultiple(path)) {
            return 0;
        }
        if (!Form.isSection(path)) {
            return 0;
        }
        Matcher matcher = Pattern.compile("^[^\\.]*\\.([0-9]+)").matcher(path);
        if (!matcher.find()) {
            return 0;
        }
        return Integer.valueOf(matcher.group(1));
    }

    private static int position(String[] path) {
        return Form.isSection(path) ? Form.position(String.join((CharSequence)".", path)) : 0;
    }

    private static boolean isMultiple(String path) {
        return Pattern.compile("^[^\\.]*\\.[0-9]+").matcher(path).find();
    }

    private static boolean isMultiple(String[] path) {
        return Form.isMultiple(String.join((CharSequence)".", path));
    }

    private static boolean isSection(String path) {
        return Pattern.compile("\\.[^0-9]+").matcher(path).find();
    }

    private static boolean isSection(String[] path) {
        return Form.isSection(String.join((CharSequence)".", path));
    }

    private static void fillInputList(List<Input> inputs, int pos) {
        IntStream.range(0, pos + 1).forEach(i -> {
            if (inputs.size() <= i) {
                inputs.add(null);
            }
        });
    }

    public static interface TypeResolver {
        public String type(Input var1);
    }

    public static class Section
    extends Input {
        private Map<String, List<Input>> inputsMap = new HashMap<String, List<Input>>();

        public Section(String name, TypeResolver typeResolver) {
            super(name, typeResolver);
        }

        private boolean exists(String name, int pos) {
            return this.inputsMap.containsKey(name = Form.normalizeName(name)) && this.inputsMap.get(name).size() > pos && this.inputsMap.get(name).get(pos) != null;
        }

        public Map<String, List<Input>> inputs() {
            return this.inputsMap;
        }

        public List<Input> inputs(String name) {
            name = Form.normalizeName(name);
            return this.inputsMap.get(name);
        }

        public Input input(String path) {
            return this.find(path.split("\\."));
        }

        public Input input(String name, int pos) {
            if (!this.inputsMap.containsKey(name = Form.normalizeName(name))) {
                return null;
            }
            if (this.inputsMap.get(name).size() <= pos) {
                return null;
            }
            return this.inputsMap.get(name).get(pos);
        }

        @Override
        public Value value() {
            return new Value(this.structure());
        }

        private Structure structure() {
            Structure result = new Structure();
            this.inputsMap.values().forEach(inputs -> result.put(((Input)inputs.get(0)).name(), ((Input)inputs.get(0)).value()));
            return result;
        }

        @Override
        public Input find(String[] path) {
            if (path.length == 0) {
                return this;
            }
            int position = Form.position(path);
            Input input = this.input(path[0], position);
            return input != null ? input.find(Arrays.copyOfRange(path, Form.isMultiple(path) ? 2 : 1, path.length)) : null;
        }

        @Override
        public Input register(String[] path, Object value) {
            if (path.length == 0) {
                return null;
            }
            int position = Form.position(path);
            if (!this.exists(path[0], position)) {
                this.register(path[0], position, Input.create(path, this.typeResolver));
            }
            Input input = this.input(path[0], position);
            if (!Form.isMultiple(path)) {
                input.clear();
            }
            return input.register(Arrays.copyOfRange(path, Form.isMultiple(path) ? 2 : 1, path.length), value);
        }

        @Override
        public void remove(String name, int pos) {
            name = Form.normalizeName(name);
            this.inputsMap.get(name).remove(pos);
            if (this.inputsMap.get(name).size() > 0) {
                return;
            }
            this.inputsMap.remove(name);
        }

        private void register(String name, int pos, Input input) {
            if (!this.inputsMap.containsKey(name = Form.normalizeName(name))) {
                this.inputsMap.put(name, new ArrayList());
            }
            Form.fillInputList(this.inputsMap.get(name), pos);
            this.inputsMap.get(name).set(pos, input);
        }
    }

    public static class Input {
        private transient String name;
        private Values values = new Values();
        protected transient TypeResolver typeResolver;

        public Input(String name, TypeResolver typeResolver) {
            this.name = name;
            this.typeResolver = typeResolver;
        }

        public Input clear() {
            this.values.clear();
            return this;
        }

        public Input register(String[] path, Object value) {
            this.values.add(new Value(value));
            return this;
        }

        protected void register(List<Object> values) {
            this.values.clear();
            values.forEach(v -> values.add(new Value(v)));
        }

        public String name() {
            return this.name;
        }

        public String type() {
            return this.typeResolver.type(this);
        }

        public Value value() {
            return this.values.size() > 0 ? (Value)this.values.get(0) : null;
        }

        public Values values() {
            return this.values;
        }

        public Input value(Object value) {
            this.values.clear();
            this.values.add(new Value(value));
            return this;
        }

        public Input values(List<Object> values) {
            this.register(values);
            return this;
        }

        private static Input create(String path, TypeResolver resolver) {
            String[] names = path.split("\\.");
            return Form.isSection(path) ? new Section(names[0], resolver) : new Input(names[0], resolver);
        }

        private static Input create(String[] path, TypeResolver resolver) {
            return Form.isSection(path) ? new Section(path[0], resolver) : new Input(path[0], resolver);
        }

        public Input find(String[] path) {
            return this;
        }

        public void remove(String name, int pos) {
            this.values.remove(pos);
        }
    }
}

