/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model.catalog.arrangement;

import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Group;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.GroupMap;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GroupingManager {
    private List<Item> items;
    private final List<Grouping> groupings;
    private Map<Grouping, GroupMap> groups;
    private Map<String, List<String>> filteredGroupings = new HashMap<String, List<String>>();
    private Catalog.ArrangementFilterer filter;
    private String fixedGrouping = null;

    public GroupingManager(List<Item> items, List<Grouping> groupings, Catalog.ArrangementFilterer filter) {
        this.filter = filter;
        this.groupings = groupings;
        this.items(items);
    }

    public void items(List<Item> items) {
        this.items = items;
        this.groups = this.calculateGroupings(items);
    }

    private Map<Grouping, GroupMap> calculateGroupings(List<Item> items) {
        ActivitySession session = this.filter != null ? this.filter.session() : null;
        List<Item> groupingManagerItems = this.items;
        return this.groupings.stream().collect(Collectors.toMap(g -> g, g -> this.filteredGroupings.keySet().contains(g.name()) ? g.groups(groupingManagerItems, session) : g.groups(items, session)));
    }

    public void filter(String groupingName, List<String> groups) {
        Grouping grouping = this.grouping(groupingName);
        List<String> groupNames = groups.stream().map(Group::name).collect(Collectors.toList());
        if (this.filter != null) {
            this.filter.add(grouping.name(), this.collect(groupNames, grouping));
        }
        this.filteredGroupings.put(groupingName, groupNames);
        this.fixedGrouping = groupingName;
    }

    public void clearFilter() {
        if (this.filter != null) {
            this.filter.clear();
        }
        this.filteredGroupings.clear();
        this.fixedGrouping = null;
    }

    public List<String> filteredGroups(Grouping grouping) {
        String key = grouping.name();
        return this.filteredGroupings.containsKey(key) ? this.filteredGroupings.get(key) : Collections.emptyList();
    }

    public GroupMap groups(Grouping grouping) {
        return this.groups(grouping.name());
    }

    public GroupMap groups(String grouping) {
        List<Item> items = this.filteredItems();
        return this.groups(items).entrySet().stream().filter(e -> ((Grouping)e.getKey()).name().equals(grouping) || ((Grouping)e.getKey()).label().equals(grouping)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private Group[] collect(List<String> groups, Grouping grouping) {
        return (Group[])groups.stream().map(c -> (Group)this.groups.get(grouping).get(c)).filter(Objects::nonNull).toArray(Group[]::new);
    }

    private Map<Grouping, GroupMap> groups(List<Item> items) {
        if (this.filter == null || this.filter.isEmpty()) {
            return this.groups;
        }
        return this.calculateGroupings(items);
    }

    private Grouping grouping(String groupingName) {
        return this.groupings.stream().filter(g -> g.name().equals(groupingName)).findFirst().orElse(null);
    }

    private List<Item> filteredItems() {
        if (this.filter == null || this.filter.isEmpty()) {
            return this.items;
        }
        return this.items.stream().filter(item -> this.filter.contains((Item)item)).collect(Collectors.toList());
    }
}

