/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.HashMap;
import java.util.Map;

public enum TimeScale {
    Year(ChronoUnit.YEARS){

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Year)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Year)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(LocalDateTime.of(this.yearOf(instant), 1, 1, 0, 0, 0));
        }

        @Override
        public long toMillis(long value) {
            return Day.toMillis((long)((double)value * 365.25));
        }

        @Override
        public String category(Instant instant, String format, String language) {
            return String.valueOf(this.yearOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.yearOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return String.valueOf(this.yearOf(instant));
        }
    }
    ,
    QuarterOfYear(ChronoUnit.MONTHS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("MM/yyyy");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)QuarterOfYear)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)QuarterOfYear)).get(language);
        }

        @Override
        public long instantsBetween(Instant start, Instant end) {
            return Math.max(ChronoUnit.MONTHS.between(this.dateTimeOf(start), this.dateTimeOf(end)) / 3L, 1L);
        }

        @Override
        public Instant addTo(Instant time, long amount) {
            return this.instantOf(ChronoUnit.MONTHS.addTo(this.dateTimeOf(time), 3L * amount));
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withMonth(this.firstMonthOfQuarter(instant)).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Month.toMillis(value * 3L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            int quarter = this.quarterNumber(instant);
            String category = (String)((Map)words.get("Category.Quarter" + quarter)).get(language);
            if (format.equalsIgnoreCase("QuarterOfYear")) {
                category = category + " " + this.yearOf(instant);
            }
            return category;
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.quarterNumber(instant);
        }

        @Override
        public String toString(Instant instant) {
            return "Q" + this.quarterNumber(instant) + " (" + this.range(instant) + ")";
        }

        private String range(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant)) + " - " + this.Formatter.format(this.dateTimeOf(this.nextTime(instant)));
        }

        private int quarterNumber(Instant instant) {
            return (this.monthNumberOf(instant) - 1) / 3 + 1;
        }

        private int firstMonthOfQuarter(Instant instant) {
            return (this.monthNumberOf(instant) - 1) / 3 * 3 + 1;
        }
    }
    ,
    Month(ChronoUnit.MONTHS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("MM/yyyy");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Month)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Month)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Day.toMillis(value * 30L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            int month = this.dateTimeOf(instant).getMonthValue();
            String category = (String)((Map)words.get("Category.Month" + month)).get(language);
            if (format.equalsIgnoreCase("MonthOfYear")) {
                category = category + " " + this.yearOf(instant);
            }
            return category;
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.dateTimeOf(instant).getMonthValue();
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    Week(ChronoUnit.WEEKS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Week)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Week)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).with(WeekFields.ISO.dayOfWeek(), 1L).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Day.toMillis(value * 7L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            int week = dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
            String category = (String)((Map)words.get("Category.Week")).get(language) + " " + TimeScale.format(week, 2);
            if (format.equalsIgnoreCase("WeekOfYear")) {
                category = category + " " + this.yearOf(instant);
            }
            return category;
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
        }

        @Override
        public String toString(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return "Week " + TimeScale.format(dateTime.get(ChronoField.ALIGNED_WEEK_OF_YEAR), 2) + " (" + this.range(instant) + ")";
        }

        private String range(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return this.Formatter.format(dateTime) + " - " + this.Formatter.format(this.dateTimeOf(this.nextTime(instant)));
        }
    }
    ,
    Day(ChronoUnit.DAYS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Day)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Day)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withHour(0).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return SixHours.toMillis(value * 4L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            if (format.equalsIgnoreCase("DayOfYear")) {
                return (String)((Map)words.get("Category.Day")).get(language) + " " + dateTime.getDayOfYear();
            }
            if (format.equalsIgnoreCase("DayOfMonth")) {
                return (String)((Map)words.get("Category.Day")).get(language) + " " + dateTime.getDayOfMonth();
            }
            return (String)((Map)words.get("Category.Day" + dateTime.getDayOfWeek().ordinal())).get(language);
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            if (format.equalsIgnoreCase("DayOfYear")) {
                return this.dateTimeOf(instant).getDayOfYear();
            }
            if (format.equalsIgnoreCase("DayOfMonth")) {
                return this.dateTimeOf(instant).getDayOfMonth();
            }
            return this.dateTimeOf(instant).getDayOfWeek().ordinal();
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    SixHours(ChronoUnit.HOURS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)SixHours)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)SixHours)).get(language);
        }

        @Override
        public long instantsBetween(Instant start, Instant end) {
            return Math.max(ChronoUnit.HOURS.between(start, end) / 5L, 1L);
        }

        @Override
        public Instant addTo(Instant time, long amount) {
            return this.instantOf(ChronoUnit.HOURS.addTo(this.dateTimeOf(time), 6L * amount));
        }

        private int quarter(int hour) {
            return hour / 6 * 6;
        }

        @Override
        public Instant normalise(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return this.instantOf(dateTime.withHour(this.quarter(dateTime.getHour())).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Hour.toMillis(value * 6L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            int hourBefore = this.hourOf(this.addTo(instant, -1L));
            return TimeScale.format(hourBefore, 2) + " - " + TimeScale.format(this.hourOf(instant), 2);
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.hourOf(this.addTo(instant, -1L));
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(this.addTo(instant, -1L))) + " (" + TimeScale.format(this.hourOf(this.addTo(instant, -1L)), 2) + " - " + TimeScale.format(this.hourOf(instant), 2) + ")";
        }
    }
    ,
    Hour(ChronoUnit.HOURS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("HH");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Hour)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Hour)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withMinute(0).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return FifteenMinutes.toMillis(value * 4L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.hourOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    FifteenMinutes(ChronoUnit.MINUTES){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)FifteenMinutes)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)FifteenMinutes)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            LocalDateTime dateTime = this.dateTimeOf(instant);
            return this.instantOf(dateTime.withMinute(this.quarter(dateTime.getMinute())).withSecond(0).withNano(0));
        }

        @Override
        public long instantsBetween(Instant start, Instant end) {
            return Math.max(ChronoUnit.MINUTES.between(start, end) / 14L, 1L);
        }

        @Override
        public Instant addTo(Instant time, long amount) {
            return this.instantOf(ChronoUnit.MINUTES.addTo(this.dateTimeOf(time), 15L * amount));
        }

        @Override
        public long toMillis(long value) {
            return Minute.toMillis(value * 15L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            int beforeMinute = this.minuteOf(this.addTo(instant, -1L));
            return TimeScale.format(beforeMinute, 2) + " - " + TimeScale.format(this.minuteOf(instant), 2);
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.minuteOf(this.addTo(instant, -1L));
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(this.addTo(instant, -1L))) + " (" + TimeScale.format(this.minuteOf(this.addTo(instant, -1L)), 2) + " - " + TimeScale.format(this.minuteOf(instant), 2) + ")";
        }

        private int quarter(int minutes) {
            return minutes / 15 * 15;
        }
    }
    ,
    Minute(ChronoUnit.MINUTES){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("mm");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Minute)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Minute)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return this.instantOf(this.dateTimeOf(instant).withSecond(0).withNano(0));
        }

        @Override
        public long toMillis(long value) {
            return Second.toMillis(value * 60L);
        }

        @Override
        public String category(Instant instant, String format, String language) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.minuteOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    }
    ,
    Second(ChronoUnit.SECONDS){
        private final DateTimeFormatter Formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
        private final DateTimeFormatter CategoryFormatter = DateTimeFormatter.ofPattern("ss");

        @Override
        public String label(String language) {
            return (String)((Map)labels.get((Object)Second)).get(language);
        }

        @Override
        public String symbol(String language) {
            return (String)((Map)symbols.get((Object)Second)).get(language);
        }

        @Override
        public Instant normalise(Instant instant) {
            return instant;
        }

        @Override
        public long toMillis(long value) {
            return value * 1000L;
        }

        @Override
        public String category(Instant instant, String format, String language) {
            return this.CategoryFormatter.format(this.dateTimeOf(instant));
        }

        @Override
        public int sortingWeight(Instant instant, String format) {
            return this.secondOf(instant);
        }

        @Override
        public String toString(Instant instant) {
            return this.Formatter.format(this.dateTimeOf(instant));
        }
    };

    private final ChronoUnit unit;
    private static Map<TimeScale, Map<String, String>> labels;
    private static Map<TimeScale, Map<String, String>> symbols;
    private static Map<String, Map<String, String>> words;

    private TimeScale(ChronoUnit unit) {
        this.unit = unit;
    }

    private static String format(int number, int withDecimals) {
        return String.format("%0" + withDecimals + "d", number);
    }

    public abstract Instant normalise(Instant var1);

    public abstract String toString(Instant var1);

    public Instant nextTime(Instant time) {
        return this.addTo(time, 1L);
    }

    public long instantsBetween(Instant start, Instant end) {
        return Math.max(this.unit.between(this.dateTimeOf(start), this.unit.addTo(this.dateTimeOf(end), 1L)), 1L);
    }

    public abstract long toMillis(long var1);

    public Instant addTo(Instant time, long amount) {
        return this.instantOf(this.unit.addTo(this.dateTimeOf(time), amount));
    }

    public Instant floor(Instant time) {
        return time.truncatedTo(this.unit);
    }

    public boolean accept(Enum value) {
        return value instanceof TimeScale;
    }

    public abstract String label(String var1);

    public abstract String symbol(String var1);

    public abstract String category(Instant var1, String var2, String var3);

    public abstract int sortingWeight(Instant var1, String var2);

    public TimeScale next() {
        int ordinal = this.ordinal();
        if (++ordinal > ChronoUnit.SECONDS.ordinal()) {
            return Second;
        }
        return TimeScale.values()[ordinal];
    }

    protected int yearOf(Instant instant) {
        return this.dateTimeOf(instant).getYear();
    }

    protected Month monthOf(Instant instant) {
        return this.dateTimeOf(instant).getMonth();
    }

    protected int monthNumberOf(Instant instant) {
        return this.dateTimeOf(instant).getMonthValue();
    }

    protected int dayOfYearOf(Instant instant) {
        return this.dateTimeOf(instant).getDayOfYear();
    }

    protected int dayOfMonthOf(Instant instant) {
        return this.dateTimeOf(instant).getDayOfMonth();
    }

    protected int hourOf(Instant instant) {
        return this.dateTimeOf(instant).getHour();
    }

    protected int minuteOf(Instant instant) {
        return this.dateTimeOf(instant).getMinute();
    }

    protected int secondOf(Instant instant) {
        return this.dateTimeOf(instant).getSecond();
    }

    protected ZoneId utc() {
        return ZoneId.of("UTC");
    }

    protected ZoneOffset utcOffset() {
        return ZoneOffset.UTC;
    }

    protected Instant instantOf(LocalDateTime dateTime) {
        return dateTime.toInstant(this.utcOffset());
    }

    LocalDateTime dateTimeOf(Instant instant) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(instant.toEpochMilli()), this.utc());
    }

    static {
        labels = new HashMap<TimeScale, Map<String, String>>(){
            {
                this.put(Year, new HashMap<String, String>(){
                    {
                        this.put("es", "a\u00f1o");
                        this.put("en", "year");
                    }
                });
                this.put(QuarterOfYear, new HashMap<String, String>(){
                    {
                        this.put("es", "trimestre");
                        this.put("en", "quarter of year");
                    }
                });
                this.put(Month, new HashMap<String, String>(){
                    {
                        this.put("es", "mes");
                        this.put("en", "month");
                    }
                });
                this.put(Week, new HashMap<String, String>(){
                    {
                        this.put("es", "semana");
                        this.put("en", "week");
                    }
                });
                this.put(Day, new HashMap<String, String>(){
                    {
                        this.put("es", "d\u00eda");
                        this.put("en", "day");
                    }
                });
                this.put(SixHours, new HashMap<String, String>(){
                    {
                        this.put("es", "seis horas");
                        this.put("en", "six hours");
                    }
                });
                this.put(Hour, new HashMap<String, String>(){
                    {
                        this.put("es", "hora");
                        this.put("en", "hour");
                    }
                });
                this.put(FifteenMinutes, new HashMap<String, String>(){
                    {
                        this.put("es", "quince minutos");
                        this.put("en", "fifteen minutes");
                    }
                });
                this.put(Minute, new HashMap<String, String>(){
                    {
                        this.put("es", "minuto");
                        this.put("en", "minute");
                    }
                });
                this.put(Second, new HashMap<String, String>(){
                    {
                        this.put("es", "segundo");
                        this.put("en", "second");
                    }
                });
            }
        };
        symbols = new HashMap<TimeScale, Map<String, String>>(){
            {
                this.put(Year, new HashMap<String, String>(){
                    {
                        this.put("es", "A");
                        this.put("en", "Y");
                    }
                });
                this.put(QuarterOfYear, new HashMap<String, String>(){
                    {
                        this.put("es", "C");
                        this.put("en", "Q");
                    }
                });
                this.put(Month, new HashMap<String, String>(){
                    {
                        this.put("es", "M");
                        this.put("en", "M");
                    }
                });
                this.put(Week, new HashMap<String, String>(){
                    {
                        this.put("es", "S");
                        this.put("en", "W");
                    }
                });
                this.put(Day, new HashMap<String, String>(){
                    {
                        this.put("es", "D");
                        this.put("en", "D");
                    }
                });
                this.put(SixHours, new HashMap<String, String>(){
                    {
                        this.put("es", "6h");
                        this.put("en", "6h");
                    }
                });
                this.put(Hour, new HashMap<String, String>(){
                    {
                        this.put("es", "h");
                        this.put("en", "h");
                    }
                });
                this.put(FifteenMinutes, new HashMap<String, String>(){
                    {
                        this.put("es", "15'");
                        this.put("en", "15'");
                    }
                });
                this.put(Minute, new HashMap<String, String>(){
                    {
                        this.put("es", "m");
                        this.put("en", "m");
                    }
                });
                this.put(Second, new HashMap<String, String>(){
                    {
                        this.put("es", "s");
                        this.put("en", "s");
                    }
                });
            }
        };
        words = new HashMap<String, Map<String, String>>(){
            {
                this.put("Category.Quarter1", new HashMap<String, String>(){
                    {
                        this.put("es", "1er trimestre");
                        this.put("en", "1st quarter");
                    }
                });
                this.put("Category.Quarter2", new HashMap<String, String>(){
                    {
                        this.put("es", "2do trimestre");
                        this.put("en", "2nd quarter");
                    }
                });
                this.put("Category.Quarter3", new HashMap<String, String>(){
                    {
                        this.put("es", "3er trimestre");
                        this.put("en", "3th quarter");
                    }
                });
                this.put("Category.Quarter4", new HashMap<String, String>(){
                    {
                        this.put("es", "4to trimestre");
                        this.put("en", "4th quarter");
                    }
                });
                this.put("Category.Month1", new HashMap<String, String>(){
                    {
                        this.put("es", "Enero");
                        this.put("en", "January");
                    }
                });
                this.put("Category.Month2", new HashMap<String, String>(){
                    {
                        this.put("es", "Febrero");
                        this.put("en", "February");
                    }
                });
                this.put("Category.Month3", new HashMap<String, String>(){
                    {
                        this.put("es", "Marzo");
                        this.put("en", "March");
                    }
                });
                this.put("Category.Month4", new HashMap<String, String>(){
                    {
                        this.put("es", "Abril");
                        this.put("en", "April");
                    }
                });
                this.put("Category.Month5", new HashMap<String, String>(){
                    {
                        this.put("es", "Mayo");
                        this.put("en", "May");
                    }
                });
                this.put("Category.Month6", new HashMap<String, String>(){
                    {
                        this.put("es", "Junio");
                        this.put("en", "June");
                    }
                });
                this.put("Category.Month7", new HashMap<String, String>(){
                    {
                        this.put("es", "Julio");
                        this.put("en", "July");
                    }
                });
                this.put("Category.Month8", new HashMap<String, String>(){
                    {
                        this.put("es", "Agosto");
                        this.put("en", "August");
                    }
                });
                this.put("Category.Month9", new HashMap<String, String>(){
                    {
                        this.put("es", "Septiembre");
                        this.put("en", "September");
                    }
                });
                this.put("Category.Month10", new HashMap<String, String>(){
                    {
                        this.put("es", "Octubre");
                        this.put("en", "October");
                    }
                });
                this.put("Category.Month11", new HashMap<String, String>(){
                    {
                        this.put("es", "Noviembre");
                        this.put("en", "November");
                    }
                });
                this.put("Category.Month12", new HashMap<String, String>(){
                    {
                        this.put("es", "Diciembre");
                        this.put("en", "December");
                    }
                });
                this.put("Category.Week", new HashMap<String, String>(){
                    {
                        this.put("es", "Semana");
                        this.put("en", "Week");
                    }
                });
                this.put("Category.Day", new HashMap<String, String>(){
                    {
                        this.put("es", "D\u00eda");
                        this.put("en", "Day");
                    }
                });
                this.put("Category.Day0", new HashMap<String, String>(){
                    {
                        this.put("es", "Lunes");
                        this.put("en", "Monday");
                    }
                });
                this.put("Category.Day1", new HashMap<String, String>(){
                    {
                        this.put("es", "Martes");
                        this.put("en", "Tuesday");
                    }
                });
                this.put("Category.Day2", new HashMap<String, String>(){
                    {
                        this.put("es", "Mi\u00e9rcoles");
                        this.put("en", "Wednesday");
                    }
                });
                this.put("Category.Day3", new HashMap<String, String>(){
                    {
                        this.put("es", "Jueves");
                        this.put("en", "Thursday");
                    }
                });
                this.put("Category.Day4", new HashMap<String, String>(){
                    {
                        this.put("es", "Viernes");
                        this.put("en", "Friday");
                    }
                });
                this.put("Category.Day5", new HashMap<String, String>(){
                    {
                        this.put("es", "S\u00e1bado");
                        this.put("en", "Saturday");
                    }
                });
                this.put("Category.Day6", new HashMap<String, String>(){
                    {
                        this.put("es", "Domingo");
                        this.put("en", "Sunday");
                    }
                });
            }
        };
    }
}

