/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model;

import io.intino.konos.alexandria.activity.model.Catalog;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.model.catalog.Scope;
import io.intino.konos.alexandria.activity.model.catalog.TemporalFilter;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TemporalCatalog
extends Catalog {
    private ObjectsLoader objectsLoader;
    private RootObjectLoader rootObjectLoader;
    private DefaultObjectLoader defaultObjectLoader;
    private RangeLoader rangeLoader;
    private ObjectCreatedLoader objectCreatedLoader;
    private List<TimeScale> scales = new ArrayList<TimeScale>();
    private int maxZoom = 5;
    private TemporalFilter temporalFilter;
    private Type type = Type.Time;

    public Type type() {
        return this.type;
    }

    public TemporalCatalog type(Type type) {
        this.type = type;
        return this;
    }

    public Item rootItem(List<Item> itemList, TimeRange range, ActivitySession session) {
        return this.rootObjectLoader != null ? this.item(this.rootObjectLoader.load(this.objects(itemList), range, session)) : null;
    }

    public TemporalCatalog rootObjectLoader(RootObjectLoader loader) {
        this.rootObjectLoader = loader;
        return this;
    }

    public Item defaultItem(String id, TimeRange range, ActivitySession session) {
        return this.defaultObjectLoader != null ? this.item(this.defaultObjectLoader.load(id, range, session)) : null;
    }

    public TemporalCatalog defaultObjectLoader(DefaultObjectLoader loader) {
        this.defaultObjectLoader = loader;
        return this;
    }

    @Override
    public Item item(Object object) {
        Item item = super.item(object);
        if (item == null) {
            return null;
        }
        item.created(this.created(object));
        return item;
    }

    public ItemList items(Scope scope, String condition, TimeRange range, ActivitySession session) {
        if (this.objectsLoader == null) {
            return new ItemList();
        }
        return new ItemList(this.objectsLoader.load(scope, condition, range, session).stream().map(this::item).collect(Collectors.toList()));
    }

    public TemporalCatalog objectsLoader(ObjectsLoader loader) {
        this.objectsLoader = loader;
        return this;
    }

    public TimeRange range(ActivitySession session) {
        return this.rangeLoader != null ? this.rangeLoader.load(session) : null;
    }

    public TemporalCatalog rangeLoader(RangeLoader loader) {
        this.rangeLoader = loader;
        return this;
    }

    public Instant created(Item item) {
        return this.objectCreatedLoader != null ? this.objectCreatedLoader.created(item != null ? item.object() : null) : null;
    }

    public TemporalCatalog objectCreatedLoader(ObjectCreatedLoader calculator) {
        this.objectCreatedLoader = calculator;
        return this;
    }

    public List<TimeScale> scales() {
        return this.scales;
    }

    public TemporalCatalog scales(List<TimeScale> scales) {
        this.scales = scales;
        return this;
    }

    public int maxZoom() {
        return this.maxZoom;
    }

    public TemporalCatalog maxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public boolean temporalFilterEnabled(Scope scope, ActivitySession session) {
        return this.temporalFilter == null || this.temporalFilter.enabled(this, scope, session);
    }

    public boolean temporalFilterVisible(Scope scope, ActivitySession session) {
        return this.temporalFilter == null || this.temporalFilter.visible(this, scope, session);
    }

    public TemporalFilter.Layout temporalFilterLayout() {
        return this.temporalFilter != null ? this.temporalFilter.layout() : TemporalFilter.Layout.Horizontal;
    }

    public TemporalCatalog temporalFilter(TemporalFilter filter) {
        this.temporalFilter = filter;
        return this;
    }

    private Instant created(Object object) {
        return this.objectCreatedLoader != null ? this.objectCreatedLoader.created(object) : null;
    }

    public static interface RangeLoader {
        public TimeRange load(ActivitySession var1);
    }

    public static interface ObjectCreatedLoader {
        public Instant created(Object var1);
    }

    public static interface DefaultObjectLoader {
        public Object load(String var1, TimeRange var2, ActivitySession var3);
    }

    public static interface RootObjectLoader {
        public Object load(List<Object> var1, TimeRange var2, ActivitySession var3);
    }

    public static interface ObjectsLoader {
        public List<Object> load(Scope var1, String var2, TimeRange var3, ActivitySession var4);
    }

    public static enum Type {
        Time,
        Range;

    }
}

