/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model;

import io.intino.konos.alexandria.activity.displays.providers.ElementViewDisplayProvider;
import io.intino.konos.alexandria.activity.model.Item;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ItemList {
    private List<Item> items;
    private ElementViewDisplayProvider.Sorting sorting = null;

    public ItemList() {
        this.items = new ArrayList<Item>();
    }

    public ItemList(List<Item> items) {
        this.items = items;
    }

    public int count() {
        return this.items.size();
    }

    public void filter(Function<Item, Boolean> filter) {
        this.items = this.items.stream().filter(filter::apply).collect(Collectors.toList());
    }

    public void filterCount(int maxItems) {
        this.items = this.items.subList(0, maxItems > this.items.size() ? this.items.size() : maxItems);
    }

    public ItemList sort(ElementViewDisplayProvider.Sorting sorting) {
        if (sorting == null || this.sorting == sorting) {
            return this;
        }
        this.sorting = sorting;
        this.items.sort(sorting::comparator);
        if (sorting.mode() == ElementViewDisplayProvider.Sorting.Mode.Descendant) {
            Collections.reverse(this.items);
        }
        return this;
    }

    public List<Item> items() {
        return this.items;
    }

    public List<Item> items(int start, int limit) {
        int end = start + limit;
        if (end > this.items.size()) {
            end = this.items.size();
        }
        return this.items.subList(start, end);
    }

    public List<Item> items(int start, int limit, ElementViewDisplayProvider.Sorting sorting) {
        this.sort(sorting);
        return this.items(start, limit);
    }
}

