/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model;

import io.intino.konos.alexandria.activity.model.AbstractView;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.Toolbar;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class Element {
    private String name;
    private String label;
    private Object type;
    private Toolbar toolbar;
    private List<AbstractView> viewList = new ArrayList<AbstractView>();
    private ObjectLoader objectLoader;
    private ObjectIdLoader objectIdLoader;
    private ObjectNameLoader objectNameLoader;

    public String name() {
        return this.name;
    }

    public Element name(String name) {
        this.name = name;
        return this;
    }

    public String label() {
        return this.label;
    }

    public Element label(String label) {
        this.label = label;
        return this;
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public Element toolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
        return this;
    }

    public List<AbstractView> views() {
        return this.viewList;
    }

    public Element add(AbstractView view) {
        this.viewList.add(view);
        return this;
    }

    public Item item(String id, ActivitySession session) {
        return this.objectLoader != null ? this.item(this.objectLoader.load(id, session)) : null;
    }

    public Item item(Object object) {
        if (object == null) {
            return null;
        }
        return new Item().id(this.id(object)).name(this.name(object)).object(object);
    }

    public Element objectLoader(ObjectLoader loader) {
        this.objectLoader = loader;
        return this;
    }

    public Element objectIdLoader(ObjectIdLoader loader) {
        this.objectIdLoader = loader;
        return this;
    }

    public Element objectNameLoader(ObjectNameLoader loader) {
        this.objectNameLoader = loader;
        return this;
    }

    protected List<Object> objects(List<Item> itemList) {
        return itemList.stream().map(Item::object).collect(Collectors.toList());
    }

    private String id(Object object) {
        return this.objectLoader != null ? this.objectIdLoader.load(object) : null;
    }

    private String name(Object object) {
        return this.objectLoader != null ? this.objectNameLoader.load(object) : null;
    }

    public static interface ObjectNameLoader {
        public String load(Object var1);
    }

    public static interface ObjectIdLoader {
        public String load(Object var1);
    }

    public static interface ObjectLoader {
        public Object load(String var1, ActivitySession var2);
    }
}

