/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model;

import com.google.gson.GsonBuilder;
import io.intino.konos.alexandria.activity.displays.DialogExecution;
import io.intino.konos.alexandria.activity.displays.DialogSource;
import io.intino.konos.alexandria.activity.displays.DialogValidator;
import io.intino.konos.alexandria.activity.displays.adapters.gson.FormAdapter;
import io.intino.konos.alexandria.activity.model.dialog.Form;
import io.intino.konos.alexandria.activity.model.dialog.Value;
import io.intino.konos.alexandria.activity.model.dialog.Values;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Dialog {
    private String url;
    private String label = "";
    private String description = "";
    private TabsMode mode = TabsMode.Tabs;
    private boolean readonly;
    private List<Tab> tabList = new ArrayList<Tab>();
    private Toolbar toolbar = new Toolbar();
    private Object target = null;
    private final Form form;
    public static final String PathSeparatorRegExp = "\\.";
    public static final String PathSeparator = ".";

    public Dialog() {
        this.form = new Form(input -> this.input(input.name()).getClass().getSimpleName().toLowerCase());
    }

    protected Dialog(Form form) {
        this.form = form;
    }

    public String url() {
        return this.url;
    }

    public Dialog url(String url) {
        this.url = url;
        return this;
    }

    public String label() {
        return this.label;
    }

    public Dialog label(String label) {
        this.label = label;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Dialog description(String description) {
        this.description = description;
        return this;
    }

    public TabsMode mode() {
        return this.mode;
    }

    public Dialog mode(TabsMode mode) {
        this.mode = mode;
        return this;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public Dialog readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public <T> T target() {
        return (T)this.target;
    }

    public Dialog target(Object target) {
        this.target = target;
        return this;
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public Tab createTab(String label) {
        Tab tab = new Tab(label);
        this.tabList().add(tab);
        return tab;
    }

    public Toolbar.Operation operation(String label) {
        return this.toolbar.operation(label);
    }

    public List<Tab> tabList() {
        return this.tabList;
    }

    public <I extends Tab.Input> I input(String path) {
        String key = this.formInput(path).name();
        Tab.Input result = this.inputs().stream().filter(input -> input.name().equals(key) || input.label().equals(key)).findFirst().orElse(null);
        if (result == null) {
            return null;
        }
        result.path(path);
        return (I)result;
    }

    private List<Tab.Input> inputs() {
        return this.tabList().stream().map(Tab::inputList).flatMap(Collection::stream).map(this::inputs).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Tab.Input> inputs(Tab.Input input) {
        if (!(input instanceof Tab.Section)) {
            return Collections.singletonList(input);
        }
        ArrayList<Tab.Input> result = new ArrayList<Tab.Input>();
        result.add(input);
        ((Tab.Section)input).inputList.forEach(child -> result.addAll(this.inputs((Tab.Input)child)));
        return result;
    }

    private Form.Input formInput(String path) {
        Form.Input input = this.form.input(path);
        if (input == null) {
            input = this.form.register(path, null);
            input.clear();
        }
        return input;
    }

    public void register(String path, Object value) {
        this.form.register(path, value);
    }

    public void unRegister(String path) {
        this.form.unRegister(path);
    }

    public String serialize() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Form.class, (Object)new FormAdapter());
        gsonBuilder.setPrettyPrinting();
        return gsonBuilder.create().toJson((Object)this.form);
    }

    public class Tab {
        private String label;
        private List<Input> inputList = new ArrayList<Input>();

        public Tab(String label) {
            this.label(label);
        }

        public String label() {
            return this.label;
        }

        public Tab label(String label) {
            this.label = label;
            return this;
        }

        public List<Input> inputList() {
            return this.inputList;
        }

        public Text createText() {
            return this.add(new Text());
        }

        public Section createSection() {
            return this.add(new Section());
        }

        public Memo createMemo() {
            return this.add(new Memo());
        }

        public Password createPassword() {
            return this.add(new Password());
        }

        public RadioBox createRadioBox() {
            return this.add(new RadioBox());
        }

        public CheckBox createCheckBox() {
            return this.add(new CheckBox());
        }

        public ComboBox createComboBox() {
            return this.add(new ComboBox());
        }

        public File createFile() {
            return this.add(new File());
        }

        public Picture createPicture() {
            return this.add(new Picture());
        }

        public Date createDate() {
            return this.add(new Date());
        }

        public DateTime createDateTime() {
            return this.add(new DateTime());
        }

        private <I extends Input> I add(I input) {
            this.inputList.add(input);
            return input;
        }

        public class DateTime
        extends Input {
            private String format;

            public String format() {
                return this.format;
            }

            public DateTime format(String format) {
                this.format = format;
                return this;
            }
        }

        public class Date
        extends Input {
            private String format;

            public Date() {
                this.format = "dd/MM/yyyy";
            }

            public String format() {
                return this.format;
            }

            public Date format(String format) {
                this.format = format;
                return this;
            }
        }

        public class Picture
        extends Resource {
        }

        public class File
        extends Resource {
        }

        public class Resource
        extends Input {
            private boolean showPreview;
            private Validation validation;

            public boolean showPreview() {
                return this.showPreview;
            }

            public Resource showPreview(boolean showPreview) {
                this.showPreview = showPreview;
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public Resource validation(Validation validation) {
                this.validation = validation;
                return this;
            }

            public DialogValidator.Result validateMaxSize(Map<String, byte[]> values) {
                for (Map.Entry<String, byte[]> value : values.entrySet()) {
                    DialogValidator.Result result;
                    if (value == null || (result = this.validateMaxSize(value.getKey(), value.getValue())) == null) continue;
                    return result;
                }
                return null;
            }

            public DialogValidator.Result validateMaxSize(String filename, byte[] content) {
                if (filename == null || content == null) {
                    return null;
                }
                if (this.validation == null) {
                    return null;
                }
                if (content.length <= this.validation.maxSize) {
                    return null;
                }
                return new DialogValidator.Result(false, "File is too long. Max size: " + this.validation.maxSize);
            }

            public DialogValidator.Result validateExtension(List<Object> values) {
                for (Object value : values) {
                    DialogValidator.Result result;
                    if (value == null || (result = this.validateExtension((String)value)) == null) continue;
                    return result;
                }
                return null;
            }

            public DialogValidator.Result validateExtension(String value) {
                if (value == null) {
                    return null;
                }
                if (this.validation == null) {
                    return null;
                }
                List<String> allowedExtensions = this.validation.allowedExtensions();
                if (allowedExtensions.size() <= 0 || allowedExtensions.contains(value)) {
                    return null;
                }
                return new DialogValidator.Result(false, "File extension not allowed. Options: " + String.join((CharSequence)", ", allowedExtensions));
            }

            public class Validation {
                private int maxSize;
                private List<String> allowedExtensions = new ArrayList<String>();

                public int maxSize() {
                    return this.maxSize;
                }

                public Validation maxSize(int maxSize) {
                    this.maxSize = maxSize;
                    return this;
                }

                public List<String> allowedExtensions() {
                    return this.allowedExtensions;
                }

                public void allowedExtensions(List<String> allowedExtensions) {
                    this.allowedExtensions.addAll(allowedExtensions);
                }
            }
        }

        public class ComboBox
        extends OptionBox {
        }

        public class CheckBox
        extends OptionBox {
            private CheckBoxMode mode;

            public CheckBox() {
                this.mode = CheckBoxMode.Boolean;
            }

            public CheckBoxMode mode() {
                return this.mode;
            }

            public CheckBox mode(CheckBoxMode mode) {
                this.mode = mode;
                return this;
            }
        }

        public class RadioBox
        extends OptionBox {
        }

        public class OptionBox
        extends Input {
            private DialogSource source;

            public OptionBox() {
                this.source = null;
            }

            public List<String> options() {
                if (this.source == null) {
                    return Collections.emptyList();
                }
                return this.source.options(this);
            }

            public OptionBox source(DialogSource source) {
                this.source = source;
                return this;
            }
        }

        public class Password
        extends Input {
            private Validation validation;

            public Validation validation() {
                return this.validation;
            }

            public Password validation(Validation validation) {
                this.validation = validation;
                return this;
            }

            public DialogValidator.Result validateLength(List<String> values) {
                for (String value : values) {
                    DialogValidator.Result result;
                    if (value == null || (result = this.validateLength(value)) == null) continue;
                    return result;
                }
                return null;
            }

            public DialogValidator.Result validateLength(String value) {
                if (value == null) {
                    return null;
                }
                if (this.validation == null) {
                    return null;
                }
                if (this.validation.length() == null) {
                    return null;
                }
                return this.validateLength(value, this.validation.length.min(), this.validation.length.max());
            }

            public class Validation {
                private List<PasswordRequired> requiredList = new ArrayList<PasswordRequired>();
                private Length length;

                public List<PasswordRequired> requiredList() {
                    return this.requiredList;
                }

                public Validation requiredList(List<PasswordRequired> requiredList) {
                    this.requiredList.addAll(requiredList);
                    return this;
                }

                public Length length() {
                    return this.length;
                }

                public Validation length(Length length) {
                    this.length = length;
                    return this;
                }

                public class Length {
                    private int min;
                    private int max;

                    public int min() {
                        return this.min;
                    }

                    public Length min(int min) {
                        this.min = min;
                        return this;
                    }

                    public int max() {
                        return this.max;
                    }

                    public Length max(int max) {
                        this.max = max;
                        return this;
                    }
                }
            }
        }

        public class Memo
        extends Input {
            private MemoMode mode;
            private int height;

            public Memo() {
                this.mode = MemoMode.Raw;
            }

            public MemoMode mode() {
                return this.mode;
            }

            public Memo mode(MemoMode mode) {
                this.mode = mode;
                return this;
            }

            public int height() {
                return this.height;
            }

            public Memo height(int height) {
                this.height = height;
                return this;
            }
        }

        public class Section
        extends Input {
            private List<Input> inputList;

            public Section() {
                this.inputList = new ArrayList<Input>();
            }

            public List<Input> inputList() {
                return this.inputList;
            }

            public Text createText() {
                return this.add(new Text());
            }

            public Section createSection() {
                return this.add(new Section());
            }

            public Memo createMemo() {
                return this.add(new Memo());
            }

            public Password createPassword() {
                return this.add(new Password());
            }

            public RadioBox createRadioBox() {
                return this.add(new RadioBox());
            }

            public CheckBox createCheckBox() {
                return this.add(new CheckBox());
            }

            public ComboBox createComboBox() {
                return this.add(new ComboBox());
            }

            public File createFile() {
                return this.add(new File());
            }

            public Picture createPicture() {
                return this.add(new Picture());
            }

            public Date createDate() {
                return this.add(new Date());
            }

            public DateTime createDateTime() {
                return this.add(new DateTime());
            }

            private <I extends Input> I add(I input) {
                this.inputList.add(input);
                return input;
            }

            @Override
            public Values values() {
                List<Form.Input> formInputs = Dialog.this.form.inputs(this.path());
                if (formInputs == null || formInputs.size() == 0) {
                    return new Values(){
                        {
                            if (Section.this.defaultValue() != null) {
                                this.add(new Value(Section.this.defaultValue()));
                            }
                        }
                    };
                }
                Values values = new Values();
                formInputs.forEach(formInput -> values.add(formInput.value()));
                return values;
            }
        }

        public class Text
        extends Input {
            private TextEdition edition;
            private Validation validation;

            public Text() {
                this.edition = TextEdition.Normal;
            }

            public TextEdition edition() {
                return this.edition;
            }

            public Text edition(TextEdition edition) {
                this.edition = edition;
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public Text validation(Validation validation) {
                this.validation = validation;
                return this;
            }

            public DialogValidator.Result validateEmail(List<String> values) {
                for (String value : values) {
                    DialogValidator.Result result;
                    if (value == null || (result = this.validateEmail(value)) == null) continue;
                    return result;
                }
                return null;
            }

            public DialogValidator.Result validateEmail(String value) {
                if (value == null) {
                    return null;
                }
                if (this.edition != TextEdition.Email) {
                    return null;
                }
                String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
                Pattern p = Pattern.compile(ePattern);
                Matcher m = p.matcher(value);
                return m.matches() ? null : new DialogValidator.Result(false, "Email not valid");
            }

            public DialogValidator.Result validateAllowedValues(List<String> values) {
                for (String value : values) {
                    DialogValidator.Result result;
                    if (value == null || (result = this.validateAllowedValues(value)) == null) continue;
                    return result;
                }
                return null;
            }

            public DialogValidator.Result validateAllowedValues(String value) {
                if (value == null) {
                    return null;
                }
                if (this.validation == null) {
                    return null;
                }
                if (this.validation.allowedValues.size() <= 0 || this.validation.allowedValues.contains(value)) {
                    return null;
                }
                return new DialogValidator.Result(false, "Value not allowed");
            }

            public DialogValidator.Result validateLength(List<String> values) {
                for (String value : values) {
                    DialogValidator.Result result;
                    if (value == null || (result = this.validateLength(value)) == null) continue;
                    return result;
                }
                return null;
            }

            public DialogValidator.Result validateLength(String value) {
                if (value == null) {
                    return null;
                }
                if (this.validation == null) {
                    return null;
                }
                if (this.validation.length() == null) {
                    return null;
                }
                return this.validateLength(value, this.validation.length.min(), this.validation.length.max());
            }

            public class Validation {
                private List<String> allowedValues = new ArrayList<String>();
                private List<String> disallowedValues = new ArrayList<String>();
                private boolean disallowEmptySpaces;
                private Length length;
                private String mask;

                public List<String> allowedValues() {
                    return this.allowedValues;
                }

                public Validation allowedValues(List<String> allowedValues) {
                    this.allowedValues.addAll(allowedValues);
                    return this;
                }

                public List<String> disallowedValues() {
                    return this.disallowedValues;
                }

                public Validation disallowedValues(List<String> disallowedValues) {
                    this.disallowedValues = disallowedValues;
                    return this;
                }

                public boolean disallowEmptySpaces() {
                    return this.disallowEmptySpaces;
                }

                public Validation disallowEmptySpaces(boolean disallowEmptySpaces) {
                    this.disallowEmptySpaces = disallowEmptySpaces;
                    return this;
                }

                public Length length() {
                    return this.length;
                }

                public Validation length(Length length) {
                    this.length = length;
                    return this;
                }

                public String mask() {
                    return this.mask;
                }

                public Validation mask(String mask) {
                    this.mask = mask;
                    return this;
                }

                public class Length {
                    private int min;
                    private int max;

                    public int min() {
                        return this.min;
                    }

                    public Length min(int min) {
                        this.min = min;
                        return this;
                    }

                    public int max() {
                        return this.max;
                    }

                    public Length max(int max) {
                        this.max = max;
                        return this;
                    }
                }
            }
        }

        public class Input {
            private String path;
            private String name;
            private String label;
            private boolean required;
            private boolean readonly;
            private boolean visible = true;
            private String placeholder = null;
            private String helper;
            private String defaultValue = null;
            private Multiple multiple = null;
            private DialogValidator validator = null;
            private static final String AlphaAndDigits = "[^a-zA-Z0-9]+";

            public String name() {
                return this.name;
            }

            public String path() {
                return this.path != null ? this.path : this.name();
            }

            public Input path(String path) {
                this.path = path;
                return this;
            }

            public String label() {
                return this.label;
            }

            public Input label(String label) {
                this.name = this.clean(label);
                this.label = label;
                return this;
            }

            public boolean required() {
                return this.required;
            }

            public Input required(boolean required) {
                this.required = required;
                return this;
            }

            public boolean readonly() {
                return this.readonly;
            }

            public Input readonly(boolean readonly) {
                this.readonly = readonly;
                return this;
            }

            public boolean visible() {
                return this.visible;
            }

            public Input visible(boolean visible) {
                this.visible = visible;
                return this;
            }

            public String placeholder() {
                return this.placeholder;
            }

            public Input placeholder(String placeholder) {
                this.placeholder = placeholder;
                return this;
            }

            public String helper() {
                return this.helper;
            }

            public Input helper(String helper) {
                this.helper = helper;
                return this;
            }

            public <T> T defaultValue() {
                return (T)this.defaultValue;
            }

            public Input defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public boolean isMultiple() {
                return this.multiple != null;
            }

            public Multiple multiple() {
                return this.multiple;
            }

            public Input multiple(int min, int max) {
                this.multiple = new Multiple().min(min).max(max);
                return this;
            }

            public Input validator(DialogValidator validator) {
                this.validator = validator;
                return this;
            }

            public DialogValidator.Result validate() {
                if (this.validator == null) {
                    return null;
                }
                return this.validator.validate(this);
            }

            public Value value() {
                return this.values().size() > 0 ? (Value)this.values().get(0) : new Value(null);
            }

            public Values values() {
                Form.Input formInput = Dialog.this.form.input(this.path());
                return formInput != null ? formInput.values() : new Values(){
                    {
                        if (Input.this.defaultValue() != null) {
                            this.add(new Value(Input.this.defaultValue()));
                        }
                    }
                };
            }

            public Input value(Object value) {
                return this.values(Collections.singletonList(value));
            }

            public Input values(List<Object> values) {
                Dialog.this.form.input(this.path()).clear();
                for (int i = 0; i < values.size(); ++i) {
                    Dialog.this.form.register(this.path() + Dialog.PathSeparator + i, values.get(i));
                }
                return this;
            }

            public <I extends Input> I input(String path) {
                return Dialog.this.input(path);
            }

            protected DialogValidator.Result validateLength(String value, int min, int max) {
                if (value == null) {
                    return null;
                }
                int length = value.length();
                if (min > 0 && length < min) {
                    return new DialogValidator.Result(false, "Value length is lower than " + min);
                }
                if (max > 0 && length > max) {
                    return new DialogValidator.Result(false, "Value length is greater than " + max);
                }
                return null;
            }

            private String clean(String value) {
                return value.replaceAll(AlphaAndDigits, "");
            }

            public class Multiple {
                private int min = -1;
                private int max = -1;

                public int min() {
                    return this.min;
                }

                public Multiple min(int min) {
                    this.min = min;
                    return this;
                }

                public int max() {
                    return this.max;
                }

                public Multiple max(int max) {
                    this.max = max;
                    return this;
                }
            }
        }
    }

    public class Toolbar {
        private List<Operation> operationList = new ArrayList<Operation>();

        public List<Operation> operationList() {
            return this.operationList;
        }

        public Operation createOperation() {
            return this.add(new Operation());
        }

        public Operation operation(String key) {
            return this.operationList.stream().filter(o -> o.name().equals(key) || o.label().equals(key)).findFirst().orElse(null);
        }

        private Operation add(Operation input) {
            this.operationList.add(input);
            return input;
        }

        public class Operation {
            private String name;
            private String label;
            private DialogExecution launcher = null;

            public String name() {
                return this.name;
            }

            public Operation name(String name) {
                this.name = name;
                return this;
            }

            public String label() {
                return this.label;
            }

            public Operation label(String label) {
                this.label = label;
                return this;
            }

            public Operation execute(DialogExecution launcher) {
                this.launcher = launcher;
                return this;
            }

            public DialogExecution.Modification execute(ActivitySession session) {
                if (this.launcher == null) {
                    return DialogExecution.Modification.ItemModified;
                }
                return this.launcher.execute(this, session);
            }
        }
    }

    public static enum CheckBoxMode {
        Boolean,
        List;

    }

    public static enum PasswordRequired {
        Letter,
        Number,
        Symbol;

    }

    public static enum MemoMode {
        Raw,
        Rich;

    }

    public static enum TextEdition {
        Normal,
        Uppercase,
        Lowercase,
        Email,
        Url;

    }

    public static enum TabsMode {
        Tabs,
        Wizard;

    }
}

