/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.model;

import io.intino.konos.alexandria.activity.model.Element;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.ItemList;
import io.intino.konos.alexandria.activity.model.catalog.Events;
import io.intino.konos.alexandria.activity.model.catalog.Scope;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Arrangement;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Group;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Catalog
extends Element {
    private ObjectsLoader objectsLoader;
    private RootObjectLoader rootObjectLoader;
    private DefaultObjectLoader defaultObjectLoader;
    private ScopeChangeEvent scopeChangeEvent;
    private ArrangementHistogramsMode arrangementHistogramsMode;
    private List<Arrangement> arrangementList = new ArrayList<Arrangement>();
    private ArrangementFiltererLoader arrangementFiltererLoader;
    private Mode mode;
    private ClusterManager clusterManager;
    private Events events;

    public Catalog() {
        this.arrangementHistogramsMode = ArrangementHistogramsMode.EnabledAndVisible;
        this.mode = Mode.Normal;
    }

    public Item rootItem(List<Item> itemList, ActivitySession session) {
        return this.rootObjectLoader != null ? this.item(this.rootObjectLoader.load(this.objects(itemList), session)) : null;
    }

    public Catalog rootObjectLoader(RootObjectLoader loader) {
        this.rootObjectLoader = loader;
        return this;
    }

    public Item defaultItem(String id, ActivitySession session) {
        return this.defaultObjectLoader != null ? this.item(this.defaultObjectLoader.load(id, session)) : null;
    }

    public Catalog defaultObjectLoader(DefaultObjectLoader loader) {
        this.defaultObjectLoader = loader;
        return this;
    }

    public ItemList items(Scope scope, String condition, ActivitySession session) {
        if (this.objectsLoader == null) {
            return new ItemList();
        }
        return new ItemList(this.objectsLoader.load(scope, condition, session).stream().map(this::item).collect(Collectors.toList()));
    }

    public Catalog objectsLoader(ObjectsLoader loader) {
        this.objectsLoader = loader;
        return this;
    }

    public List<Grouping> groupings() {
        return this.arrangementList.stream().filter(a -> a instanceof Grouping).map(a -> (Grouping)a).collect(Collectors.toList());
    }

    public List<Sorting> sortings() {
        return this.arrangementList.stream().filter(a -> a instanceof Sorting).map(a -> (Sorting)a).collect(Collectors.toList());
    }

    public Catalog add(Arrangement arrangement) {
        this.arrangementList.add(arrangement);
        return this;
    }

    public ArrangementFilterer arrangementFilterer(ActivitySession session) {
        return this.arrangementFiltererLoader != null ? this.arrangementFiltererLoader.load(session) : null;
    }

    public Catalog arrangementFiltererLoader(ArrangementFiltererLoader loader) {
        this.arrangementFiltererLoader = loader;
        return this;
    }

    public Mode mode() {
        return this.mode;
    }

    public Catalog mode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public Events events() {
        return this.events;
    }

    public Catalog events(Events events) {
        this.events = events;
        return this;
    }

    public ArrangementHistogramsMode arrangementHistogramsMode() {
        return this.arrangementHistogramsMode;
    }

    public Catalog arrangementHistogramsMode(String mode) {
        return this.arrangementHistogramsMode(ArrangementHistogramsMode.valueOf(mode));
    }

    public Catalog arrangementHistogramsMode(ArrangementHistogramsMode mode) {
        this.arrangementHistogramsMode = mode;
        return this;
    }

    public void addGroupingGroup(String grouping, String label, List<Item> itemList, ActivitySession session) {
    }

    public Catalog clusterManager(ClusterManager manager) {
        this.clusterManager = manager;
        return this;
    }

    public static interface ClusterManager {
        public void createClusterGroup(Catalog var1, String var2, Group var3, ActivitySession var4);
    }

    public static interface ArrangementFilterer {
        public ActivitySession session();

        public void add(String var1, Group ... var2);

        public boolean contains(Item var1);

        public void clear();

        public boolean isEmpty();
    }

    public static interface ArrangementFiltererLoader {
        public ArrangementFilterer load(ActivitySession var1);
    }

    public static interface ScopeChangeEvent {
        public void onChange(Scope var1, ActivitySession var2);
    }

    public static interface DefaultObjectLoader {
        public Object load(String var1, ActivitySession var2);
    }

    public static interface RootObjectLoader {
        public Object load(List<Object> var1, ActivitySession var2);
    }

    public static interface ObjectsLoader {
        public List<Object> load(Scope var1, String var2, ActivitySession var3);
    }

    public static enum ArrangementHistogramsMode {
        EnabledAndVisible,
        EnabledButHidden,
        Disabled;

    }

    public static enum Mode {
        Normal,
        Preview;

    }
}

