/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.helpers;

import io.intino.konos.alexandria.activity.helpers.Bounds;
import io.intino.konos.alexandria.activity.helpers.ZoomRange;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class TimeScaleHandler {
    private final Bounds bounds;
    private final List<TimeScale> availableScales = new ArrayList<TimeScale>();
    private final List<TimeScale> scales;
    private final List<Consumer<TimeRange>> onRangeChangedListeners = new ArrayList<Consumer<TimeRange>>();
    private final List<Consumer<TimeRange>> onScaleChangedListeners = new ArrayList<Consumer<TimeRange>>();
    private final List<Consumer<TimeRange>> onNotValidRangeListeners = new ArrayList<Consumer<TimeRange>>();
    private TimeScale currentScale;
    private TimeRange timeRange;
    private Instant lastLoadedFrom;
    private Instant lastLoadedTo;

    public TimeScaleHandler(Bounds bounds, List<TimeScale> scales, TimeScale initialScale) {
        this.bounds = bounds;
        this.scales = scales;
        this.currentScale = initialScale;
        this.timeRange = this.initialTimeRange(this.currentScale);
    }

    public TimeRange boundsRange() {
        return this.bounds.range();
    }

    public List<TimeScale> availableScales() {
        return this.availableScales;
    }

    public void availableScales(List<TimeScale> scales) {
        this.availableScales.clear();
        this.availableScales.addAll(scales);
    }

    public TimeRange leftRange() {
        Instant from = this.checkWithFrom(this.currentScale.addTo(this.timeRange.from(), -(this.currentScale.instantsBetween(this.timeRange.from(), this.timeRange.to()) - 1L)));
        return this.timeRangeOf(from, this.currentScale.addTo(this.timeRange.from(), -1L), this.currentScale);
    }

    public TimeRange rightRange() {
        Instant to = this.checkWithTo(this.currentScale.addTo(this.timeRange.to(), this.currentScale.instantsBetween(this.timeRange.from(), this.timeRange.to()) - 1L));
        return this.timeRangeOf(this.currentScale.addTo(this.timeRange.to(), 1L), to, this.currentScale);
    }

    void refresh() {
        this.timeRange = this.initialTimeRange(this.currentScale);
        this.resetLoadedPoints();
    }

    private TimeRange timeRangeOf(Instant from, Instant to, TimeScale scale) {
        return this.checkMinRange(new TimeRange(scale.normalise(from), scale.normalise(to), scale));
    }

    private TimeRange leftRange(long size) {
        Instant to = this.checkWithTo(this.lastLoadedFrom());
        this.lastLoadedFrom = this.checkWithFrom(this.currentScale.addTo(to, -size));
        return this.timeRangeOf(this.lastLoadedFrom, to, this.currentScale);
    }

    private TimeRange rightRange(long size) {
        Instant from = this.checkWithFrom(this.lastLoadedTo());
        this.lastLoadedTo = this.checkWithTo(this.currentScale.addTo(from, size));
        return this.timeRangeOf(from, this.lastLoadedTo, this.currentScale);
    }

    public TimeRange range() {
        return this.timeRange;
    }

    public List<TimeScale> scales() {
        return this.scales;
    }

    public void onRangeChange(Consumer<TimeRange> listener) {
        this.onRangeChangedListeners.add(listener);
    }

    public void onScaleChange(Consumer<TimeRange> listener) {
        this.onScaleChangedListeners.add(listener);
    }

    public void updateRange(Instant from, Instant to) {
        this.updateRange(from, to, true);
    }

    public void onNotValidRange(Consumer<TimeRange> consumer) {
        this.onNotValidRangeListeners.add(consumer);
    }

    public ZoomRange zoomRange() {
        Map<TimeScale, Bounds.Zoom> zooms = this.bounds.zooms();
        if (zooms.size() <= 0) {
            return new ZoomRange(0L, 0L);
        }
        long max = this.scales.get(0).toMillis(zooms.get((Object)this.scales.get(0)).max());
        long min = this.scales.get(this.scales.size() - 1).toMillis(zooms.get((Object)this.scales.get(this.scales.size() - 1)).min());
        return new ZoomRange(max, min);
    }

    public TimeRange updateRangeFrom(Instant from) {
        if (from.isBefore(this.boundsRange().from())) {
            from = this.boundsRange().from();
        }
        long count = this.range().allInstants().count();
        TimeScale scale = this.range().scale();
        TimeRange range = this.validOlapRangeFor(from, scale.addTo(from, count));
        this.updateRange(range.from(), range.to(), false);
        return range;
    }

    public TimeRange updateRangeTo(Instant to) {
        if (to.isAfter(this.boundsRange().to())) {
            to = this.boundsRange().to();
        }
        long count = this.range().allInstants().count();
        TimeScale scale = this.range().scale();
        TimeRange range = this.validOlapRangeFor(scale.addTo(to, -count), to);
        this.updateRange(range.from(), range.to(), false);
        return range;
    }

    public void updateRange(Instant from, Instant to, boolean updateScaleIfNeeded) {
        if (this.isOutOfTimeline(from = this.currentScale.normalise(from), to = this.currentScale.normalise(to))) {
            this.tryToUpdateToValidRange(updateScaleIfNeeded);
            return;
        }
        long numberOfInstants = this.currentScale.instantsBetween(from, to);
        if (updateScaleIfNeeded && this.isBelowLowerBoundary(numberOfInstants)) {
            this.tryToChangeToLowerScale(from, to);
        } else if (updateScaleIfNeeded && this.isAboveUpperBoundary(numberOfInstants)) {
            this.tryToChangeToBiggerScale(from, to);
        } else {
            this.notifyRangeChange(this.timeRangeOf(from, to, this.currentScale));
        }
    }

    public void updateInstant(Instant instant, TimeScale scale) {
        TimeRange range = new TimeRange(instant, instant, scale);
        if (this.isOutOfTimeline(range.from(), range.to())) {
            this.notifyNotValidRange(range);
        }
        if (range.scale() != this.currentScale) {
            this.notifyScaleChange(range);
        } else {
            this.notifyRangeChange(range);
        }
    }

    public TimeRange moveLeft() {
        return this.moveLeft(5);
    }

    public TimeRange moveLeft(int countSteps) {
        Instant from = this.currentScale.addTo(this.timeRange.from(), -countSteps);
        Instant to = this.currentScale.addTo(this.timeRange.to(), -countSteps);
        return this.move(from, to);
    }

    public TimeRange moveLeft(long time) {
        Instant from = this.timeRange.from().minusMillis(time);
        Instant to = this.timeRange.to().minusMillis(time);
        return this.move(from, to);
    }

    public TimeRange moveRight() {
        return this.moveRight(5);
    }

    public TimeRange moveRight(int countSteps) {
        Instant from = this.currentScale.addTo(this.timeRange.from(), countSteps);
        Instant to = this.currentScale.addTo(this.timeRange.to(), countSteps);
        return this.move(from, to);
    }

    public TimeRange moveRight(long time) {
        Instant from = this.timeRange.from().plusMillis(time);
        Instant to = this.timeRange.to().plusMillis(time);
        return this.move(from, to);
    }

    public TimeRange move(Instant newFrom, Instant newTo) {
        newFrom = this.currentScale.normalise(newFrom);
        newTo = this.currentScale.normalise(newTo);
        if (this.timeRange.allInstants().count() != this.currentScale.instantsBetween(newFrom, newTo)) {
            if (this.movedLeft(newFrom)) {
                return this.move(this.currentScale.addTo(newTo, -this.timeRange.allInstants().count() + 1L), newTo);
            }
            return this.move(newFrom, this.currentScale.addTo(newFrom, this.timeRange.allInstants().count() - 1L));
        }
        long movement = this.movementSize(newFrom);
        if (this.movedLeft(newFrom)) {
            this.notifyRangeChange(this.timeRangeOf(newFrom, newTo, this.currentScale));
            return this.leftRange(movement);
        }
        this.notifyRangeChange(this.timeRangeOf(newFrom, newTo, this.currentScale));
        return this.rightRange(movement);
    }

    public void updateScale(TimeScale scale) {
        if (this.currentScale == scale) {
            return;
        }
        this.resetLoadedPoints();
        this.currentScale = scale;
        this.notifyScaleChange(this.calculateNewRange(this.timeRange.from(), this.timeRange.to(), this.currentScale));
    }

    public void reloadScale() {
        this.resetLoadedPoints();
        this.notifyScaleChange(this.calculateNewRange(this.timeRange.from(), this.timeRange.to(), this.currentScale));
    }

    public void resetLoadedPoints() {
        this.lastLoadedFrom = null;
        this.lastLoadedTo = null;
    }

    private void tryToUpdateToValidRange(boolean updateScaleIfNeeded) {
        if (this.currentScale != this.scales.get(0)) {
            if (updateScaleIfNeeded) {
                this.biggerScale();
            }
            this.notifyScaleChange(this.initialTimeRange(this.currentScale));
        } else {
            this.notifyNotValidRange(this.timeRange);
        }
    }

    private long movementSize(Instant newFrom) {
        if (this.movedLeft(newFrom)) {
            return this.currentScale.instantsBetween(newFrom, this.timeRange.from());
        }
        return this.currentScale.instantsBetween(this.timeRange.from(), newFrom);
    }

    private boolean movedLeft(Instant newFrom) {
        return !newFrom.equals(this.timeRange.from()) && newFrom.isBefore(this.timeRange.from());
    }

    private Instant lastLoadedFrom() {
        if (this.lastLoadedFrom == null) {
            this.lastLoadedFrom = this.timeRange.from();
        }
        return this.lastLoadedFrom;
    }

    private Instant lastLoadedTo() {
        if (this.lastLoadedTo == null) {
            this.lastLoadedTo = this.timeRange.to();
        }
        return this.lastLoadedTo;
    }

    private void tryToChangeToLowerScale(Instant from, Instant to) {
        if (this.currentScale != this.scales.get(this.scales.size() - 1)) {
            this.resetLoadedPoints();
            this.notifyScaleChange(this.calculateNewRange(from, to, this.lowerScale()));
        } else {
            this.notifyNotValidRange(this.timeRange);
        }
    }

    private void tryToChangeToBiggerScale(Instant from, Instant to) {
        if (this.currentScale != this.scales.get(0)) {
            this.resetLoadedPoints();
            this.notifyScaleChange(this.calculateNewRange(from, to, this.biggerScale()));
        } else {
            this.notifyNotValidRange(this.timeRange);
        }
    }

    private void notifyRangeChange(TimeRange timeRange) {
        this.timeRange = timeRange;
        this.onRangeChangedListeners.parallelStream().forEach(c -> c.accept(timeRange));
    }

    private void notifyNotValidRange(TimeRange timeRange) {
        this.timeRange = timeRange;
        this.onNotValidRangeListeners.parallelStream().forEach(c -> c.accept(timeRange));
    }

    private void notifyScaleChange(TimeRange timeRange) {
        this.timeRange = timeRange;
        this.currentScale = timeRange.scale();
        this.onScaleChangedListeners.parallelStream().forEach(c -> c.accept(timeRange));
        this.resetLoadedPoints();
    }

    private boolean isOutOfTimeline(Instant from, Instant to) {
        return this.boundsRange().from().isAfter(from) || this.boundsRange().to().isBefore(to);
    }

    private boolean isAboveUpperBoundary(long numberOfInstants) {
        return numberOfInstants > (long)this.bounds.zooms().get((Object)this.currentScale).max();
    }

    private boolean isBelowLowerBoundary(long numberOfInstants) {
        return numberOfInstants < (long)this.bounds.zooms().get((Object)this.currentScale).min();
    }

    private TimeScale lowerScale() {
        this.currentScale = this.scales.get(this.scales.indexOf((Object)this.currentScale) + 1);
        return this.currentScale;
    }

    private TimeScale biggerScale() {
        this.currentScale = this.scales.get(this.scales.indexOf((Object)this.currentScale) - 1);
        return this.currentScale;
    }

    private TimeRange initialTimeRange(TimeScale scale) {
        long halfRangeSize = 1L;
        if (this.bounds.zooms().size() > 0) {
            halfRangeSize = (long)this.bounds.zooms().get((Object)scale).max() / 2L;
            if (this.bounds.mode() == Bounds.Mode.ToTheLast) {
                Instant to = scale.normalise(this.bounds.range().to());
                Instant from = scale.addTo(to, -halfRangeSize);
                return this.timeRangeOf(this.checkWithFrom(from), to, scale);
            }
        }
        Instant from = scale.normalise(this.bounds.range().from());
        Instant to = scale.addTo(from, halfRangeSize);
        return this.timeRangeOf(from, this.checkWithTo(to), scale);
    }

    private TimeRange checkMinRange(TimeRange timeRange) {
        TimeScale scale = timeRange.scale();
        if (scale.normalise(timeRange.from()).compareTo(timeRange.to()) != 0) {
            return timeRange;
        }
        TimeScale referenceScale = scale.ordinal() > TimeScale.Day.ordinal() ? scale : TimeScale.Day;
        return new TimeRange(timeRange.from(), referenceScale.addTo(timeRange.to(), 1L), scale);
    }

    private TimeRange calculateNewRange(Instant from, Instant to, TimeScale scale) {
        from = scale.normalise(from);
        to = scale.normalise(to);
        Instant center = scale.addTo(from, scale.instantsBetween(from, to) / 2L);
        long halfRangeSize = (long)this.bounds.zooms().get((Object)scale).max() / 2L;
        Instant start = this.checkWithFrom(this.addToCenter(center, -halfRangeSize));
        if ((long)this.bounds.zooms().get((Object)scale).max() == halfRangeSize * 2L) {
            return this.timeRangeOf(start, this.checkWithTo(this.addToCenter(center, halfRangeSize)), scale);
        }
        return this.timeRangeOf(start, this.checkWithTo(this.addToCenter(center, halfRangeSize)), scale);
    }

    private Instant addToCenter(Instant center, long halfRangeSize) {
        return this.currentScale.addTo(center, halfRangeSize);
    }

    private Instant checkWithFrom(Instant from) {
        Instant timelineFromWithAir = this.currentScale.addTo(this.bounds.range().from(), 0L);
        Instant fromWithAir = this.currentScale.addTo(from, 0L);
        return from.isBefore(this.bounds.range().from()) ? timelineFromWithAir : fromWithAir;
    }

    private Instant checkWithTo(Instant to) {
        Instant timelineToWithAir = this.currentScale.addTo(this.bounds.range().to(), 0L);
        Instant toWithAir = this.currentScale.addTo(to, 0L);
        return to.isAfter(this.bounds.range().to()) ? timelineToWithAir : toWithAir;
    }

    private TimeRange validOlapRangeFor(Instant from, Instant to) {
        TimeRange range = this.boundsRange();
        if (range.from().isAfter(from)) {
            from = range.from();
        }
        if (range.to().isBefore(to)) {
            to = range.to();
        }
        return this.timeRangeOf(from, to, this.currentScale);
    }

    public static class Bounds {
        private TimeRangeLoader loader;
        private Bounds.Mode mode;
        private Map<TimeScale, Bounds.Zoom> zooms;

        public TimeRange range() {
            return this.loader.load();
        }

        public Bounds rangeLoader(TimeRangeLoader loader) {
            this.loader = loader;
            return this;
        }

        public Bounds.Mode mode() {
            return this.mode;
        }

        public Bounds mode(Bounds.Mode mode) {
            this.mode = mode;
            return this;
        }

        public Map<TimeScale, Bounds.Zoom> zooms() {
            return this.zooms;
        }

        public Bounds zooms(Map<TimeScale, Bounds.Zoom> zooms) {
            this.zooms = zooms;
            return this;
        }

        public static interface Zoom {
            public int min();

            public int max();
        }

        public static interface TimeRangeLoader {
            public TimeRange load();
        }
    }
}

