/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.requesters;

import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.displays.AlexandriaItem;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.activity.schemas.DownloadItemParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.ExecuteItemTaskParameters;
import io.intino.konos.alexandria.activity.schemas.ExportItemParameters;
import io.intino.konos.alexandria.activity.schemas.OpenElementParameters;
import io.intino.konos.alexandria.activity.schemas.OpenItemDialogParameters;
import io.intino.konos.alexandria.activity.schemas.Reference;
import io.intino.konos.alexandria.activity.schemas.SaveItemParameters;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;
import io.intino.konos.alexandria.exceptions.AlexandriaException;

public class AlexandriaItemRequester
extends AlexandriaDisplayRequester {
    public AlexandriaItemRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        AlexandriaItem display = (AlexandriaItem)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("itemStampsReady")) {
            display.itemStampsReady((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("openItem")) {
            display.openItem((Reference)this.manager.fromQuery("value", Reference.class));
        } else if (operation.equals("openElement")) {
            display.openElement((OpenElementParameters)this.manager.fromQuery("value", OpenElementParameters.class));
        } else if (operation.equals("executeOperation")) {
            display.executeOperation((ElementOperationParameters)this.manager.fromQuery("value", ElementOperationParameters.class));
        } else {
            if (operation.equals("downloadOperation")) {
                ActivityFile file = display.downloadOperation((ElementOperationParameters)this.manager.fromQuery("value", ElementOperationParameters.class));
                this.manager.write(file.content(), file.label(), file.embedded());
                return;
            }
            if (operation.equals("openItemDialogOperation")) {
                display.openItemDialogOperation((OpenItemDialogParameters)this.manager.fromQuery("value", OpenItemDialogParameters.class));
            } else if (operation.equals("executeItemTaskOperation")) {
                display.executeItemTaskOperation((ExecuteItemTaskParameters)this.manager.fromQuery("value", ExecuteItemTaskParameters.class));
            } else {
                if (operation.equals("downloadItemOperation")) {
                    ActivityFile file = display.downloadItemOperation((DownloadItemParameters)this.manager.fromQuery("value", DownloadItemParameters.class));
                    this.manager.write(file.content(), file.label(), file.embedded());
                    return;
                }
                if (operation.equals("exportItemOperation")) {
                    ActivityFile file = display.exportItemOperation((ExportItemParameters)this.manager.fromQuery("value", ExportItemParameters.class));
                    this.manager.write(file.content(), file.label(), file.embedded());
                    return;
                }
                if (operation.equals("saveItem")) {
                    display.saveItem((SaveItemParameters)this.manager.fromQuery("value", SaveItemParameters.class));
                }
            }
        }
        super.execute();
    }
}

