/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.requesters;

import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogMapView;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.activity.schemas.Bounds;
import io.intino.konos.alexandria.activity.schemas.DownloadItemParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.ExecuteItemTaskParameters;
import io.intino.konos.alexandria.activity.schemas.OpenElementParameters;
import io.intino.konos.alexandria.activity.schemas.OpenItemDialogParameters;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;
import io.intino.konos.alexandria.exceptions.AlexandriaException;

public class AlexandriaCatalogMapViewRequester
extends AlexandriaDisplayRequester {
    public AlexandriaCatalogMapViewRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        AlexandriaCatalogMapView display = (AlexandriaCatalogMapView)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("location")) {
            display.location((Bounds)this.manager.fromQuery("value", Bounds.class));
        } else if (operation.equals("page")) {
            display.page((Integer)this.manager.fromQuery("value", Integer.class));
        } else if (operation.equals("openElement")) {
            display.openElement((OpenElementParameters)this.manager.fromQuery("value", OpenElementParameters.class));
        } else if (operation.equals("loadItem")) {
            display.loadItem((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("openItem")) {
            display.openItem((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("executeOperation")) {
            display.executeOperation((ElementOperationParameters)this.manager.fromQuery("value", ElementOperationParameters.class));
        } else {
            if (operation.equals("downloadOperation")) {
                ActivityFile file = display.downloadOperation((ElementOperationParameters)this.manager.fromQuery("value", ElementOperationParameters.class));
                this.manager.write(file.content(), file.label(), file.embedded());
                return;
            }
            if (operation.equals("openItemDialogOperation")) {
                display.openItemDialogOperation((OpenItemDialogParameters)this.manager.fromQuery("value", OpenItemDialogParameters.class));
            } else if (operation.equals("executeItemTaskOperation")) {
                display.executeItemTaskOperation((ExecuteItemTaskParameters)this.manager.fromQuery("value", ExecuteItemTaskParameters.class));
            } else if (operation.equals("downloadItemOperation")) {
                ActivityFile file = display.downloadItemOperation((DownloadItemParameters)this.manager.fromQuery("value", DownloadItemParameters.class));
                this.manager.write(file.content(), file.label(), file.embedded());
                return;
            }
        }
        super.execute();
    }
}

