/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.requesters;

import io.intino.konos.alexandria.activity.displays.AlexandriaCatalogListView;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifierProvider;
import io.intino.konos.alexandria.activity.displays.requesters.AlexandriaDisplayRequester;
import io.intino.konos.alexandria.activity.schemas.ClusterGroup;
import io.intino.konos.alexandria.activity.schemas.DownloadItemParameters;
import io.intino.konos.alexandria.activity.schemas.ElementOperationParameters;
import io.intino.konos.alexandria.activity.schemas.ExecuteItemTaskParameters;
import io.intino.konos.alexandria.activity.schemas.OpenElementParameters;
import io.intino.konos.alexandria.activity.schemas.OpenItemDialogParameters;
import io.intino.konos.alexandria.activity.schemas.SaveItemParameters;
import io.intino.konos.alexandria.activity.schemas.Sorting;
import io.intino.konos.alexandria.activity.spark.ActivityFile;
import io.intino.konos.alexandria.activity.spark.ActivitySparkManager;
import io.intino.konos.alexandria.exceptions.AlexandriaException;

public class AlexandriaCatalogListViewRequester
extends AlexandriaDisplayRequester {
    public AlexandriaCatalogListViewRequester(ActivitySparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        AlexandriaCatalogListView display = (AlexandriaCatalogListView)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("openItem")) {
            display.openItem((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("openElement")) {
            display.openElement((OpenElementParameters)this.manager.fromQuery("value", OpenElementParameters.class));
        } else if (operation.equals("selectItems")) {
            display.selectItems((String[])this.manager.fromQuery("value", String[].class));
        } else if (operation.equals("renderExpandedPictures")) {
            display.renderExpandedPictures();
        } else if (operation.equals("itemRefreshed")) {
            display.itemRefreshed((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("selectSorting")) {
            display.selectSorting((Sorting)this.manager.fromQuery("value", Sorting.class));
        } else if (operation.equals("page")) {
            display.page((Integer)this.manager.fromQuery("value", Integer.class));
        } else if (operation.equals("filter")) {
            display.filter((String)this.manager.fromQuery("value", String.class));
        } else if (operation.equals("createClusterGroup")) {
            display.createClusterGroup((ClusterGroup)this.manager.fromQuery("value", ClusterGroup.class));
        } else if (operation.equals("executeOperation")) {
            display.executeOperation((ElementOperationParameters)this.manager.fromQuery("value", ElementOperationParameters.class));
        } else {
            if (operation.equals("downloadOperation")) {
                ActivityFile file = display.downloadOperation((ElementOperationParameters)this.manager.fromQuery("value", ElementOperationParameters.class));
                this.manager.write(file.content(), file.label(), file.embedded());
                return;
            }
            if (operation.equals("openItemDialogOperation")) {
                display.openItemDialogOperation((OpenItemDialogParameters)this.manager.fromQuery("value", OpenItemDialogParameters.class));
            } else if (operation.equals("executeItemTaskOperation")) {
                display.executeItemTaskOperation((ExecuteItemTaskParameters)this.manager.fromQuery("value", ExecuteItemTaskParameters.class));
            } else {
                if (operation.equals("downloadItemOperation")) {
                    ActivityFile file = display.downloadItemOperation((DownloadItemParameters)this.manager.fromQuery("value", DownloadItemParameters.class));
                    this.manager.write(file.content(), file.label(), file.embedded());
                    return;
                }
                if (operation.equals("saveItem")) {
                    display.saveItem((SaveItemParameters)this.manager.fromQuery("value", SaveItemParameters.class));
                }
            }
        }
        super.execute();
    }
}

