/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.builders;

import io.intino.konos.alexandria.activity.model.mold.Block;
import io.intino.konos.alexandria.activity.model.mold.stamps.Breadcrumbs;
import io.intino.konos.alexandria.activity.model.mold.stamps.CardWallet;
import io.intino.konos.alexandria.activity.model.mold.stamps.CatalogLink;
import io.intino.konos.alexandria.activity.model.mold.stamps.Description;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedCatalog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDialog;
import io.intino.konos.alexandria.activity.model.mold.stamps.EmbeddedDisplay;
import io.intino.konos.alexandria.activity.model.mold.stamps.Highlight;
import io.intino.konos.alexandria.activity.model.mold.stamps.Icon;
import io.intino.konos.alexandria.activity.model.mold.stamps.ItemLinks;
import io.intino.konos.alexandria.activity.model.mold.stamps.Location;
import io.intino.konos.alexandria.activity.model.mold.stamps.Map;
import io.intino.konos.alexandria.activity.model.mold.stamps.Operation;
import io.intino.konos.alexandria.activity.model.mold.stamps.Page;
import io.intino.konos.alexandria.activity.model.mold.stamps.Picture;
import io.intino.konos.alexandria.activity.model.mold.stamps.Rating;
import io.intino.konos.alexandria.activity.model.mold.stamps.Snippet;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogRange;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogRangeNavigator;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogTime;
import io.intino.konos.alexandria.activity.model.mold.stamps.TemporalCatalogTimeNavigator;
import io.intino.konos.alexandria.activity.model.mold.stamps.Title;
import io.intino.konos.alexandria.activity.model.mold.stamps.icons.AlexandriaIcon;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.DownloadOperation;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.ExportOperation;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.OpenDialogOperation;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.PreviewOperation;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.TaskOperation;
import io.intino.konos.alexandria.activity.schemas.Mold;
import io.intino.konos.alexandria.activity.schemas.MoldBlock;
import io.intino.konos.alexandria.activity.schemas.Property;
import io.intino.konos.alexandria.activity.schemas.Stamp;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MoldBuilder {
    public static Mold build(io.intino.konos.alexandria.activity.model.Mold mold) {
        return new Mold().moldBlockList(mold.blocks().stream().map(MoldBuilder::buildBlock).collect(Collectors.toList()));
    }

    private static MoldBlock buildBlock(Block block) {
        return new MoldBlock().name(block.name()).style(block.style()).expanded(block.expanded()).hiddenIfMobile(block.hiddenIfMobile()).layout(block.layouts().stream().map(Enum::toString).collect(Collectors.joining(" "))).width(block.width()).height(block.height()).moldBlockList(block.blockList().stream().map(MoldBuilder::buildBlock).collect(Collectors.toList())).stampList(block.stampList().stream().map(MoldBuilder::buildStamp).collect(Collectors.toList()));
    }

    private static Stamp buildStamp(io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        Stamp result = new Stamp().name(stamp.name()).label(stamp.label()).editable(stamp.editable()).shape(MoldBuilder.shapeOf(stamp)).layout(stamp.layout().toString()).height(stamp.height());
        ArrayList<Property> propertyList = new ArrayList<Property>();
        MoldBuilder.addCommonProperties(propertyList, stamp);
        MoldBuilder.addRatingProperties(propertyList, stamp);
        MoldBuilder.addEmbeddedDisplayProperties(propertyList, stamp);
        MoldBuilder.addEmbeddedDialogProperties(propertyList, stamp);
        MoldBuilder.addEmbeddedCatalogProperties(propertyList, stamp);
        MoldBuilder.addIconProperties(propertyList, stamp);
        MoldBuilder.addDownloadOperationProperties(propertyList, stamp);
        MoldBuilder.addOperationProperties(propertyList, stamp);
        MoldBuilder.addExportOperationProperties(propertyList, stamp);
        MoldBuilder.addPreviewOperationProperties(propertyList, stamp);
        MoldBuilder.addTaskOperationProperties(propertyList, stamp);
        MoldBuilder.addMapProperties(propertyList, stamp);
        result.propertyList(propertyList);
        return result;
    }

    private static String shapeOf(io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (stamp instanceof Title) {
            return "title";
        }
        if (stamp instanceof Description) {
            return "description";
        }
        if (stamp instanceof Icon) {
            return "icon";
        }
        if (stamp instanceof Rating) {
            return "rating";
        }
        if (stamp instanceof Highlight) {
            return "highlight";
        }
        if (stamp instanceof Picture) {
            return "picture";
        }
        if (stamp instanceof OpenDialogOperation) {
            return "open-dialog-operation";
        }
        if (stamp instanceof DownloadOperation) {
            return "download-operation";
        }
        if (stamp instanceof PreviewOperation) {
            return "preview-operation";
        }
        if (stamp instanceof ExportOperation) {
            return "export-operation";
        }
        if (stamp instanceof TaskOperation) {
            return "task-operation";
        }
        if (stamp instanceof Page) {
            return "page";
        }
        if (stamp instanceof Location) {
            return "location";
        }
        if (stamp instanceof Breadcrumbs) {
            return "breadcrumbs";
        }
        if (stamp instanceof ItemLinks) {
            return "item-links";
        }
        if (stamp instanceof CatalogLink) {
            return "catalog-link";
        }
        if (stamp instanceof Snippet) {
            return "snippet";
        }
        if (stamp instanceof CardWallet) {
            return "card-wallet";
        }
        if (stamp instanceof EmbeddedDisplay) {
            return "embedded-display";
        }
        if (stamp instanceof EmbeddedDialog) {
            return "embedded-dialog";
        }
        if (stamp instanceof EmbeddedCatalog) {
            return "embedded-catalog";
        }
        if (stamp instanceof TemporalCatalogRange) {
            return "temporal-catalog-range";
        }
        if (stamp instanceof TemporalCatalogRangeNavigator) {
            return "temporal-catalog-range-navigator";
        }
        if (stamp instanceof TemporalCatalogTime) {
            return "temporal-catalog-time";
        }
        if (stamp instanceof TemporalCatalogTimeNavigator) {
            return "temporal-catalog-time-navigator";
        }
        if (stamp instanceof Map) {
            return "map";
        }
        return "";
    }

    private static void addCommonProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!stamp.suffix().isEmpty()) {
            propertyList.add(MoldBuilder.shapeProperty("suffix", stamp.suffix()));
        }
        if (!stamp.defaultStyle().isEmpty()) {
            propertyList.add(MoldBuilder.shapeProperty("defaultStyle", stamp.defaultStyle()));
        }
    }

    private static void addRatingProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof Rating)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("icon", ((Rating)stamp).ratingIcon()));
    }

    private static void addEmbeddedDisplayProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof EmbeddedDisplay)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("displayType", ((EmbeddedDisplay)stamp).displayType()));
    }

    private static void addEmbeddedDialogProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof EmbeddedDialog)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("dialogType", ((EmbeddedDialog)stamp).dialogType()));
    }

    private static void addEmbeddedCatalogProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof EmbeddedCatalog)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("catalog", ((EmbeddedCatalog)stamp).catalog().name()));
    }

    private static void addIconProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof Icon)) {
            return;
        }
        propertyList.add(MoldBuilder.shapeProperty("icon-type", stamp instanceof AlexandriaIcon ? "alexandria" : ""));
    }

    private static void addOperationProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof Operation)) {
            return;
        }
        Operation previewStamp = (Operation)stamp;
        propertyList.add(MoldBuilder.shapeProperty("alexandriaIcon", previewStamp.alexandriaIcon()));
        propertyList.add(MoldBuilder.shapeProperty("mode", previewStamp.mode().toString()));
    }

    private static void addDownloadOperationProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof DownloadOperation)) {
            return;
        }
        DownloadOperation downloadStamp = (DownloadOperation)stamp;
        propertyList.add(MoldBuilder.shapeProperty("title", downloadStamp.label()));
        propertyList.add(MoldBuilder.shapeProperty("options", String.join((CharSequence)",", downloadStamp.options())));
        propertyList.add(MoldBuilder.shapeProperty("alexandriaIcon", downloadStamp.alexandriaIcon()));
    }

    private static void addExportOperationProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof ExportOperation)) {
            return;
        }
        ExportOperation exportStamp = (ExportOperation)stamp;
        propertyList.add(MoldBuilder.shapeProperty("title", exportStamp.label()));
        propertyList.add(MoldBuilder.shapeProperty("options", String.join((CharSequence)",", exportStamp.options())));
        propertyList.add(MoldBuilder.shapeProperty("from", String.valueOf(exportStamp.from().toEpochMilli())));
        propertyList.add(MoldBuilder.shapeProperty("to", String.valueOf(exportStamp.to().toEpochMilli())));
        propertyList.add(MoldBuilder.shapeProperty("alexandriaIcon", exportStamp.alexandriaIcon()));
    }

    private static void addPreviewOperationProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof PreviewOperation)) {
            return;
        }
        PreviewOperation previewStamp = (PreviewOperation)stamp;
        propertyList.add(MoldBuilder.shapeProperty("title", previewStamp.label()));
        propertyList.add(MoldBuilder.shapeProperty("alexandriaIcon", previewStamp.alexandriaIcon()));
    }

    private static void addTaskOperationProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof TaskOperation)) {
            return;
        }
        TaskOperation taskStamp = (TaskOperation)stamp;
        propertyList.add(MoldBuilder.shapeProperty("confirm", taskStamp.confirmText()));
    }

    private static void addMapProperties(List<Property> propertyList, io.intino.konos.alexandria.activity.model.mold.Stamp stamp) {
        if (!(stamp instanceof Map)) {
            return;
        }
        Map mapStamp = (Map)stamp;
        propertyList.add(MoldBuilder.shapeProperty("zoom", String.valueOf(mapStamp.zoom())));
        propertyList.add(MoldBuilder.shapeProperty("latitude", String.valueOf(mapStamp.latitude())));
        propertyList.add(MoldBuilder.shapeProperty("longitude", String.valueOf(mapStamp.longitude())));
    }

    private static Property shapeProperty(String name, String value) {
        return new Property().name(name).value(value);
    }
}

