/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.builders;

import com.google.gson.Gson;
import io.intino.konos.alexandria.activity.Asset;
import io.intino.konos.alexandria.activity.model.Item;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.model.mold.Block;
import io.intino.konos.alexandria.activity.model.mold.Stamp;
import io.intino.konos.alexandria.activity.model.mold.stamps.Breadcrumbs;
import io.intino.konos.alexandria.activity.model.mold.stamps.CardWallet;
import io.intino.konos.alexandria.activity.model.mold.stamps.CatalogLink;
import io.intino.konos.alexandria.activity.model.mold.stamps.Highlight;
import io.intino.konos.alexandria.activity.model.mold.stamps.Icon;
import io.intino.konos.alexandria.activity.model.mold.stamps.ItemLinks;
import io.intino.konos.alexandria.activity.model.mold.stamps.Links;
import io.intino.konos.alexandria.activity.model.mold.stamps.Location;
import io.intino.konos.alexandria.activity.model.mold.stamps.Picture;
import io.intino.konos.alexandria.activity.model.mold.stamps.Title;
import io.intino.konos.alexandria.activity.model.mold.stamps.Tree;
import io.intino.konos.alexandria.activity.model.mold.stamps.Wallet;
import io.intino.konos.alexandria.activity.model.mold.stamps.icons.ResourceIcon;
import io.intino.konos.alexandria.activity.model.mold.stamps.operations.PreviewOperation;
import io.intino.konos.alexandria.activity.schemas.ItemBlock;
import io.intino.konos.alexandria.activity.schemas.ItemStamp;
import io.intino.konos.alexandria.activity.schemas.Property;
import io.intino.konos.alexandria.activity.services.push.ActivitySession;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class ItemBuilder {
    public static io.intino.konos.alexandria.activity.schemas.Item build(Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        String id = item != null ? item.id() : UUID.randomUUID().toString();
        return new io.intino.konos.alexandria.activity.schemas.Item().name(new String(Base64.getEncoder().encode(id.getBytes()))).group(ItemBuilder.group(item, provider.scale())).label(ItemBuilder.label(item, provider)).itemBlockList(ItemBuilder.itemBlockList(item, provider, baseAssetUrl)).itemStampList(ItemBuilder.itemStampList(item, provider, baseAssetUrl));
    }

    public static io.intino.konos.alexandria.activity.schemas.Item buildOnlyLocation(Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        String id = item != null ? item.id() : UUID.randomUUID().toString();
        return new io.intino.konos.alexandria.activity.schemas.Item().name(new String(Base64.getEncoder().encode(id.getBytes()))).group(ItemBuilder.group(item, provider.scale())).label(ItemBuilder.label(item, provider)).itemBlockList(Collections.emptyList()).itemStampList(ItemBuilder.itemLocationStampList(item, provider, baseAssetUrl));
    }

    public static List<io.intino.konos.alexandria.activity.schemas.Item> buildList(List<Item> itemList, ItemBuilderProvider provider, URL baseAssetUrl) {
        return itemList.stream().map(item -> ItemBuilder.build(item, provider, baseAssetUrl)).collect(Collectors.toList());
    }

    public static List<io.intino.konos.alexandria.activity.schemas.Item> buildListOnlyLocation(List<Item> itemList, ItemBuilderProvider provider, URL baseAssetUrl) {
        return itemList.stream().map(item -> ItemBuilder.buildOnlyLocation(item, provider, baseAssetUrl)).collect(Collectors.toList());
    }

    private static String label(Item item, ItemBuilderProvider provider) {
        String defaultLabel = item != null ? item.name() : "";
        return provider.stamps().stream().filter(s -> s instanceof Title).findAny().map(stamp -> (String)stamp.value(item, provider.session())).orElse(defaultLabel);
    }

    private static Instant group(Item item, TimeScale scale) {
        if (item == null) {
            return null;
        }
        Instant created = item.created();
        return created != null ? scale.normalise(created) : null;
    }

    private static List<ItemBlock> itemBlockList(Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        return provider.blocks().stream().map(block -> ItemBuilder.itemBlock(item, provider, baseAssetUrl, block)).collect(Collectors.toList());
    }

    private static ItemBlock itemBlock(Item item, ItemBuilderProvider provider, URL baseAssetUrl, Block block) {
        return new ItemBlock().name(block.name()).hidden(block.hidden(item));
    }

    private static List<ItemStamp> itemStampList(Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        return provider.stamps().stream().map(stamp -> ItemBuilder.recordItemStamp(item, provider, baseAssetUrl, stamp)).collect(Collectors.toList());
    }

    private static List<ItemStamp> itemLocationStampList(Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        return provider.stamps().stream().filter(stamp -> stamp instanceof Location).map(stamp -> ItemBuilder.recordItemStamp(item, provider, baseAssetUrl, stamp)).collect(Collectors.toList());
    }

    private static ItemStamp recordItemStamp(Item item, ItemBuilderProvider provider, URL baseAssetUrl, Stamp stamp) {
        return new ItemStamp().name(stamp.name()).values(ItemBuilder.valuesOf(stamp, item, provider, baseAssetUrl)).propertyList(ItemBuilder.propertiesOf(stamp, item, provider, baseAssetUrl));
    }

    private static List<String> valuesOf(Stamp stamp, Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        Object value = stamp.value(item, provider.session());
        if (value instanceof List) {
            List<Asset.Resource> values = (List<Asset.Resource>)value;
            if (values.isEmpty() && stamp instanceof Picture) {
                values = Collections.singletonList(Asset.toResource(baseAssetUrl, ((Picture)stamp).defaultPicture()));
            }
            return values.stream().map(v -> ItemBuilder.valueOf(stamp, v, baseAssetUrl)).collect(Collectors.toList());
        }
        return Collections.singletonList(ItemBuilder.valueOf(stamp, value, baseAssetUrl));
    }

    private static String valueOf(Stamp stamp, Object value, URL baseAssetUrl) {
        if (stamp instanceof Breadcrumbs) {
            Tree tree = (Tree)value;
            return tree != null ? new Gson().toJson((Object)tree) : "";
        }
        if (stamp instanceof CardWallet) {
            Wallet wallet = (Wallet)value;
            return wallet != null ? new Gson().toJson((Object)wallet) : "";
        }
        if (stamp instanceof ItemLinks) {
            Links links = (Links)value;
            return links != null ? new Gson().toJson((Object)links) : "";
        }
        if (stamp instanceof Picture) {
            if (value == null) {
                String defaultPicture = ((Picture)stamp).defaultPicture();
                return defaultPicture != null ? Asset.toResource(baseAssetUrl, defaultPicture).toUrl().toString() : "";
            }
            return Asset.toResource(baseAssetUrl, (URL)value).toUrl().toString();
        }
        if (stamp instanceof ResourceIcon) {
            return value != null ? Asset.toResource(baseAssetUrl, (URL)value).toUrl().toString() : "";
        }
        return value != null ? String.valueOf(value) : "";
    }

    private static List<Property> propertiesOf(Stamp stamp, Item item, ItemBuilderProvider provider, URL baseAssetUrl) {
        URL preview;
        ArrayList<Property> result = new ArrayList<Property>();
        ActivitySession session = provider.session();
        String style = stamp.style(item, session);
        if (style != null && !style.isEmpty()) {
            result.add(ItemBuilder.propertyOf("style", style));
        }
        if (stamp instanceof Highlight) {
            result.add(ItemBuilder.propertyOf("color", ((Highlight)stamp).color(item, session)));
        }
        if (stamp instanceof ItemLinks) {
            result.add(ItemBuilder.propertyOf("title", ((ItemLinks)stamp).title(item, session)));
        }
        if (stamp instanceof CatalogLink) {
            result.add(ItemBuilder.propertyOf("title", (String)((CatalogLink)stamp).value(item, session)));
        }
        if (stamp instanceof Location) {
            String drawingColor;
            Location location = (Location)stamp;
            URL icon = location.icon(item, session);
            if (icon != null) {
                result.add(ItemBuilder.propertyOf("icon", Asset.toResource(baseAssetUrl, icon).toUrl().toString()));
            }
            if ((drawingColor = location.drawingColor(item, session)) != null) {
                result.add(ItemBuilder.propertyOf("drawingColor", drawingColor));
            }
        }
        if (stamp instanceof PreviewOperation && (preview = ((PreviewOperation)stamp).preview(item, session)) != null) {
            result.add(ItemBuilder.propertyOf("document", Asset.toResource(baseAssetUrl, preview).setEmbedded(true).toUrl().toString()));
        }
        if (stamp instanceof Icon) {
            result.add(ItemBuilder.propertyOf("title", ((Icon)stamp).title(item, session)));
        }
        return result;
    }

    private static Property propertyOf(String name, String value) {
        return new Property().name(name).value(value);
    }

    public static interface ItemBuilderProvider {
        public List<Block> blocks();

        public List<Stamp> stamps();

        public ActivitySession session();

        public TimeScale scale();
    }
}

