/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.builders;

import io.intino.konos.alexandria.activity.displays.ElementView;
import io.intino.konos.alexandria.activity.displays.builders.MoldBuilder;
import io.intino.konos.alexandria.activity.model.catalog.views.MapView;
import io.intino.konos.alexandria.activity.model.toolbar.Download;
import io.intino.konos.alexandria.activity.model.toolbar.DownloadSelection;
import io.intino.konos.alexandria.activity.model.toolbar.Export;
import io.intino.konos.alexandria.activity.model.toolbar.ExportSelection;
import io.intino.konos.alexandria.activity.model.toolbar.GroupingSelection;
import io.intino.konos.alexandria.activity.model.toolbar.OpenDialog;
import io.intino.konos.alexandria.activity.model.toolbar.TaskSelection;
import io.intino.konos.alexandria.activity.schemas.Center;
import io.intino.konos.alexandria.activity.schemas.Operation;
import io.intino.konos.alexandria.activity.schemas.Property;
import io.intino.konos.alexandria.activity.schemas.Toolbar;
import io.intino.konos.alexandria.activity.schemas.Zoom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ElementViewBuilder {
    public static io.intino.konos.alexandria.activity.schemas.ElementView build(ElementView view) {
        io.intino.konos.alexandria.activity.schemas.ElementView result = new io.intino.konos.alexandria.activity.schemas.ElementView().name(view.name()).label(view.label());
        if (view.toolbar() != null) {
            result.toolbar(ElementViewBuilder.buildToolbar(view.toolbar()));
        }
        result.embeddedElement(view.embeddedElement());
        result.mold(MoldBuilder.build(view.mold()));
        result.type(view.type());
        result.width(view.width());
        result.canSearch(view.canSearch());
        result.canCreateClusters(view.canCreateClusters());
        result.clusters(view.clusters());
        result.emptyMessage(view.emptyMessage() != null ? view.emptyMessage() : "");
        ElementViewBuilder.addMapViewProperties(result, view);
        return result;
    }

    private static Toolbar buildToolbar(io.intino.konos.alexandria.activity.model.Toolbar toolbar) {
        Toolbar result = new Toolbar();
        toolbar.operations().forEach(op -> result.operationList().add(ElementViewBuilder.buildOperation(op)));
        return result;
    }

    private static Operation buildOperation(io.intino.konos.alexandria.activity.model.toolbar.Operation operation) {
        Operation result = new Operation().title(operation.title()).name(operation.name());
        result.type(ElementViewBuilder.type(operation));
        result.icon(operation.alexandriaIcon());
        result.when(ElementViewBuilder.when(operation));
        result.propertyList(ElementViewBuilder.propertiesOf(operation));
        return result;
    }

    private static String when(io.intino.konos.alexandria.activity.model.toolbar.Operation operation) {
        if (operation instanceof TaskSelection || operation instanceof ExportSelection || operation instanceof DownloadSelection || operation instanceof GroupingSelection) {
            return "Selection";
        }
        return "Always";
    }

    private static List<Property> propertiesOf(io.intino.konos.alexandria.activity.model.toolbar.Operation operation) {
        if (operation instanceof Download) {
            return Collections.singletonList(ElementViewBuilder.propertyOf("options", String.join((CharSequence)",", ((Download)operation).options())));
        }
        if (operation instanceof DownloadSelection) {
            return Collections.singletonList(ElementViewBuilder.propertyOf("options", String.join((CharSequence)",", ((DownloadSelection)operation).options())));
        }
        if (operation instanceof Export) {
            final Export export = (Export)operation;
            return new ArrayList<Property>(){
                {
                    this.add(ElementViewBuilder.propertyOf("from", String.valueOf(export.from().toEpochMilli())));
                    this.add(ElementViewBuilder.propertyOf("to", String.valueOf(export.to().toEpochMilli())));
                }
            };
        }
        if (operation instanceof ExportSelection) {
            final ExportSelection exportSelection = (ExportSelection)operation;
            return new ArrayList<Property>(){
                {
                    this.add(ElementViewBuilder.propertyOf("from", String.valueOf(exportSelection.from().toEpochMilli())));
                    this.add(ElementViewBuilder.propertyOf("to", String.valueOf(exportSelection.to().toEpochMilli())));
                }
            };
        }
        return Collections.emptyList();
    }

    private static Property propertyOf(String name, String value) {
        return new Property().name(name).value(value);
    }

    private static String type(io.intino.konos.alexandria.activity.model.toolbar.Operation operation) {
        if (operation instanceof Download || operation instanceof DownloadSelection) {
            return "download";
        }
        if (operation instanceof Export || operation instanceof ExportSelection) {
            return "export";
        }
        if (operation instanceof OpenDialog) {
            return "open-dialog";
        }
        if (operation instanceof GroupingSelection) {
            return "grouping";
        }
        return "operation";
    }

    public static List<io.intino.konos.alexandria.activity.schemas.ElementView> buildList(List<ElementView> viewList) {
        return viewList.stream().map(ElementViewBuilder::build).collect(Collectors.toList());
    }

    private static void addMapViewProperties(io.intino.konos.alexandria.activity.schemas.ElementView result, ElementView view) {
        Object rawView = view.raw();
        if (!(rawView instanceof MapView)) {
            return;
        }
        MapView mapView = (MapView)rawView;
        MapView.Zoom zoom = mapView.zoom();
        MapView.Center center = mapView.center();
        result.center(new Center().latitude(center.latitude()).longitude(center.longitude()));
        result.zoom(new Zoom().min(zoom.min()).max(zoom.max()).defaultValue(zoom.defaultZoom()));
    }
}

