/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.intino.konos.alexandria.activity.displays.adapters.CheckBoxInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.ComboBoxInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.DateInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.DateTimeInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.FileInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.MemoInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.PasswordInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.PictureInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.RadioBoxInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.SectionInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.TextInputAdapter;
import io.intino.konos.alexandria.activity.displays.adapters.gson.ValueAdapter;
import io.intino.konos.alexandria.activity.model.Dialog;
import io.intino.konos.alexandria.activity.model.dialog.Value;

public class DialogInputBuilder {
    public static JsonObject build(Dialog.Tab.Input input) {
        JsonObject result = new JsonObject();
        result.addProperty("label", input.label());
        result.addProperty("type", input.getClass().getSimpleName().toLowerCase());
        result.addProperty("required", Boolean.valueOf(input.required()));
        result.addProperty("readonly", Boolean.valueOf(input.readonly()));
        result.addProperty("visible", Boolean.valueOf(input.visible()));
        result.addProperty("helper", input.helper());
        result.addProperty("defaultValue", DialogInputBuilder.value(input.defaultValue()));
        if (input.placeholder() != null) {
            result.addProperty("placeholder", input.placeholder());
        }
        result.add("value", DialogInputBuilder.values(input));
        if (input.isMultiple()) {
            result.add("multiple", (JsonElement)DialogInputBuilder.multiple(input));
        }
        TextInputAdapter.adapt(result, input);
        MemoInputAdapter.adapt(result, input);
        PasswordInputAdapter.adapt(result, input);
        RadioBoxInputAdapter.adapt(result, input);
        CheckBoxInputAdapter.adapt(result, input);
        ComboBoxInputAdapter.adapt(result, input);
        FileInputAdapter.adapt(result, input);
        PictureInputAdapter.adapt(result, input);
        DateInputAdapter.adapt(result, input);
        DateTimeInputAdapter.adapt(result, input);
        SectionInputAdapter.adapt(result, input);
        return result;
    }

    private static JsonObject multiple(Dialog.Tab.Input input) {
        JsonObject result = new JsonObject();
        result.addProperty("min", (Number)input.multiple().min());
        result.addProperty("max", (Number)input.multiple().max());
        return result;
    }

    private static String value(Object value) {
        if (value instanceof Value) {
            return ValueAdapter.value(((Value)value).asObject());
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    private static JsonElement values(Dialog.Tab.Input input) {
        if (!input.isMultiple()) {
            return new JsonPrimitive(DialogInputBuilder.value(input.value()));
        }
        JsonArray result = new JsonArray();
        input.values().forEach(value -> result.add((JsonElement)new JsonPrimitive(DialogInputBuilder.value(value))));
        return result;
    }
}

