/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.intino.konos.alexandria.activity.displays.builders.DialogInputBuilder;
import io.intino.konos.alexandria.activity.model.Dialog;
import io.intino.konos.alexandria.activity.schemas.Dialog;
import java.util.List;

public class DialogBuilder {
    public static Dialog build(io.intino.konos.alexandria.activity.model.Dialog dialog) {
        return new Dialog().label(dialog.label()).description(dialog.description()).definition(DialogBuilder.jsonDefinitionOf(dialog).toString());
    }

    public static JsonObject jsonDefinitionOf(io.intino.konos.alexandria.activity.model.Dialog dialog) {
        JsonObject result = new JsonObject();
        result.add("label", (JsonElement)new JsonPrimitive(dialog.label()));
        result.add("description", (JsonElement)new JsonPrimitive(dialog.description()));
        result.addProperty("readonly", Boolean.valueOf(dialog.readonly()));
        result.add("toolbar", (JsonElement)DialogBuilder.jsonToolbar(dialog.toolbar()));
        result.add("tabList", (JsonElement)DialogBuilder.jsonTabListOf(dialog.tabList()));
        return result;
    }

    public static JsonObject jsonToolbar(Dialog.Toolbar toolbar) {
        JsonObject result = new JsonObject();
        result.add("operationList", (JsonElement)DialogBuilder.jsonOperationList(toolbar.operationList()));
        return result;
    }

    public static JsonArray jsonOperationList(List<Dialog.Toolbar.Operation> operationList) {
        JsonArray result = new JsonArray();
        operationList.forEach(operation -> result.add((JsonElement)DialogBuilder.jsonOperationOf(operation)));
        return result;
    }

    public static JsonObject jsonOperationOf(Dialog.Toolbar.Operation operation) {
        JsonObject result = new JsonObject();
        result.addProperty("name", operation.name());
        result.addProperty("label", operation.label());
        return result;
    }

    public static JsonArray jsonTabListOf(List<Dialog.Tab> tabList) {
        JsonArray result = new JsonArray();
        tabList.forEach(tab -> result.add((JsonElement)DialogBuilder.jsonTabOf(tab)));
        return result;
    }

    public static JsonObject jsonTabOf(Dialog.Tab tab) {
        JsonObject result = new JsonObject();
        result.addProperty("label", tab.label());
        result.add("inputList", (JsonElement)DialogBuilder.jsonInputListOf(tab.inputList()));
        return result;
    }

    public static JsonArray jsonInputListOf(List<Dialog.Tab.Input> inputList) {
        JsonArray result = new JsonArray();
        inputList.forEach(input -> result.add((JsonElement)DialogBuilder.jsonInputOf(input)));
        return result;
    }

    public static JsonObject jsonInputOf(Dialog.Tab.Input input) {
        return DialogInputBuilder.build(input);
    }
}

