/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays.builders;

import io.intino.konos.alexandria.activity.displays.builders.CatalogSortingBuilder;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.GroupingManager;
import io.intino.konos.alexandria.activity.model.catalog.arrangement.Sorting;
import io.intino.konos.alexandria.activity.schemas.Catalog;
import io.intino.konos.alexandria.activity.schemas.Group;
import io.intino.konos.alexandria.activity.schemas.Grouping;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CatalogBuilder {
    public static Catalog build(io.intino.konos.alexandria.activity.model.Catalog catalog, GroupingManager manager, String label, boolean embedded) {
        return new Catalog().name(catalog.name()).label(label).embedded(embedded).hideGroupings(catalog.groupings().size() <= 0 || CatalogBuilder.allGroupingsEmpty(catalog, manager)).groupingList(CatalogBuilder.buildGroupingList(catalog, manager)).sortingList(CatalogBuilder.buildSortingList(catalog)).arrangementHistogramsMode(catalog.arrangementHistogramsMode().toString()).mode(catalog.mode().toString());
    }

    private static boolean allGroupingsEmpty(io.intino.konos.alexandria.activity.model.Catalog catalog, GroupingManager manager) {
        return catalog.groupings().stream().filter(g -> !manager.groups((io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping)g).isEmpty()).count() <= 0L;
    }

    private static List<Grouping> buildGroupingList(io.intino.konos.alexandria.activity.model.Catalog catalog, GroupingManager manager) {
        return catalog.groupings().stream().map(g -> CatalogBuilder.buildGrouping(g, manager)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Grouping buildGrouping(io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping grouping, GroupingManager manager) {
        List<Group> groupList = CatalogBuilder.buildGroupList(grouping, manager);
        int countItems = groupList.stream().mapToInt(Group::count).sum();
        if (countItems <= 0) {
            return null;
        }
        return new Grouping().name(grouping.name()).label(grouping.label()).histogram(grouping.histogram().toString()).type(CatalogBuilder.typeOf(grouping)).groupList(groupList).countItems(countItems);
    }

    private static List<io.intino.konos.alexandria.activity.schemas.Sorting> buildSortingList(io.intino.konos.alexandria.activity.model.Catalog catalog) {
        return CatalogSortingBuilder.buildList(catalog.sortings().stream().filter(Sorting::visible).collect(Collectors.toList()));
    }

    private static String typeOf(io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping grouping) {
        return !grouping.cluster() ? "Grouping" : "ClusterGrouping";
    }

    private static List<Group> buildGroupList(io.intino.konos.alexandria.activity.model.catalog.arrangement.Grouping grouping, GroupingManager manager) {
        List<io.intino.konos.alexandria.activity.model.catalog.arrangement.Group> groups = manager.groups(grouping).toList();
        List<String> selected = manager.filteredGroups(grouping);
        return groups.stream().map(g -> CatalogBuilder.buildGroup(g, selected.contains(io.intino.konos.alexandria.activity.model.catalog.arrangement.Group.name(g.label())))).collect(Collectors.toList());
    }

    private static Group buildGroup(io.intino.konos.alexandria.activity.model.catalog.arrangement.Group group, boolean selected) {
        return new Group().name(group.name()).label(group.label()).selected(selected).count(group.countObjects());
    }
}

