/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.ActivityDisplay;
import io.intino.konos.alexandria.activity.displays.AlexandriaDisplayNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class PageDisplay<N extends AlexandriaDisplayNotifier>
extends ActivityDisplay<N, Box> {
    private int page = 0;
    private int pageSize = 20;
    private List<Consumer<List<String>>> selectListeners = new ArrayList<Consumer<List<String>>>();
    private static final int PageSize = 20;

    public PageDisplay(Box box) {
        super(box);
    }

    public void addSelectListener(Consumer<List<String>> listener) {
        this.selectListeners.add(listener);
    }

    public int page() {
        return this.page;
    }

    public void page(int index) {
        this.page = index;
        this.checkPageRange();
        this.sendItems(this.start(), this.limit());
    }

    public void pageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void previousPage() {
        this.page(this.page--);
    }

    public void nextPage() {
        this.page(this.page++);
    }

    public void firstPage() {
        this.page(0);
    }

    public void lastPage() {
        this.page(this.countPages() - 1);
    }

    public int countPages() {
        long countItems = this.countItems();
        return (int)(Math.floor(countItems / (long)this.pageSize) + (double)(countItems % (long)this.pageSize > 0L ? 1 : 0));
    }

    @Override
    public void refresh() {
        this.sendClear();
        this.sendCount(this.countItems());
        this.page(0);
    }

    public abstract int countItems();

    @Override
    protected void init() {
        super.init();
        this.sendPageSize(this.pageSize);
    }

    protected abstract void sendItems(int var1, int var2);

    protected abstract void sendClear();

    protected abstract void sendPageSize(int var1);

    protected abstract void sendCount(int var1);

    protected void notifySelectListeners(List<String> selection) {
        this.selectListeners.forEach(listener -> listener.accept(selection));
    }

    private void checkPageRange() {
        int countPages;
        if (this.page <= 0) {
            this.page = 0;
        }
        if (this.page >= (countPages = this.countPages()) && countPages > 0) {
            this.page = countPages - 1;
        }
    }

    private int start() {
        return this.page * this.pageSize;
    }

    private int limit() {
        return this.pageSize;
    }
}

