/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaNavigator;
import io.intino.konos.alexandria.activity.displays.builders.RangeBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ScaleBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaTimeRangeNavigatorNotifier;
import io.intino.konos.alexandria.activity.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.schemas.RequestRange;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class AlexandriaTimeRangeNavigator
extends AlexandriaNavigator<AlexandriaTimeRangeNavigatorNotifier> {
    private List<Consumer<TimeRange>> moveListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> moveNextListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> movePreviousListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> fromListeners = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> scaleListener = new ArrayList<Consumer<TimeRange>>();
    private List<Consumer<TimeRange>> toListeners = new ArrayList<Consumer<TimeRange>>();
    private TimeRange boundsRange = null;

    public AlexandriaTimeRangeNavigator(Box box) {
        super(box);
    }

    @Override
    protected void init() {
        super.init();
        TimeRange range = this.timeScaleHandler().range();
        this.boundsRange = this.timeScaleHandler().boundsRange();
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshScales(ScaleBuilder.buildList(this.scales(), this.currentLanguage()));
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshZoomRange(RangeBuilder.build(this.timeScaleHandler().zoomRange()));
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshOlapRange(RangeBuilder.build(this.boundsRange));
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshRange(RangeBuilder.build(range));
    }

    @Override
    protected void addListeners(TimeScaleHandler timeScaleHandler) {
        timeScaleHandler.onRangeChange(tr -> {
            this.updateBoundsRangeIfNeeded();
            ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshRange(RangeBuilder.build(tr));
        });
        timeScaleHandler.onScaleChange(tr -> ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshRange(RangeBuilder.build(tr)));
    }

    private void updateBoundsRangeIfNeeded() {
        Instant from = this.timeScaleHandler().boundsRange().from();
        Instant to = this.timeScaleHandler().boundsRange().to();
        if (from == this.boundsRange.from() && to == this.boundsRange.to()) {
            return;
        }
        this.boundsRange = this.timeScaleHandler().boundsRange();
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshOlapRange(RangeBuilder.build(this.boundsRange));
    }

    public void onMove(Consumer<TimeRange> listener) {
        this.moveListeners.add(listener);
    }

    public void onMoveNext(Consumer<TimeRange> listener) {
        this.moveNextListeners.add(listener);
    }

    public void onMovePrevious(Consumer<TimeRange> listener) {
        this.movePreviousListeners.add(listener);
    }

    public void onFromChange(Consumer<TimeRange> listener) {
        this.fromListeners.add(listener);
    }

    public void onToChange(Consumer<TimeRange> listener) {
        this.toListeners.add(listener);
    }

    public void selectScale(String scale) {
        this.timeScaleHandler().updateScale(TimeScale.valueOf(scale));
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshRange(RangeBuilder.build(this.timeScaleHandler().range()));
    }

    public void moveNext() {
        TimeRange timeRange = this.timeScaleHandler().moveRight(1);
        this.moveNextListeners.forEach(l -> l.accept(timeRange));
    }

    public void movePrevious() {
        TimeRange timeRange = this.timeScaleHandler().moveLeft(1);
        this.movePreviousListeners.forEach(l -> l.accept(timeRange));
    }

    public void move(RequestRange range) {
        TimeRange timeRange = this.timeScaleHandler().move(range.from(), range.to());
        this.moveListeners.forEach(l -> l.accept(timeRange));
    }

    public void selectFrom(Instant value) {
        TimeRange timeRange = this.timeScaleHandler().updateRangeFrom(value);
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshRange(RangeBuilder.build(this.timeScaleHandler().range()));
        this.fromListeners.forEach(l -> l.accept(timeRange));
    }

    public void selectTo(Instant value) {
        TimeRange timeRange = this.timeScaleHandler().updateRangeTo(value);
        ((AlexandriaTimeRangeNavigatorNotifier)this.notifier).refreshRange(RangeBuilder.build(this.timeScaleHandler().range()));
        this.toListeners.forEach(l -> l.accept(timeRange));
    }
}

