/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.alexandria.activity.displays;

import io.intino.konos.alexandria.Box;
import io.intino.konos.alexandria.activity.displays.AlexandriaNavigator;
import io.intino.konos.alexandria.activity.displays.builders.RangeBuilder;
import io.intino.konos.alexandria.activity.displays.builders.ScaleBuilder;
import io.intino.konos.alexandria.activity.displays.notifiers.AlexandriaTimeNavigatorNotifier;
import io.intino.konos.alexandria.activity.helpers.TimeScaleHandler;
import io.intino.konos.alexandria.activity.model.TimeRange;
import io.intino.konos.alexandria.activity.model.TimeScale;
import io.intino.konos.alexandria.activity.schemas.DateNavigatorState;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;

public class AlexandriaTimeNavigator
extends AlexandriaNavigator<AlexandriaTimeNavigatorNotifier> {
    private Instant date;
    private TimeScale scale;
    private List<Consumer<Instant>> moveListeners = new ArrayList<Consumer<Instant>>();
    private Timer playerStepTimer = null;
    private Timer moveTimer = null;
    private static final int PlayDelay = 3000;

    public AlexandriaTimeNavigator(Box box) {
        super(box);
    }

    @Override
    protected void addListeners(TimeScaleHandler timeScaleHandler) {
        timeScaleHandler.onRangeChange(this::refreshDate);
        timeScaleHandler.onScaleChange(this::refreshScale);
    }

    @Override
    protected void init() {
        super.init();
        TimeRange range = this.timeScaleHandler().range();
        this.scale = range.scale();
        this.date = this.scale.normalise(range.from());
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshScales(ScaleBuilder.buildList(this.scales(), this.currentLanguage()));
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshScale(this.scale.name());
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshOlapRange(RangeBuilder.build(this.timeScaleHandler().boundsRange()));
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshDate(this.date);
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshState(this.state());
    }

    public TimeScale scale() {
        return this.scale;
    }

    public void selectScale(String value) {
        TimeScale scale = TimeScale.valueOf(value);
        this.updateDate(scale, this.date);
        this.timeScaleHandler().updateInstant(this.date, scale);
        this.notifyMove(this.date);
    }

    public Instant date() {
        return this.date;
    }

    public void selectDate(Instant date) {
        this.updateDate(this.scale, date);
        this.timeScaleHandler().updateInstant(this.date, this.scale);
        this.notifyMove(this.date);
    }

    public void lastDate() {
        this.updateDate(this.scale, this.timeScaleHandler().boundsRange().to());
        this.timeScaleHandler().updateInstant(this.date, this.scale);
        this.notifyMove(this.date);
    }

    public void previousDate() {
        this.addToDate(-1);
        this.notifyMoveDelayed();
    }

    public void play() {
        this.playerStep();
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshState(this.state());
    }

    public void pause() {
        if (this.playerStepTimer == null) {
            return;
        }
        this.playerStepTimer.cancel();
        this.playerStepTimer = null;
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshState(this.state());
    }

    private void playerStep() {
        if (!this.canNext().booleanValue()) {
            this.playerStepTimer = null;
            return;
        }
        this.nextDate();
        this.playerStepTimer = new Timer();
        this.playerStepTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                AlexandriaTimeNavigator.this.playerStep();
                ((AlexandriaTimeNavigatorNotifier)AlexandriaTimeNavigator.this.notifier).refreshState(AlexandriaTimeNavigator.this.state());
            }
        }, 3000L);
    }

    public void nextDate() {
        if (this.date.isAfter(Instant.now())) {
            return;
        }
        this.addToDate(1);
        this.notifyMoveDelayed();
    }

    private void notifyMoveDelayed() {
        if (this.moveTimer != null) {
            this.moveTimer.cancel();
        }
        this.moveTimer = new Timer();
        this.moveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                AlexandriaTimeNavigator.this.notifyMove(AlexandriaTimeNavigator.this.date);
            }
        }, 500L);
    }

    public void onMove(Consumer<Instant> listener) {
        this.moveListeners.add(listener);
    }

    private void addToDate(int count) {
        this.date = this.scale.addTo(this.date, count);
        this.timeScaleHandler().updateInstant(this.scale.normalise(this.date), this.scale);
    }

    private void notifyMove(Instant value) {
        this.moveListeners.forEach(l -> l.accept(value));
    }

    private DateNavigatorState state() {
        return new DateNavigatorState().canPrevious(this.canPrevious()).canNext(this.canNext()).canPlay(this.canNext()).playing(this.playerStepTimer != null);
    }

    private Boolean canPrevious() {
        TimeRange range = this.timeScaleHandler().boundsRange();
        return this.date.isAfter(this.scale.normalise(range.from()));
    }

    private Boolean canNext() {
        TimeRange range = this.timeScaleHandler().boundsRange();
        Instant maxDate = this.scale.addTo(this.scale.normalise(range.to()), -1L);
        return this.date.isBefore(maxDate) || this.date.equals(maxDate);
    }

    private void refreshDate(TimeRange timeRange) {
        this.date = this.scale.normalise(timeRange.from());
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshDate(this.date);
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshState(this.state());
    }

    private void refreshScale(TimeRange timeRange) {
        this.scale = timeRange.scale();
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshDate(this.date);
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshScale(this.scale.name());
        ((AlexandriaTimeNavigatorNotifier)this.notifier).refreshState(this.state());
    }

    private void updateDate(TimeScale scale, Instant date) {
        TimeRange range = this.timeScaleHandler().boundsRange();
        this.date = scale.normalise(date);
        if (date.isBefore(range.from())) {
            this.date = scale.normalise(range.from());
        }
        if (date.isAfter(range.to())) {
            this.date = scale.normalise(range.to());
        }
    }
}

